/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.BlockRegister;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.Entity;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NibbleArray;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class Chunk {
    public static boolean a;
    public byte[] b;
    public boolean c;
    public World world;
    public NibbleArray e;
    public NibbleArray f;
    public NibbleArray g;
    public byte[] heightMap;
    public int i;
    public final int x;
    public final int z;
    public Map tileEntities = new HashMap();
    public List[] entitySlices = new List[8];
    public boolean done = false;
    public boolean o = false;
    public boolean p;
    public boolean q = false;
    public long r = 0L;

    public Chunk(World world, int n, int n2) {
        this.world = world;
        this.x = n;
        this.z = n2;
        this.heightMap = new byte[256];
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.entitySlices[i] = new ArrayList();
        }
    }

    public Chunk(World world, byte[] byArray, int n, int n2) {
        this(world, n, n2);
        this.b = byArray;
        this.e = new NibbleArray(byArray.length);
        this.f = new NibbleArray(byArray.length);
        this.g = new NibbleArray(byArray.length);
    }

    public boolean a(int n, int n2) {
        return n == this.x && n2 == this.z;
    }

    public int b(int n, int n2) {
        return this.heightMap[n2 << 4 | n] & 0xFF;
    }

    public void a() {
    }

    public void initLighting() {
        int n;
        int n2;
        int n3 = 127;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                int n4;
                int n5 = n2 << 11 | n << 7;
                for (n4 = 127; n4 > 0 && Block.q[this.b[n5 + n4 - 1] & 0xFF] == 0; --n4) {
                }
                this.heightMap[n << 4 | n2] = (byte)n4;
                if (n4 < n3) {
                    n3 = n4;
                }
                if (this.world.worldProvider.e) continue;
                int n6 = 15;
                int n7 = 127;
                do {
                    if ((n6 -= Block.q[this.b[n5 + n7] & 0xFF]) <= 0) continue;
                    this.f.a(n2, n7, n, n6);
                } while (--n7 > 0 && n6 > 0);
            }
        }
        this.i = n3;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                this.c(n2, n);
            }
        }
        this.o = true;
    }

    public void loadNOP() {
    }

    private void c(int n, int n2) {
        int n3 = this.b(n, n2);
        int n4 = this.x * 16 + n;
        int n5 = this.z * 16 + n2;
        this.f(n4 - 1, n5, n3);
        this.f(n4 + 1, n5, n3);
        this.f(n4, n5 - 1, n3);
        this.f(n4, n5 + 1, n3);
    }

    private void f(int n, int n2, int n3) {
        int n4 = this.world.getHighestBlockYAt(n, n2);
        if (n4 > n3) {
            this.world.a(EnumSkyBlock.SKY, n, n3, n2, n, n4, n2);
            this.o = true;
        } else if (n4 < n3) {
            this.world.a(EnumSkyBlock.SKY, n, n4, n2, n, n3, n2);
            this.o = true;
        }
    }

    private void g(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = this.heightMap[n3 << 4 | n] & 0xFF;
        if (n2 > n4) {
            n5 = n2;
        }
        int n6 = n << 11 | n3 << 7;
        while (n5 > 0 && Block.q[this.b[n6 + n5 - 1] & 0xFF] == 0) {
            --n5;
        }
        if (n5 != n4) {
            int n7;
            int n8;
            this.world.g(n, n3, n5, n4);
            this.heightMap[n3 << 4 | n] = (byte)n5;
            if (n5 < this.i) {
                this.i = n5;
            } else {
                n6 = 127;
                for (n8 = 0; n8 < 16; ++n8) {
                    for (n7 = 0; n7 < 16; ++n7) {
                        if ((this.heightMap[n7 << 4 | n8] & 0xFF) >= n6) continue;
                        n6 = this.heightMap[n7 << 4 | n8] & 0xFF;
                    }
                }
                this.i = n6;
            }
            n6 = this.x * 16 + n;
            n8 = this.z * 16 + n3;
            if (n5 < n4) {
                for (n7 = n5; n7 < n4; ++n7) {
                    this.f.a(n, n7, n3, 15);
                }
            } else {
                this.world.a(EnumSkyBlock.SKY, n6, n4, n8, n6, n5, n8);
                for (n7 = n4; n7 < n5; ++n7) {
                    this.f.a(n, n7, n3, 0);
                }
            }
            n7 = 15;
            int n9 = n5;
            while (n5 > 0 && n7 > 0) {
                int n10;
                if ((n10 = Block.q[this.getTypeId(n, --n5, n3)]) == 0) {
                    n10 = 1;
                }
                if ((n7 -= n10) < 0) {
                    n7 = 0;
                }
                this.f.a(n, n5, n3, n7);
            }
            while (n5 > 0 && Block.q[this.getTypeId(n, n5 - 1, n3)] == 0) {
                --n5;
            }
            if (n5 != n9) {
                this.world.a(EnumSkyBlock.SKY, n6 - 1, n5, n8 - 1, n6 + 1, n9, n8 + 1);
            }
            this.o = true;
        }
    }

    public int getTypeId(int n, int n2, int n3) {
        return this.b[n << 11 | n3 << 7 | n2] & 0xFF;
    }

    public boolean a(int n, int n2, int n3, int n4, int n5) {
        byte by = (byte)n4;
        int n6 = this.heightMap[n3 << 4 | n] & 0xFF;
        int n7 = this.b[n << 11 | n3 << 7 | n2] & 0xFF;
        if (n7 == n4 && this.e.a(n, n2, n3) == n5) {
            return false;
        }
        int n8 = this.x * 16 + n;
        int n9 = this.z * 16 + n3;
        this.b[n << 11 | n3 << 7 | n2] = (byte)(by & 0xFF);
        if (n7 != 0 && !this.world.isStatic) {
            Block.byId[n7].remove(this.world, n8, n2, n9);
        }
        this.e.a(n, n2, n3, n5);
        if (!this.world.worldProvider.e) {
            if (Block.q[by & 0xFF] != 0) {
                if (n2 >= n6) {
                    this.g(n, n2 + 1, n3);
                }
            } else if (n2 == n6 - 1) {
                this.g(n, n2, n3);
            }
            this.world.a(EnumSkyBlock.SKY, n8, n2, n9, n8, n2, n9);
        }
        this.world.a(EnumSkyBlock.BLOCK, n8, n2, n9, n8, n2, n9);
        this.c(n, n3);
        this.e.a(n, n2, n3, n5);
        if (n4 != 0) {
            Block.byId[n4].e(this.world, n8, n2, n9);
        }
        this.o = true;
        return true;
    }

    public boolean a(int n, int n2, int n3, int n4) {
        byte by = (byte)n4;
        int n5 = this.heightMap[n3 << 4 | n] & 0xFF;
        int n6 = this.b[n << 11 | n3 << 7 | n2] & 0xFF;
        if (n6 == n4) {
            return false;
        }
        int n7 = this.x * 16 + n;
        int n8 = this.z * 16 + n3;
        this.b[n << 11 | n3 << 7 | n2] = (byte)(by & 0xFF);
        if (n6 != 0) {
            Block.byId[n6].remove(this.world, n7, n2, n8);
        }
        this.e.a(n, n2, n3, 0);
        if (Block.q[by & 0xFF] != 0) {
            if (n2 >= n5) {
                this.g(n, n2 + 1, n3);
            }
        } else if (n2 == n5 - 1) {
            this.g(n, n2, n3);
        }
        this.world.a(EnumSkyBlock.SKY, n7, n2, n8, n7, n2, n8);
        this.world.a(EnumSkyBlock.BLOCK, n7, n2, n8, n7, n2, n8);
        this.c(n, n3);
        if (n4 != 0 && !this.world.isStatic) {
            Block.byId[n4].e(this.world, n7, n2, n8);
        }
        this.o = true;
        return true;
    }

    public int getData(int n, int n2, int n3) {
        return this.e.a(n, n2, n3);
    }

    public void b(int n, int n2, int n3, int n4) {
        this.o = true;
        this.e.a(n, n2, n3, n4);
    }

    public int a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        return enumSkyBlock == EnumSkyBlock.SKY ? this.f.a(n, n2, n3) : (enumSkyBlock == EnumSkyBlock.BLOCK ? this.g.a(n, n2, n3) : 0);
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        this.o = true;
        if (enumSkyBlock == EnumSkyBlock.SKY) {
            this.f.a(n, n2, n3, n4);
        } else {
            if (enumSkyBlock != EnumSkyBlock.BLOCK) {
                return;
            }
            this.g.a(n, n2, n3, n4);
        }
    }

    public int c(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.f.a(n, n2, n3);
        if (n6 > 0) {
            a = true;
        }
        if ((n5 = this.g.a(n, n2, n3)) > (n6 -= n4)) {
            n6 = n5;
        }
        return n6;
    }

    public void a(Entity entity) {
        int n;
        this.q = true;
        int n2 = MathHelper.floor(entity.locX / 16.0);
        int n3 = MathHelper.floor(entity.locZ / 16.0);
        if (n2 != this.x || n3 != this.z) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((n = MathHelper.floor(entity.locY / 16.0)) < 0) {
            n = 0;
        }
        if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        entity.bG = true;
        entity.bH = this.x;
        entity.bI = n;
        entity.bJ = this.z;
        this.entitySlices[n].add(entity);
    }

    public void b(Entity entity) {
        this.a(entity, entity.bI);
    }

    public void a(Entity entity, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        this.entitySlices[n].remove(entity);
    }

    public boolean c(int n, int n2, int n3) {
        return n2 >= (this.heightMap[n3 << 4 | n] & 0xFF);
    }

    public TileEntity d(int n, int n2, int n3) {
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        TileEntity tileEntity = (TileEntity)this.tileEntities.get(chunkPosition);
        if (tileEntity == null) {
            int n4 = this.getTypeId(n, n2, n3);
            if (!Block.isTileEntity[n4]) {
                return null;
            }
            BlockContainer blockContainer = (BlockContainer)Block.byId[n4];
            blockContainer.e(this.world, this.x * 16 + n, n2, this.z * 16 + n3);
            tileEntity = (TileEntity)this.tileEntities.get(chunkPosition);
        }
        if (tileEntity != null && tileEntity.g()) {
            this.tileEntities.remove(chunkPosition);
            return null;
        }
        return tileEntity;
    }

    public void a(TileEntity tileEntity) {
        int n = tileEntity.x - this.x * 16;
        int n2 = tileEntity.y;
        int n3 = tileEntity.z - this.z * 16;
        this.a(n, n2, n3, tileEntity);
        if (this.c) {
            this.world.c.add(tileEntity);
        }
    }

    public void a(int n, int n2, int n3, TileEntity tileEntity) {
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        tileEntity.world = this.world;
        tileEntity.x = this.x * 16 + n;
        tileEntity.y = n2;
        tileEntity.z = this.z * 16 + n3;
        if (this.getTypeId(n, n2, n3) != 0 && Block.byId[this.getTypeId(n, n2, n3)] instanceof BlockContainer) {
            tileEntity.j();
            this.tileEntities.put(chunkPosition, tileEntity);
        } else {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
        }
    }

    public void e(int n, int n2, int n3) {
        TileEntity tileEntity;
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        if (this.c && (tileEntity = (TileEntity)this.tileEntities.remove(chunkPosition)) != null) {
            tileEntity.h();
        }
    }

    public void addEntities() {
        this.c = true;
        this.world.a(this.tileEntities.values());
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.world.a(this.entitySlices[i]);
        }
    }

    public void removeEntities() {
        this.c = false;
        for (TileEntity tileEntity : this.tileEntities.values()) {
            tileEntity.h();
        }
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.world.b(this.entitySlices[i]);
        }
    }

    public void f() {
        this.o = true;
    }

    public void a(Entity entity, AxisAlignedBB axisAlignedBB, List list) {
        int n = MathHelper.floor((axisAlignedBB.b - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.entitySlices.length) {
            n2 = this.entitySlices.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.entitySlices[i];
            for (int j = 0; j < list2.size(); ++j) {
                Entity entity2 = (Entity)list2.get(j);
                if (entity2 == entity || !entity2.boundingBox.a(axisAlignedBB)) continue;
                list.add(entity2);
            }
        }
    }

    public void a(Class clazz, AxisAlignedBB axisAlignedBB, List list) {
        int n = MathHelper.floor((axisAlignedBB.b - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.entitySlices.length) {
            n2 = this.entitySlices.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.entitySlices[i];
            for (int j = 0; j < list2.size(); ++j) {
                Entity entity = (Entity)list2.get(j);
                if (!clazz.isAssignableFrom(entity.getClass()) || !entity.boundingBox.a(axisAlignedBB)) continue;
                list.add(entity);
            }
        }
    }

    public boolean a(boolean bl) {
        if (this.p) {
            return false;
        }
        if (bl ? this.q && this.world.getTime() != this.r : this.q && this.world.getTime() >= this.r + 600L) {
            return true;
        }
        return this.o;
    }

    public int getData(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n4 - n;
        int n13 = n5 - n2;
        int n14 = n6 - n3;
        if (n12 * n13 * n14 == this.b.length) {
            System.arraycopy(this.b, 0, byArray, n7, this.b.length);
            System.arraycopy(this.e.a, 0, byArray, n7 += this.b.length, this.e.a.length);
            System.arraycopy(this.g.a, 0, byArray, n7 += this.e.a.length, this.g.a.length);
            System.arraycopy(this.f.a, 0, byArray, n7 += this.g.a.length, this.f.a.length);
            return n7 += this.f.a.length;
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = n11 << 11 | n10 << 7 | n2;
                n8 = n5 - n2;
                System.arraycopy(this.b, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.e.a, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.g.a, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        for (n11 = n; n11 < n4; ++n11) {
            for (n10 = n3; n10 < n6; ++n10) {
                n9 = (n11 << 11 | n10 << 7 | n2) >> 1;
                n8 = (n5 - n2) / 2;
                System.arraycopy(this.f.a, n9, byArray, n7, n8);
                n7 += n8;
            }
        }
        return n7;
    }

    public Random a(long l) {
        return new Random(this.world.getSeed() + (long)(this.x * this.x * 4987142) + (long)(this.x * 5947611) + (long)(this.z * this.z) * 4392871L + (long)(this.z * 389711) ^ l);
    }

    public boolean isEmpty() {
        return false;
    }

    public void h() {
        BlockRegister.a(this.b);
    }
}

