/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.EmptyChunk;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.WorldServer;

public class ChunkProviderServer
implements IChunkProvider {
    private Set unloadQueue = new HashSet();
    private Chunk emptyChunk;
    private IChunkProvider chunkProvider;
    private IChunkLoader e;
    public boolean forceChunkLoad = false;
    private Map chunks = new HashMap();
    private List chunkList = new ArrayList();
    private WorldServer world;

    public ChunkProviderServer(WorldServer worldServer, IChunkLoader iChunkLoader, IChunkProvider iChunkProvider) {
        this.emptyChunk = new EmptyChunk(worldServer, new byte[32768], 0, 0);
        this.world = worldServer;
        this.e = iChunkLoader;
        this.chunkProvider = iChunkProvider;
    }

    @Override
    public boolean isChunkLoaded(int n, int n2) {
        return this.chunks.containsKey(ChunkCoordIntPair.a(n, n2));
    }

    public void queueUnload(int n, int n2) {
        ChunkCoordinates chunkCoordinates = this.world.getSpawn();
        int n3 = n * 16 + 8 - chunkCoordinates.x;
        int n4 = n2 * 16 + 8 - chunkCoordinates.z;
        int n5 = 128;
        if (n3 < -n5 || n3 > n5 || n4 < -n5 || n4 > n5) {
            this.unloadQueue.add(ChunkCoordIntPair.a(n, n2));
        }
    }

    @Override
    public Chunk getChunkAt(int n, int n2) {
        int n3 = ChunkCoordIntPair.a(n, n2);
        this.unloadQueue.remove(n3);
        Chunk chunk = (Chunk)this.chunks.get(n3);
        if (chunk == null) {
            chunk = this.loadChunk(n, n2);
            if (chunk == null) {
                chunk = this.chunkProvider == null ? this.emptyChunk : this.chunkProvider.getOrCreateChunk(n, n2);
            }
            this.chunks.put(n3, chunk);
            this.chunkList.add(chunk);
            if (chunk != null) {
                chunk.loadNOP();
                chunk.addEntities();
            }
            if (!chunk.done && this.isChunkLoaded(n + 1, n2 + 1) && this.isChunkLoaded(n, n2 + 1) && this.isChunkLoaded(n + 1, n2)) {
                this.getChunkAt(this, n, n2);
            }
            if (this.isChunkLoaded(n - 1, n2) && !this.getOrCreateChunk((int)(n - 1), (int)n2).done && this.isChunkLoaded(n - 1, n2 + 1) && this.isChunkLoaded(n, n2 + 1) && this.isChunkLoaded(n - 1, n2)) {
                this.getChunkAt(this, n - 1, n2);
            }
            if (this.isChunkLoaded(n, n2 - 1) && !this.getOrCreateChunk((int)n, (int)(n2 - 1)).done && this.isChunkLoaded(n + 1, n2 - 1) && this.isChunkLoaded(n, n2 - 1) && this.isChunkLoaded(n + 1, n2)) {
                this.getChunkAt(this, n, n2 - 1);
            }
            if (this.isChunkLoaded(n - 1, n2 - 1) && !this.getOrCreateChunk((int)(n - 1), (int)(n2 - 1)).done && this.isChunkLoaded(n - 1, n2 - 1) && this.isChunkLoaded(n, n2 - 1) && this.isChunkLoaded(n - 1, n2)) {
                this.getChunkAt(this, n - 1, n2 - 1);
            }
        }
        return chunk;
    }

    @Override
    public Chunk getOrCreateChunk(int n, int n2) {
        Chunk chunk = (Chunk)this.chunks.get(ChunkCoordIntPair.a(n, n2));
        return chunk == null ? (!this.world.isLoading && !this.forceChunkLoad ? this.emptyChunk : this.getChunkAt(n, n2)) : chunk;
    }

    private Chunk loadChunk(int n, int n2) {
        if (this.e == null) {
            return null;
        }
        try {
            Chunk chunk = this.e.a(this.world, n, n2);
            if (chunk != null) {
                chunk.r = this.world.getTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void saveChunkNOP(Chunk chunk) {
        if (this.e != null) {
            try {
                this.e.b(this.world, chunk);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.e != null) {
            try {
                chunk.r = this.world.getTime();
                this.e.a(this.world, chunk);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void getChunkAt(IChunkProvider iChunkProvider, int n, int n2) {
        Chunk chunk = this.getOrCreateChunk(n, n2);
        if (!chunk.done) {
            chunk.done = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.getChunkAt(iChunkProvider, n, n2);
                chunk.f();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean bl, IProgressUpdate iProgressUpdate) {
        int n = 0;
        for (int i = 0; i < this.chunkList.size(); ++i) {
            Chunk chunk = (Chunk)this.chunkList.get(i);
            if (bl && !chunk.p) {
                this.saveChunkNOP(chunk);
            }
            if (!chunk.a(bl)) continue;
            this.saveChunk(chunk);
            chunk.o = false;
            if (++n != 24 || bl) continue;
            return false;
        }
        if (bl) {
            if (this.e == null) {
                return true;
            }
            this.e.b();
        }
        return true;
    }

    @Override
    public boolean unloadChunks() {
        if (!this.world.canSave) {
            for (int i = 0; i < 100; ++i) {
                if (this.unloadQueue.isEmpty()) continue;
                Integer n = (Integer)this.unloadQueue.iterator().next();
                Chunk chunk = (Chunk)this.chunks.get(n);
                chunk.removeEntities();
                this.saveChunk(chunk);
                this.saveChunkNOP(chunk);
                this.unloadQueue.remove(n);
                this.chunks.remove(n);
                this.chunkList.remove(chunk);
            }
            if (this.e != null) {
                this.e.a();
            }
        }
        return this.chunkProvider.unloadChunks();
    }

    @Override
    public boolean canSave() {
        return !this.world.canSave;
    }
}

