/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class Entity {
    private static int entityCount = 0;
    public int id = entityCount++;
    public double aH = 1.0;
    public boolean aI = false;
    public Entity passenger;
    public Entity vehicle;
    public World world;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double locX;
    public double locY;
    public double locZ;
    public double motX;
    public double motY;
    public double motZ;
    public float yaw;
    public float pitch;
    public float lastYaw;
    public float lastPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean positionChanged;
    public boolean bc;
    public boolean bd = false;
    public boolean velocityChanged = false;
    public boolean bf;
    public boolean bg = true;
    public boolean dead = false;
    public float height = 0.0f;
    public float length = 0.6f;
    public float width = 1.8f;
    public float bl = 0.0f;
    public float bm = 0.0f;
    protected float fallDistance = 0.0f;
    private int b = 1;
    public double bo;
    public double bp;
    public double bq;
    public float br = 0.0f;
    public float bs = 0.0f;
    public boolean bt = false;
    public float bu = 0.0f;
    protected Random random = new Random();
    public int ticksLived = 0;
    public int maxFireTicks = 1;
    public int fireTicks = 0;
    protected int maxAirTicks = 300;
    protected boolean bA = false;
    public int noDamageTicks = 0;
    public int airTicks = 300;
    private boolean justCreated = true;
    protected boolean fireProof = false;
    protected DataWatcher datawatcher = new DataWatcher();
    public float bF = 0.0f;
    private double d;
    private double e;
    public boolean bG = false;
    public int bH;
    public int bI;
    public int bJ;
    public boolean bK;

    public Entity(World world) {
        this.world = world;
        this.setPosition(0.0, 0.0, 0.0);
        this.datawatcher.a(0, (byte)0);
        this.b();
    }

    protected abstract void b();

    public DataWatcher aa() {
        return this.datawatcher;
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).id == this.id : false;
    }

    public int hashCode() {
        return this.id;
    }

    public void die() {
        this.dead = true;
    }

    protected void b(float f, float f2) {
        this.length = f;
        this.width = f2;
    }

    protected void c(float f, float f2) {
        this.yaw = f % 360.0f;
        this.pitch = f2 % 360.0f;
    }

    public void setPosition(double d, double d2, double d3) {
        this.locX = d;
        this.locY = d2;
        this.locZ = d3;
        float f = this.length / 2.0f;
        float f2 = this.width;
        this.boundingBox.c(d - (double)f, d2 - (double)this.height + (double)this.br, d3 - (double)f, d + (double)f, d2 - (double)this.height + (double)this.br + (double)f2, d3 + (double)f);
    }

    public void m_() {
        this.R();
    }

    public void R() {
        if (this.vehicle != null && this.vehicle.dead) {
            this.vehicle = null;
        }
        ++this.ticksLived;
        this.bl = this.bm;
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.lastPitch = this.pitch;
        this.lastYaw = this.yaw;
        if (this.f_()) {
            if (!this.bA && !this.justCreated) {
                float f;
                float f2;
                float f3 = MathHelper.a(this.motX * this.motX * (double)0.2f + this.motY * this.motY + this.motZ * this.motZ * (double)0.2f) * 0.2f;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                this.world.makeSound(this, "random.splash", f3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                float f4 = MathHelper.floor(this.boundingBox.b);
                int n = 0;
                while ((float)n < 1.0f + this.length * 20.0f) {
                    f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    this.world.a("bubble", this.locX + (double)f2, f4 + 1.0f, this.locZ + (double)f, this.motX, this.motY - (double)(this.random.nextFloat() * 0.2f), this.motZ);
                    ++n;
                }
                n = 0;
                while ((float)n < 1.0f + this.length * 20.0f) {
                    f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.length;
                    this.world.a("splash", this.locX + (double)f2, f4 + 1.0f, this.locZ + (double)f, this.motX, this.motY, this.motZ);
                    ++n;
                }
            }
            this.fallDistance = 0.0f;
            this.bA = true;
            this.fireTicks = 0;
        } else {
            this.bA = false;
        }
        if (this.world.isStatic) {
            this.fireTicks = 0;
        } else if (this.fireTicks > 0) {
            if (this.fireProof) {
                this.fireTicks -= 4;
                if (this.fireTicks < 0) {
                    this.fireTicks = 0;
                }
            } else {
                if (this.fireTicks % 20 == 0) {
                    this.damageEntity(null, 1);
                }
                --this.fireTicks;
            }
        }
        if (this.ae()) {
            this.ab();
        }
        if (this.locY < -64.0) {
            this.Y();
        }
        if (!this.world.isStatic) {
            this.a(0, this.fireTicks > 0);
            this.a(2, this.vehicle != null);
        }
        this.justCreated = false;
    }

    protected void ab() {
        if (!this.fireProof) {
            this.damageEntity(null, 4);
            this.fireTicks = 600;
        }
    }

    protected void Y() {
        this.die();
    }

    public boolean b(double d, double d2, double d3) {
        AxisAlignedBB axisAlignedBB = this.boundingBox.c(d, d2, d3);
        List list = this.world.getEntities(this, axisAlignedBB);
        return list.size() > 0 ? false : !this.world.c(axisAlignedBB);
    }

    public void move(double d, double d2, double d3) {
        if (this.bt) {
            this.boundingBox.d(d, d2, d3);
            this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
            this.locY = this.boundingBox.b + (double)this.height - (double)this.br;
            this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            double d4;
            double d5;
            int n8;
            int n9;
            boolean bl;
            this.br *= 0.4f;
            double d6 = this.locX;
            double d7 = this.locZ;
            if (this.bf) {
                this.bf = false;
                d *= 0.25;
                d2 *= (double)0.05f;
                d3 *= 0.25;
                this.motX = 0.0;
                this.motY = 0.0;
                this.motZ = 0.0;
            }
            double d8 = d;
            double d9 = d2;
            double d10 = d3;
            AxisAlignedBB axisAlignedBB = this.boundingBox.clone();
            boolean bl2 = bl = this.onGround && this.isSneaking();
            if (bl) {
                double d11 = 0.05;
                while (d != 0.0 && this.world.getEntities(this, this.boundingBox.c(d, -1.0, 0.0)).size() == 0) {
                    d = d < d11 && d >= -d11 ? 0.0 : (d > 0.0 ? (d -= d11) : (d += d11));
                    d8 = d;
                }
                while (d3 != 0.0 && this.world.getEntities(this, this.boundingBox.c(0.0, -1.0, d3)).size() == 0) {
                    d3 = d3 < d11 && d3 >= -d11 ? 0.0 : (d3 > 0.0 ? (d3 -= d11) : (d3 += d11));
                    d10 = d3;
                }
            }
            List list = this.world.getEntities(this, this.boundingBox.a(d, d2, d3));
            for (n9 = 0; n9 < list.size(); ++n9) {
                d2 = ((AxisAlignedBB)list.get(n9)).b(this.boundingBox, d2);
            }
            this.boundingBox.d(0.0, d2, 0.0);
            if (!this.bg && d9 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            n9 = this.onGround || d9 != d2 && d9 < 0.0 ? 1 : 0;
            for (n8 = 0; n8 < list.size(); ++n8) {
                d = ((AxisAlignedBB)list.get(n8)).a(this.boundingBox, d);
            }
            this.boundingBox.d(d, 0.0, 0.0);
            if (!this.bg && d8 != d) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n8 = 0; n8 < list.size(); ++n8) {
                d3 = ((AxisAlignedBB)list.get(n8)).c(this.boundingBox, d3);
            }
            this.boundingBox.d(0.0, 0.0, d3);
            if (!this.bg && d10 != d3) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            if (this.bs > 0.0f && n9 != 0 && (bl || this.br < 0.05f) && (d8 != d || d10 != d3)) {
                d5 = d;
                d4 = d2;
                double d12 = d3;
                d = d8;
                d2 = this.bs;
                d3 = d10;
                AxisAlignedBB axisAlignedBB2 = this.boundingBox.clone();
                this.boundingBox.b(axisAlignedBB);
                list = this.world.getEntities(this, this.boundingBox.a(d8, d2, d10));
                for (n7 = 0; n7 < list.size(); ++n7) {
                    d2 = ((AxisAlignedBB)list.get(n7)).b(this.boundingBox, d2);
                }
                this.boundingBox.d(0.0, d2, 0.0);
                if (!this.bg && d9 != d2) {
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                }
                for (n7 = 0; n7 < list.size(); ++n7) {
                    d = ((AxisAlignedBB)list.get(n7)).a(this.boundingBox, d);
                }
                this.boundingBox.d(d, 0.0, 0.0);
                if (!this.bg && d8 != d) {
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                }
                for (n7 = 0; n7 < list.size(); ++n7) {
                    d3 = ((AxisAlignedBB)list.get(n7)).c(this.boundingBox, d3);
                }
                this.boundingBox.d(0.0, 0.0, d3);
                if (!this.bg && d10 != d3) {
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                }
                if (!this.bg && d9 != d2) {
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                } else {
                    d2 = -this.bs;
                    for (n7 = 0; n7 < list.size(); ++n7) {
                        d2 = ((AxisAlignedBB)list.get(n7)).b(this.boundingBox, d2);
                    }
                    this.boundingBox.d(0.0, d2, 0.0);
                }
                if (d5 * d5 + d12 * d12 >= d * d + d3 * d3) {
                    d = d5;
                    d2 = d4;
                    d3 = d12;
                    this.boundingBox.b(axisAlignedBB2);
                } else {
                    double d13 = this.boundingBox.b - (double)((int)this.boundingBox.b);
                    if (d13 > 0.0) {
                        this.br = (float)((double)this.br + d13 + 0.01);
                    }
                }
            }
            this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
            this.locY = this.boundingBox.b + (double)this.height - (double)this.br;
            this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
            this.positionChanged = d8 != d || d10 != d3;
            this.bc = d9 != d2;
            this.onGround = d9 != d2 && d9 < 0.0;
            this.bd = this.positionChanged || this.bc;
            this.a(d2, this.onGround);
            if (d8 != d) {
                this.motX = 0.0;
            }
            if (d9 != d2) {
                this.motY = 0.0;
            }
            if (d10 != d3) {
                this.motZ = 0.0;
            }
            d5 = this.locX - d6;
            d4 = this.locZ - d7;
            if (this.n() && !bl && this.vehicle == null) {
                this.bm = (float)((double)this.bm + (double)MathHelper.a(d5 * d5 + d4 * d4) * 0.6);
                int n10 = MathHelper.floor(this.locX);
                n6 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height);
                int n11 = MathHelper.floor(this.locZ);
                n7 = this.world.getTypeId(n10, n6, n11);
                if (this.world.getTypeId(n10, n6 - 1, n11) == Block.FENCE.id) {
                    n7 = this.world.getTypeId(n10, n6 - 1, n11);
                }
                if (this.bm > (float)this.b && n7 > 0) {
                    ++this.b;
                    StepSound stepSound = Block.byId[n7].stepSound;
                    if (this.world.getTypeId(n10, n6 + 1, n11) == Block.SNOW.id) {
                        stepSound = Block.SNOW.stepSound;
                        this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
                    } else if (!Block.byId[n7].material.isLiquid()) {
                        this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
                    }
                    Block.byId[n7].b(this.world, n10, n6, n11, this);
                }
            }
            if (this.world.a(n5 = MathHelper.floor(this.boundingBox.a + 0.001), n6 = MathHelper.floor(this.boundingBox.b + 0.001), n4 = MathHelper.floor(this.boundingBox.c + 0.001), n7 = MathHelper.floor(this.boundingBox.d - 0.001), n3 = MathHelper.floor(this.boundingBox.e - 0.001), n2 = MathHelper.floor(this.boundingBox.f - 0.001))) {
                for (n = n5; n <= n7; ++n) {
                    for (int i = n6; i <= n3; ++i) {
                        for (int j = n4; j <= n2; ++j) {
                            int n12 = this.world.getTypeId(n, i, j);
                            if (n12 <= 0) continue;
                            Block.byId[n12].a(this.world, n, i, j, this);
                        }
                    }
                }
            }
            n = this.ac() ? 1 : 0;
            if (this.world.d(this.boundingBox.shrink(0.001, 0.001, 0.001))) {
                this.burn(1);
                if (n == 0) {
                    ++this.fireTicks;
                    if (this.fireTicks == 0) {
                        this.fireTicks = 300;
                    }
                }
            } else if (this.fireTicks <= 0) {
                this.fireTicks = -this.maxFireTicks;
            }
            if (n != 0 && this.fireTicks > 0) {
                this.world.makeSound(this, "random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                this.fireTicks = -this.maxFireTicks;
            }
        }
    }

    protected boolean n() {
        return true;
    }

    protected void a(double d, boolean bl) {
        if (bl) {
            if (this.fallDistance > 0.0f) {
                this.a(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AxisAlignedBB e_() {
        return null;
    }

    protected void burn(int n) {
        if (!this.fireProof) {
            this.damageEntity(null, n);
        }
    }

    protected void a(float f) {
        if (this.passenger != null) {
            this.passenger.a(f);
        }
    }

    public boolean ac() {
        return this.bA || this.world.s(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
    }

    public boolean ad() {
        return this.bA;
    }

    public boolean f_() {
        return this.world.a(this.boundingBox.b(0.0, -0.4f, 0.0).shrink(0.001, 0.001, 0.001), Material.WATER, this);
    }

    public boolean a(Material material) {
        int n;
        int n2;
        double d = this.locY + (double)this.t();
        int n3 = MathHelper.floor(this.locX);
        int n4 = this.world.getTypeId(n3, n2 = MathHelper.d(MathHelper.floor(d)), n = MathHelper.floor(this.locZ));
        if (n4 != 0 && Block.byId[n4].material == material) {
            float f = BlockFluids.c(this.world.getData(n3, n2, n)) - 0.11111111f;
            float f2 = (float)(n2 + 1) - f;
            return d < (double)f2;
        }
        return false;
    }

    public float t() {
        return 0.0f;
    }

    public boolean ae() {
        return this.world.a(this.boundingBox.b(-0.1f, -0.4f, -0.1f), Material.LAVA);
    }

    public void a(float f, float f2, float f3) {
        float f4 = MathHelper.c(f * f + f2 * f2);
        if (f4 >= 0.01f) {
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f3 / f4;
            float f5 = MathHelper.sin(this.yaw * (float)Math.PI / 180.0f);
            float f6 = MathHelper.cos(this.yaw * (float)Math.PI / 180.0f);
            this.motX += (double)((f *= f4) * f6 - (f2 *= f4) * f5);
            this.motZ += (double)(f2 * f6 + f * f5);
        }
    }

    public float c(float f) {
        int n = MathHelper.floor(this.locX);
        double d = (this.boundingBox.e - this.boundingBox.b) * 0.66;
        int n2 = MathHelper.floor(this.locY - (double)this.height + d);
        int n3 = MathHelper.floor(this.locZ);
        if (this.world.a(MathHelper.floor(this.boundingBox.a), MathHelper.floor(this.boundingBox.b), MathHelper.floor(this.boundingBox.c), MathHelper.floor(this.boundingBox.d), MathHelper.floor(this.boundingBox.e), MathHelper.floor(this.boundingBox.f))) {
            float f2 = this.world.n(n, n2, n3);
            if (f2 < this.bF) {
                f2 = this.bF;
            }
            return f2;
        }
        return this.bF;
    }

    public void spawnIn(World world) {
        this.world = world;
    }

    public void setLocation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.lastY = this.locY = d2;
        this.lastZ = this.locZ = d3;
        this.lastYaw = this.yaw = f;
        this.lastPitch = this.pitch = f2;
        this.br = 0.0f;
        double d4 = this.lastYaw - f;
        if (d4 < -180.0) {
            this.lastYaw += 360.0f;
        }
        if (d4 >= 180.0) {
            this.lastYaw -= 360.0f;
        }
        this.setPosition(this.locX, this.locY, this.locZ);
        this.c(f, f2);
    }

    public void setPositionRotation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.bo = this.locX;
        this.lastY = this.locY = d2 + (double)this.height;
        this.bp = this.locY;
        this.lastZ = this.locZ = d3;
        this.bq = this.locZ;
        this.yaw = f;
        this.pitch = f2;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public float f(Entity entity) {
        float f = (float)(this.locX - entity.locX);
        float f2 = (float)(this.locY - entity.locY);
        float f3 = (float)(this.locZ - entity.locZ);
        return MathHelper.c(f * f + f2 * f2 + f3 * f3);
    }

    public double d(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public double e(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return MathHelper.a(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double g(Entity entity) {
        double d = this.locX - entity.locX;
        double d2 = this.locY - entity.locY;
        double d3 = this.locZ - entity.locZ;
        return d * d + d2 * d2 + d3 * d3;
    }

    public void b(EntityHuman entityHuman) {
    }

    public void collide(Entity entity) {
        double d;
        double d2;
        double d3;
        if (entity.passenger != this && entity.vehicle != this && (d3 = MathHelper.a(d2 = entity.locX - this.locX, d = entity.locZ - this.locZ)) >= (double)0.01f) {
            d3 = MathHelper.a(d3);
            d2 /= d3;
            d /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d2 *= d4;
            d *= d4;
            d2 *= (double)0.05f;
            d *= (double)0.05f;
            this.f(-(d2 *= (double)(1.0f - this.bu)), 0.0, -(d *= (double)(1.0f - this.bu)));
            entity.f(d2, 0.0, d);
        }
    }

    public void f(double d, double d2, double d3) {
        this.motX += d;
        this.motY += d2;
        this.motZ += d3;
    }

    protected void af() {
        this.velocityChanged = true;
    }

    public boolean damageEntity(Entity entity, int n) {
        this.af();
        return false;
    }

    public boolean l_() {
        return false;
    }

    public boolean d_() {
        return false;
    }

    public void c(Entity entity, int n) {
    }

    public boolean c(NBTTagCompound nBTTagCompound) {
        String string = this.ag();
        if (!this.dead && string != null) {
            nBTTagCompound.setString("id", string);
            this.d(nBTTagCompound);
            return true;
        }
        return false;
    }

    public void d(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Pos", this.a(this.locX, this.locY + (double)this.br, this.locZ));
        nBTTagCompound.a("Motion", this.a(this.motX, this.motY, this.motZ));
        nBTTagCompound.a("Rotation", this.a(this.yaw, this.pitch));
        nBTTagCompound.a("FallDistance", this.fallDistance);
        nBTTagCompound.a("Fire", (short)this.fireTicks);
        nBTTagCompound.a("Air", (short)this.airTicks);
        nBTTagCompound.a("OnGround", this.onGround);
        this.b(nBTTagCompound);
    }

    public void e(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.l("Pos");
        NBTTagList nBTTagList2 = nBTTagCompound.l("Motion");
        NBTTagList nBTTagList3 = nBTTagCompound.l("Rotation");
        this.motX = ((NBTTagDouble)nBTTagList2.a((int)0)).a;
        this.motY = ((NBTTagDouble)nBTTagList2.a((int)1)).a;
        this.motZ = ((NBTTagDouble)nBTTagList2.a((int)2)).a;
        if (Math.abs(this.motX) > 10.0) {
            this.motX = 0.0;
        }
        if (Math.abs(this.motY) > 10.0) {
            this.motY = 0.0;
        }
        if (Math.abs(this.motZ) > 10.0) {
            this.motZ = 0.0;
        }
        this.bo = this.locX = ((NBTTagDouble)nBTTagList.a((int)0)).a;
        this.lastX = this.locX;
        this.bp = this.locY = ((NBTTagDouble)nBTTagList.a((int)1)).a;
        this.lastY = this.locY;
        this.bq = this.locZ = ((NBTTagDouble)nBTTagList.a((int)2)).a;
        this.lastZ = this.locZ;
        this.lastYaw = this.yaw = ((NBTTagFloat)nBTTagList3.a((int)0)).a;
        this.lastPitch = this.pitch = ((NBTTagFloat)nBTTagList3.a((int)1)).a;
        this.fallDistance = nBTTagCompound.g("FallDistance");
        this.fireTicks = nBTTagCompound.d("Fire");
        this.airTicks = nBTTagCompound.d("Air");
        this.onGround = nBTTagCompound.m("OnGround");
        this.setPosition(this.locX, this.locY, this.locZ);
        this.c(this.yaw, this.pitch);
        this.a(nBTTagCompound);
    }

    protected final String ag() {
        return EntityTypes.b(this);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... dArray) {
        NBTTagList nBTTagList = new NBTTagList();
        double[] dArray2 = dArray;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray2[i];
            nBTTagList.a(new NBTTagDouble(d));
        }
        return nBTTagList;
    }

    protected NBTTagList a(float ... fArray) {
        NBTTagList nBTTagList = new NBTTagList();
        float[] fArray2 = fArray;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f = fArray2[i];
            nBTTagList.a(new NBTTagFloat(f));
        }
        return nBTTagList;
    }

    public EntityItem b(int n, int n2) {
        return this.a(n, n2, 0.0f);
    }

    public EntityItem a(int n, int n2, float f) {
        return this.a(new ItemStack(n, n2, 0), f);
    }

    public EntityItem a(ItemStack itemStack, float f) {
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY + (double)f, this.locZ, itemStack);
        entityItem.pickupDelay = 10;
        this.world.addEntity(entityItem);
        return entityItem;
    }

    public boolean T() {
        return !this.dead;
    }

    public boolean K() {
        for (int i = 0; i < 8; ++i) {
            int n;
            int n2;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.length * 0.9f;
            float f2 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f3 = ((float)((i >> 2) % 2) - 0.5f) * this.length * 0.9f;
            int n3 = MathHelper.floor(this.locX + (double)f);
            if (!this.world.e(n3, n2 = MathHelper.floor(this.locY + (double)this.t() + (double)f2), n = MathHelper.floor(this.locZ + (double)f3))) continue;
            return true;
        }
        return false;
    }

    public boolean a(EntityHuman entityHuman) {
        return false;
    }

    public AxisAlignedBB a_(Entity entity) {
        return null;
    }

    public void E() {
        if (this.vehicle.dead) {
            this.vehicle = null;
        } else {
            this.motX = 0.0;
            this.motY = 0.0;
            this.motZ = 0.0;
            this.m_();
            if (this.vehicle != null) {
                this.vehicle.f();
                this.e += (double)(this.vehicle.yaw - this.vehicle.lastYaw);
                this.d += (double)(this.vehicle.pitch - this.vehicle.lastPitch);
                while (this.e >= 180.0) {
                    this.e -= 360.0;
                }
                while (this.e < -180.0) {
                    this.e += 360.0;
                }
                while (this.d >= 180.0) {
                    this.d -= 360.0;
                }
                while (this.d < -180.0) {
                    this.d += 360.0;
                }
                double d = this.e * 0.5;
                double d2 = this.d * 0.5;
                float f = 10.0f;
                if (d > (double)f) {
                    d = f;
                }
                if (d < (double)(-f)) {
                    d = -f;
                }
                if (d2 > (double)f) {
                    d2 = f;
                }
                if (d2 < (double)(-f)) {
                    d2 = -f;
                }
                this.e -= d;
                this.d -= d2;
                this.yaw = (float)((double)this.yaw + d);
                this.pitch = (float)((double)this.pitch + d2);
            }
        }
    }

    public void f() {
        this.passenger.setPosition(this.locX, this.locY + this.m() + this.passenger.I(), this.locZ);
    }

    public double I() {
        return this.height;
    }

    public double m() {
        return (double)this.width * 0.75;
    }

    public void mount(Entity entity) {
        this.d = 0.0;
        this.e = 0.0;
        if (entity == null) {
            if (this.vehicle != null) {
                this.setPositionRotation(this.vehicle.locX, this.vehicle.boundingBox.b + (double)this.vehicle.width, this.vehicle.locZ, this.yaw, this.pitch);
                this.vehicle.passenger = null;
            }
            this.vehicle = null;
        } else if (this.vehicle == entity) {
            this.vehicle.passenger = null;
            this.vehicle = null;
            this.setPositionRotation(entity.locX, entity.boundingBox.b + (double)entity.width, entity.locZ, this.yaw, this.pitch);
        } else {
            if (this.vehicle != null) {
                this.vehicle.passenger = null;
            }
            if (entity.passenger != null) {
                entity.passenger.vehicle = null;
            }
            this.vehicle = entity;
            entity.passenger = this;
        }
    }

    public Vec3D Z() {
        return null;
    }

    public void P() {
    }

    public ItemStack[] getEquipment() {
        return null;
    }

    public boolean isSneaking() {
        return this.d(1);
    }

    public void setSneak(boolean bl) {
        this.a(1, bl);
    }

    protected boolean d(int n) {
        return (this.datawatcher.a(0) & 1 << n) != 0;
    }

    protected void a(int n, boolean bl) {
        byte by = this.datawatcher.a(0);
        if (bl) {
            this.datawatcher.watch(0, (byte)(by | 1 << n));
        } else {
            this.datawatcher.watch(0, (byte)(by & ~(1 << n)));
        }
    }

    public void a(EntityWeatherStorm entityWeatherStorm) {
        this.burn(5);
        ++this.fireTicks;
        if (this.fireTicks == 0) {
            this.fireTicks = 300;
        }
    }

    public void a(EntityLiving entityLiving) {
    }

    protected boolean g(double d, double d2, double d3) {
        int n = MathHelper.floor(d);
        int n2 = MathHelper.floor(d2);
        int n3 = MathHelper.floor(d3);
        double d4 = d - (double)n;
        double d5 = d2 - (double)n2;
        double d6 = d3 - (double)n3;
        if (this.world.e(n, n2, n3)) {
            boolean bl = !this.world.e(n - 1, n2, n3);
            boolean bl2 = !this.world.e(n + 1, n2, n3);
            boolean bl3 = !this.world.e(n, n2 - 1, n3);
            boolean bl4 = !this.world.e(n, n2 + 1, n3);
            boolean bl5 = !this.world.e(n, n2, n3 - 1);
            boolean bl6 = !this.world.e(n, n2, n3 + 1);
            int n4 = -1;
            double d7 = 9999.0;
            if (bl && d4 < d7) {
                d7 = d4;
                n4 = 0;
            }
            if (bl2 && 1.0 - d4 < d7) {
                d7 = 1.0 - d4;
                n4 = 1;
            }
            if (bl3 && d5 < d7) {
                d7 = d5;
                n4 = 2;
            }
            if (bl4 && 1.0 - d5 < d7) {
                d7 = 1.0 - d5;
                n4 = 3;
            }
            if (bl5 && d6 < d7) {
                d7 = d6;
                n4 = 4;
            }
            if (bl6 && 1.0 - d6 < d7) {
                d7 = 1.0 - d6;
                n4 = 5;
            }
            float f = this.random.nextFloat() * 0.2f + 0.1f;
            if (n4 == 0) {
                this.motX = -f;
            }
            if (n4 == 1) {
                this.motX = f;
            }
            if (n4 == 2) {
                this.motY = -f;
            }
            if (n4 == 3) {
                this.motY = f;
            }
            if (n4 == 4) {
                this.motZ = -f;
            }
            if (n4 == 5) {
                this.motZ = f;
            }
        }
        return false;
    }
}

