/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityBoat
extends Entity {
    public int damage = 0;
    public int b = 0;
    public int c = 1;
    private int d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i;

    public EntityBoat(World world) {
        super(world);
        this.aI = true;
        this.b(1.5f, 0.6f);
        this.height = this.width / 2.0f;
    }

    @Override
    protected boolean n() {
        return false;
    }

    @Override
    protected void b() {
    }

    @Override
    public AxisAlignedBB a_(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public AxisAlignedBB e_() {
        return this.boundingBox;
    }

    @Override
    public boolean d_() {
        return true;
    }

    public EntityBoat(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    @Override
    public double m() {
        return (double)this.width * 0.0 - (double)0.3f;
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        if (!this.world.isStatic && !this.dead) {
            this.c = -this.c;
            this.b = 10;
            this.damage += n * 10;
            this.af();
            if (this.damage > 40) {
                int n2;
                if (this.passenger != null) {
                    this.passenger.mount(this);
                }
                for (n2 = 0; n2 < 3; ++n2) {
                    this.a(Block.WOOD.id, 1, 0.0f);
                }
                for (n2 = 0; n2 < 2; ++n2) {
                    this.a(Item.STICK.id, 1, 0.0f);
                }
                this.die();
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean l_() {
        return !this.dead;
    }

    @Override
    public void m_() {
        super.m_();
        if (this.b > 0) {
            --this.b;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        int n = 5;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 0) / (double)n - 0.125;
            double d3 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 1) / (double)n - 0.125;
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.b(this.boundingBox.a, d2, this.boundingBox.c, this.boundingBox.d, d3, this.boundingBox.f);
            if (!this.world.b(axisAlignedBB, Material.WATER)) continue;
            d += 1.0 / (double)n;
        }
        if (this.world.isStatic) {
            if (this.d > 0) {
                double d4;
                double d5 = this.locX + (this.e - this.locX) / (double)this.d;
                double d6 = this.locY + (this.f - this.locY) / (double)this.d;
                double d7 = this.locZ + (this.g - this.locZ) / (double)this.d;
                for (d4 = this.h - (double)this.yaw; d4 < -180.0; d4 += 360.0) {
                }
                while (d4 >= 180.0) {
                    d4 -= 360.0;
                }
                this.yaw = (float)((double)this.yaw + d4 / (double)this.d);
                this.pitch = (float)((double)this.pitch + (this.i - (double)this.pitch) / (double)this.d);
                --this.d;
                this.setPosition(d5, d6, d7);
                this.c(this.yaw, this.pitch);
            } else {
                double d8 = this.locX + this.motX;
                double d9 = this.locY + this.motY;
                double d10 = this.locZ + this.motZ;
                this.setPosition(d8, d9, d10);
                if (this.onGround) {
                    this.motX *= 0.5;
                    this.motY *= 0.5;
                    this.motZ *= 0.5;
                }
                this.motX *= (double)0.99f;
                this.motY *= (double)0.95f;
                this.motZ *= (double)0.99f;
            }
        } else {
            double d11;
            int n2;
            double d12;
            double d13;
            double d14;
            if (d < 1.0) {
                double d15 = d * 2.0 - 1.0;
                this.motY += (double)0.04f * d15;
            } else {
                if (this.motY < 0.0) {
                    this.motY /= 2.0;
                }
                this.motY += (double)0.007f;
            }
            if (this.passenger != null) {
                this.motX += this.passenger.motX * 0.2;
                this.motZ += this.passenger.motZ * 0.2;
            }
            if (this.motX < -(d14 = 0.4)) {
                this.motX = -d14;
            }
            if (this.motX > d14) {
                this.motX = d14;
            }
            if (this.motZ < -d14) {
                this.motZ = -d14;
            }
            if (this.motZ > d14) {
                this.motZ = d14;
            }
            if (this.onGround) {
                this.motX *= 0.5;
                this.motY *= 0.5;
                this.motZ *= 0.5;
            }
            this.move(this.motX, this.motY, this.motZ);
            double d16 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d16 > 0.15) {
                d13 = Math.cos((double)this.yaw * Math.PI / 180.0);
                d12 = Math.sin((double)this.yaw * Math.PI / 180.0);
                n2 = 0;
                while ((double)n2 < 1.0 + d16 * 60.0) {
                    double d17;
                    double d18;
                    double d19 = this.random.nextFloat() * 2.0f - 1.0f;
                    double d20 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                    if (this.random.nextBoolean()) {
                        d18 = this.locX - d13 * d19 * 0.8 + d12 * d20;
                        d17 = this.locZ - d12 * d19 * 0.8 - d13 * d20;
                        this.world.a("splash", d18, this.locY - 0.125, d17, this.motX, this.motY, this.motZ);
                    } else {
                        d18 = this.locX + d13 + d12 * d19 * 0.7;
                        d17 = this.locZ + d12 - d13 * d19 * 0.7;
                        this.world.a("splash", d18, this.locY - 0.125, d17, this.motX, this.motY, this.motZ);
                    }
                    ++n2;
                }
            }
            if (this.positionChanged && d16 > 0.15) {
                if (!this.world.isStatic) {
                    this.die();
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.a(Block.WOOD.id, 1, 0.0f);
                    }
                    for (n2 = 0; n2 < 2; ++n2) {
                        this.a(Item.STICK.id, 1, 0.0f);
                    }
                }
            } else {
                this.motX *= (double)0.99f;
                this.motY *= (double)0.95f;
                this.motZ *= (double)0.99f;
            }
            this.pitch = 0.0f;
            d13 = this.yaw;
            d12 = this.lastX - this.locX;
            double d21 = this.lastZ - this.locZ;
            if (d12 * d12 + d21 * d21 > 0.001) {
                d13 = (float)(Math.atan2(d21, d12) * 180.0 / Math.PI);
            }
            for (d11 = d13 - (double)this.yaw; d11 >= 180.0; d11 -= 360.0) {
            }
            while (d11 < -180.0) {
                d11 += 360.0;
            }
            if (d11 > 20.0) {
                d11 = 20.0;
            }
            if (d11 < -20.0) {
                d11 = -20.0;
            }
            this.yaw = (float)((double)this.yaw + d11);
            this.c(this.yaw, this.pitch);
            List list = this.world.b(this, this.boundingBox.b(0.2f, 0.0, 0.2f));
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (entity == this.passenger || !entity.d_() || !(entity instanceof EntityBoat)) continue;
                    entity.collide(this);
                }
            }
            for (int i = 0; i < 4; ++i) {
                int n3;
                int n4;
                int n5 = MathHelper.floor(this.locX + ((double)(i % 2) - 0.5) * 0.8);
                if (this.world.getTypeId(n5, n4 = MathHelper.floor(this.locY), n3 = MathHelper.floor(this.locZ + ((double)(i / 2) - 0.5) * 0.8)) != Block.SNOW.id) continue;
                this.world.setTypeId(n5, n4, n3, 0);
            }
            if (this.passenger != null && this.passenger.dead) {
                this.passenger = null;
            }
        }
    }

    @Override
    public void f() {
        if (this.passenger != null) {
            double d = Math.cos((double)this.yaw * Math.PI / 180.0) * 0.4;
            double d2 = Math.sin((double)this.yaw * Math.PI / 180.0) * 0.4;
            this.passenger.setPosition(this.locX + d, this.locY + this.m() + this.passenger.I(), this.locZ + d2);
        }
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
            return true;
        }
        if (!this.world.isStatic) {
            entityHuman.mount(this);
        }
        return true;
    }
}

