/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Iterator;
import java.util.List;
import net.minecraft.server.AchievementList;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockBed;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerPlayer;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityFish;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.EnumBedError;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IInventory;
import net.minecraft.server.InventoryPlayer;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Statistic;
import net.minecraft.server.StatisticList;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityFurnace;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.World;

public abstract class EntityHuman
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public Container defaultContainer;
    public Container activeContainer;
    public byte l = 0;
    public int m = 0;
    public float n;
    public float o;
    public boolean p = false;
    public int q = 0;
    public String name;
    public int dimension;
    public double t;
    public double u;
    public double v;
    public double w;
    public double x;
    public double y;
    protected boolean sleeping;
    public ChunkCoordinates A;
    private int sleepTicks;
    public float B;
    public float C;
    private ChunkCoordinates b;
    private ChunkCoordinates c;
    public int D = 20;
    protected boolean E = false;
    public float F;
    private int d = 0;
    public EntityFish hookedFish = null;

    public EntityHuman(World world) {
        super(world);
        this.activeContainer = this.defaultContainer = new ContainerPlayer(this.inventory, !world.isStatic);
        this.height = 1.62f;
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        this.setPositionRotation((double)chunkCoordinates.x + 0.5, chunkCoordinates.y + 1, (double)chunkCoordinates.z + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.U = "humanoid";
        this.T = 180.0f;
        this.maxFireTicks = 20;
        this.texture = "/mob/char.png";
    }

    @Override
    protected void b() {
        super.b();
        this.datawatcher.a(16, (byte)0);
    }

    @Override
    public void m_() {
        if (this.isSleeping()) {
            ++this.sleepTicks;
            if (this.sleepTicks > 100) {
                this.sleepTicks = 100;
            }
            if (!this.world.isStatic) {
                if (!this.o()) {
                    this.a(true, true, false);
                } else if (this.world.d()) {
                    this.a(false, true, true);
                }
            }
        } else if (this.sleepTicks > 0) {
            ++this.sleepTicks;
            if (this.sleepTicks >= 110) {
                this.sleepTicks = 0;
            }
        }
        super.m_();
        if (!this.world.isStatic && this.activeContainer != null && !this.activeContainer.b(this)) {
            this.y();
            this.activeContainer = this.defaultContainer;
        }
        this.t = this.w;
        this.u = this.x;
        this.v = this.y;
        double d = this.locX - this.w;
        double d2 = this.locY - this.x;
        double d3 = this.locZ - this.y;
        double d4 = 10.0;
        if (d > d4) {
            this.t = this.w = this.locX;
        }
        if (d3 > d4) {
            this.v = this.y = this.locZ;
        }
        if (d2 > d4) {
            this.u = this.x = this.locY;
        }
        if (d < -d4) {
            this.t = this.w = this.locX;
        }
        if (d3 < -d4) {
            this.v = this.y = this.locZ;
        }
        if (d2 < -d4) {
            this.u = this.x = this.locY;
        }
        this.w += d * 0.25;
        this.y += d3 * 0.25;
        this.x += d2 * 0.25;
        this.a(StatisticList.k, 1);
        if (this.vehicle == null) {
            this.c = null;
        }
    }

    @Override
    protected boolean D() {
        return this.health <= 0 || this.isSleeping();
    }

    protected void y() {
        this.activeContainer = this.defaultContainer;
    }

    @Override
    public void E() {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        super.E();
        this.n = this.o;
        this.o = 0.0f;
        this.i(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    @Override
    protected void c_() {
        if (this.p) {
            ++this.q;
            if (this.q >= 8) {
                this.q = 0;
                this.p = false;
            }
        } else {
            this.q = 0;
        }
        this.aa = (float)this.q / 8.0f;
    }

    @Override
    public void v() {
        List list;
        if (this.world.spawnMonsters == 0 && this.health < 20 && this.ticksLived % 20 * 12 == 0) {
            this.b(1);
        }
        this.inventory.f();
        this.n = this.o;
        super.v();
        float f = MathHelper.a(this.motX * this.motX + this.motZ * this.motZ);
        float f2 = (float)Math.atan(-this.motY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f2 = 0.0f;
        }
        this.o += (f - this.o) * 0.4f;
        this.aj += (f2 - this.aj) * 0.8f;
        if (this.health > 0 && (list = this.world.b(this, this.boundingBox.b(1.0, 0.0, 1.0))) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.dead) continue;
                this.i(entity);
            }
        }
    }

    private void i(Entity entity) {
        entity.b(this);
    }

    @Override
    public void die(Entity entity) {
        super.die(entity);
        this.b(0.2f, 0.2f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.motY = 0.1f;
        if (this.name.equals("Notch")) {
            this.a(new ItemStack(Item.APPLE, 1), true);
        }
        this.inventory.h();
        if (entity != null) {
            this.motX = -MathHelper.cos((this.af + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motZ = -MathHelper.sin((this.af + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motZ = 0.0;
            this.motX = 0.0;
        }
        this.height = 0.1f;
        this.a(StatisticList.y, 1);
    }

    @Override
    public void c(Entity entity, int n) {
        this.m += n;
        if (entity instanceof EntityHuman) {
            this.a(StatisticList.A, 1);
        } else {
            this.a(StatisticList.z, 1);
        }
    }

    public void F() {
        this.a(this.inventory.splitStack(this.inventory.itemInHandIndex, 1), false);
    }

    public void b(ItemStack itemStack) {
        this.a(itemStack, false);
    }

    public void a(ItemStack itemStack, boolean bl) {
        if (itemStack != null) {
            EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY - (double)0.3f + (double)this.t(), this.locZ, itemStack);
            entityItem.pickupDelay = 40;
            float f = 0.1f;
            if (bl) {
                float f2 = this.random.nextFloat() * 0.5f;
                float f3 = this.random.nextFloat() * (float)Math.PI * 2.0f;
                entityItem.motX = -MathHelper.sin(f3) * f2;
                entityItem.motZ = MathHelper.cos(f3) * f2;
                entityItem.motY = 0.2f;
            } else {
                f = 0.3f;
                entityItem.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
                entityItem.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
                entityItem.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI) * f + 0.1f;
                f = 0.02f;
                float f4 = this.random.nextFloat() * (float)Math.PI * 2.0f;
                entityItem.motX += Math.cos(f4) * (double)(f *= this.random.nextFloat());
                entityItem.motY += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                entityItem.motZ += Math.sin(f4) * (double)f;
            }
            this.a(entityItem);
            this.a(StatisticList.v, 1);
        }
    }

    protected void a(EntityItem entityItem) {
        this.world.addEntity(entityItem);
    }

    public float a(Block block) {
        float f = this.inventory.a(block);
        if (this.a(Material.WATER)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean b(Block block) {
        return this.inventory.b(block);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.l("Inventory");
        this.inventory.b(nBTTagList);
        this.dimension = nBTTagCompound.e("Dimension");
        this.sleeping = nBTTagCompound.m("Sleeping");
        this.sleepTicks = nBTTagCompound.d("SleepTimer");
        if (this.sleeping) {
            this.A = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
            this.a(true, true, false);
        }
        if (nBTTagCompound.hasKey("SpawnX") && nBTTagCompound.hasKey("SpawnY") && nBTTagCompound.hasKey("SpawnZ")) {
            this.b = new ChunkCoordinates(nBTTagCompound.e("SpawnX"), nBTTagCompound.e("SpawnY"), nBTTagCompound.e("SpawnZ"));
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Inventory", this.inventory.a(new NBTTagList()));
        nBTTagCompound.a("Dimension", this.dimension);
        nBTTagCompound.a("Sleeping", this.sleeping);
        nBTTagCompound.a("SleepTimer", (short)this.sleepTicks);
        if (this.b != null) {
            nBTTagCompound.a("SpawnX", this.b.x);
            nBTTagCompound.a("SpawnY", this.b.y);
            nBTTagCompound.a("SpawnZ", this.b.z);
        }
    }

    public void a(IInventory iInventory) {
    }

    public void b(int n, int n2, int n3) {
    }

    public void receive(Entity entity, int n) {
    }

    @Override
    public float t() {
        return 0.12f;
    }

    protected void s() {
        this.height = 1.62f;
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        this.ay = 0;
        if (this.health <= 0) {
            return false;
        }
        if (this.isSleeping() && !this.world.isStatic) {
            this.a(true, true, false);
        }
        if (entity instanceof EntityMonster || entity instanceof EntityArrow) {
            if (this.world.spawnMonsters == 0) {
                n = 0;
            }
            if (this.world.spawnMonsters == 1) {
                n = n / 3 + 1;
            }
            if (this.world.spawnMonsters == 3) {
                n = n * 3 / 2;
            }
        }
        if (n == 0) {
            return false;
        }
        Entity entity2 = entity;
        if (entity instanceof EntityArrow && ((EntityArrow)entity).shooter != null) {
            entity2 = ((EntityArrow)entity).shooter;
        }
        if (entity2 instanceof EntityLiving) {
            this.a((EntityLiving)entity2, false);
        }
        this.a(StatisticList.x, n);
        return super.damageEntity(entity, n);
    }

    protected boolean j_() {
        return false;
    }

    protected void a(EntityLiving entityLiving, boolean bl) {
        if (!(entityLiving instanceof EntityCreeper) && !(entityLiving instanceof EntityGhast)) {
            Object object;
            if (entityLiving instanceof EntityWolf && ((EntityWolf)(object = (EntityWolf)entityLiving)).isTamed() && this.name.equals(((EntityWolf)object).getOwnerName())) {
                return;
            }
            if (!(entityLiving instanceof EntityHuman) || this.j_()) {
                object = this.world.a(EntityWolf.class, AxisAlignedBB.b(this.locX, this.locY, this.locZ, this.locX + 1.0, this.locY + 1.0, this.locZ + 1.0).b(16.0, 4.0, 16.0));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Entity entity = (Entity)iterator.next();
                    EntityWolf entityWolf = (EntityWolf)entity;
                    if (!entityWolf.isTamed() || entityWolf.F() != null || !this.name.equals(entityWolf.getOwnerName()) || bl && entityWolf.isSitting()) continue;
                    entityWolf.setSitting(false);
                    entityWolf.setTarget(entityLiving);
                }
            }
        }
    }

    @Override
    protected void c(int n) {
        int n2 = 25 - this.inventory.g();
        int n3 = n * n2 + this.d;
        this.inventory.c(n);
        n = n3 / 25;
        this.d = n3 % 25;
        super.c(n);
    }

    public void a(TileEntityFurnace tileEntityFurnace) {
    }

    public void a(TileEntityDispenser tileEntityDispenser) {
    }

    public void a(TileEntitySign tileEntitySign) {
    }

    public void c(Entity entity) {
        ItemStack itemStack;
        if (!entity.a(this) && (itemStack = this.G()) != null && entity instanceof EntityLiving) {
            itemStack.a((EntityLiving)entity);
            if (itemStack.count <= 0) {
                itemStack.a(this);
                this.H();
            }
        }
    }

    public ItemStack G() {
        return this.inventory.getItemInHand();
    }

    public void H() {
        this.inventory.setItem(this.inventory.itemInHandIndex, null);
    }

    @Override
    public double I() {
        return this.height - 0.5f;
    }

    public void w() {
        this.q = -1;
        this.p = true;
    }

    public void d(Entity entity) {
        int n = this.inventory.a(entity);
        if (n > 0) {
            if (this.motY < 0.0) {
                ++n;
            }
            entity.damageEntity(this, n);
            ItemStack itemStack = this.G();
            if (itemStack != null && entity instanceof EntityLiving) {
                itemStack.a((EntityLiving)entity, this);
                if (itemStack.count <= 0) {
                    itemStack.a(this);
                    this.H();
                }
            }
            if (entity instanceof EntityLiving) {
                if (entity.T()) {
                    this.a((EntityLiving)entity, true);
                }
                this.a(StatisticList.w, n);
            }
        }
    }

    public void a(ItemStack itemStack) {
    }

    @Override
    public void die() {
        super.die();
        this.defaultContainer.a(this);
        if (this.activeContainer != null) {
            this.activeContainer.a(this);
        }
    }

    @Override
    public boolean K() {
        return !this.sleeping && super.K();
    }

    public EnumBedError a(int n, int n2, int n3) {
        if (!this.world.isStatic) {
            if (this.isSleeping() || !this.T()) {
                return EnumBedError.OTHER_PROBLEM;
            }
            if (this.world.worldProvider.c) {
                return EnumBedError.NOT_POSSIBLE_HERE;
            }
            if (this.world.d()) {
                return EnumBedError.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.locX - (double)n) > 3.0 || Math.abs(this.locY - (double)n2) > 2.0 || Math.abs(this.locZ - (double)n3) > 3.0) {
                return EnumBedError.TOO_FAR_AWAY;
            }
        }
        this.b(0.2f, 0.2f);
        this.height = 0.2f;
        if (this.world.isLoaded(n, n2, n3)) {
            int n4 = this.world.getData(n, n2, n3);
            int n5 = BlockBed.c(n4);
            float f = 0.5f;
            float f2 = 0.5f;
            switch (n5) {
                case 0: {
                    f2 = 0.9f;
                    break;
                }
                case 1: {
                    f = 0.1f;
                    break;
                }
                case 2: {
                    f2 = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.9f;
                }
            }
            this.e(n5);
            this.setPosition((float)n + f, (float)n2 + 0.9375f, (float)n3 + f2);
        } else {
            this.setPosition((float)n + 0.5f, (float)n2 + 0.9375f, (float)n3 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTicks = 0;
        this.A = new ChunkCoordinates(n, n2, n3);
        this.motY = 0.0;
        this.motZ = 0.0;
        this.motX = 0.0;
        if (!this.world.isStatic) {
            this.world.everyoneSleeping();
        }
        return EnumBedError.OK;
    }

    private void e(int n) {
        this.B = 0.0f;
        this.C = 0.0f;
        switch (n) {
            case 0: {
                this.C = -1.8f;
                break;
            }
            case 1: {
                this.B = 1.8f;
                break;
            }
            case 2: {
                this.C = 1.8f;
                break;
            }
            case 3: {
                this.B = -1.8f;
            }
        }
    }

    public void a(boolean bl, boolean bl2, boolean bl3) {
        this.b(0.6f, 1.8f);
        this.s();
        ChunkCoordinates chunkCoordinates = this.A;
        ChunkCoordinates chunkCoordinates2 = this.A;
        if (chunkCoordinates != null && this.world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) == Block.BED.id) {
            BlockBed.a(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, false);
            chunkCoordinates2 = BlockBed.f(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
            if (chunkCoordinates2 == null) {
                chunkCoordinates2 = new ChunkCoordinates(chunkCoordinates.x, chunkCoordinates.y + 1, chunkCoordinates.z);
            }
            this.setPosition((float)chunkCoordinates2.x + 0.5f, (float)chunkCoordinates2.y + this.height + 0.1f, (float)chunkCoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.world.isStatic && bl2) {
            this.world.everyoneSleeping();
        }
        this.sleepTicks = bl ? 0 : 100;
        if (bl3) {
            this.a(this.A);
        }
    }

    private boolean o() {
        return this.world.getTypeId(this.A.x, this.A.y, this.A.z) == Block.BED.id;
    }

    public static ChunkCoordinates getBed(World world, ChunkCoordinates chunkCoordinates) {
        IChunkProvider iChunkProvider = world.o();
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z + 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z + 3 >> 4);
        if (world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) != Block.BED.id) {
            return null;
        }
        ChunkCoordinates chunkCoordinates2 = BlockBed.f(world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
        return chunkCoordinates2;
    }

    @Override
    public boolean isSleeping() {
        return this.sleeping;
    }

    public boolean isDeeplySleeping() {
        return this.sleeping && this.sleepTicks >= 100;
    }

    public void a(String string) {
    }

    public ChunkCoordinates getBed() {
        return this.b;
    }

    public void a(ChunkCoordinates chunkCoordinates) {
        this.b = chunkCoordinates != null ? new ChunkCoordinates(chunkCoordinates) : null;
    }

    public void a(Statistic statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic statistic, int n) {
    }

    @Override
    protected void O() {
        super.O();
        this.a(StatisticList.u, 1);
    }

    @Override
    public void a(float f, float f2) {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        super.a(f, f2);
        this.h(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    private void h(double d, double d2, double d3) {
        if (this.vehicle == null) {
            if (this.a(Material.WATER)) {
                int n = Math.round(MathHelper.a(d * d + d2 * d2 + d3 * d3) * 100.0f);
                if (n > 0) {
                    this.a(StatisticList.q, n);
                }
            } else if (this.ad()) {
                int n = Math.round(MathHelper.a(d * d + d3 * d3) * 100.0f);
                if (n > 0) {
                    this.a(StatisticList.m, n);
                }
            } else if (this.p()) {
                if (d2 > 0.0) {
                    this.a(StatisticList.o, (int)Math.round(d2 * 100.0));
                }
            } else if (this.onGround) {
                int n = Math.round(MathHelper.a(d * d + d3 * d3) * 100.0f);
                if (n > 0) {
                    this.a(StatisticList.l, n);
                }
            } else {
                int n = Math.round(MathHelper.a(d * d + d3 * d3) * 100.0f);
                if (n > 25) {
                    this.a(StatisticList.p, n);
                }
            }
        }
    }

    private void i(double d, double d2, double d3) {
        int n;
        if (this.vehicle != null && (n = Math.round(MathHelper.a(d * d + d2 * d2 + d3 * d3) * 100.0f)) > 0) {
            if (this.vehicle instanceof EntityMinecart) {
                this.a(StatisticList.r, n);
                if (this.c == null) {
                    this.c = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
                } else if (this.c.a(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) >= 1000.0) {
                    this.a(AchievementList.q, 1);
                }
            } else if (this.vehicle instanceof EntityBoat) {
                this.a(StatisticList.s, n);
            } else if (this.vehicle instanceof EntityPig) {
                this.a(StatisticList.t, n);
            }
        }
    }

    @Override
    protected void a(float f) {
        if (f >= 2.0f) {
            this.a(StatisticList.n, (int)Math.round((double)f * 100.0));
        }
        super.a(f);
    }

    @Override
    public void a(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityMonster) {
            this.a(AchievementList.s);
        }
    }

    @Override
    public void P() {
        if (this.D > 0) {
            this.D = 10;
        } else {
            this.E = true;
        }
    }
}

