/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityItem
extends Entity {
    public ItemStack itemStack;
    private int e;
    public int b = 0;
    public int pickupDelay;
    private int f = 5;
    public float d = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(world);
        this.b(0.25f, 0.25f);
        this.height = this.width / 2.0f;
        this.setPosition(d, d2, d3);
        this.itemStack = itemStack;
        this.yaw = (float)(Math.random() * 360.0);
        this.motX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motY = 0.2f;
        this.motZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    @Override
    protected boolean n() {
        return false;
    }

    public EntityItem(World world) {
        super(world);
        this.b(0.25f, 0.25f);
        this.height = this.width / 2.0f;
    }

    @Override
    protected void b() {
    }

    @Override
    public void m_() {
        super.m_();
        if (this.pickupDelay > 0) {
            --this.pickupDelay;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.04f;
        if (this.world.getMaterial(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) == Material.LAVA) {
            this.motY = 0.2f;
            this.motX = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.motZ = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.world.makeSound(this, "random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        this.g(this.locX, (this.boundingBox.b + this.boundingBox.e) / 2.0, this.locZ);
        this.move(this.motX, this.motY, this.motZ);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
            if (n > 0) {
                f = Block.byId[n].frictionFactor * 0.98f;
            }
        }
        this.motX *= (double)f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)f;
        if (this.onGround) {
            this.motY *= -0.5;
        }
        ++this.e;
        ++this.b;
        if (this.b >= 6000) {
            this.die();
        }
    }

    @Override
    public boolean f_() {
        return this.world.a(this.boundingBox, Material.WATER, this);
    }

    @Override
    protected void burn(int n) {
        this.damageEntity(null, n);
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        this.af();
        this.f -= n;
        if (this.f <= 0) {
            this.die();
        }
        return false;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Health", (short)((byte)this.f));
        nBTTagCompound.a("Age", (short)this.b);
        nBTTagCompound.a("Item", this.itemStack.a(new NBTTagCompound()));
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.f = nBTTagCompound.d("Health") & 0xFF;
        this.b = nBTTagCompound.d("Age");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.k("Item");
        this.itemStack = new ItemStack(nBTTagCompound2);
    }

    @Override
    public void b(EntityHuman entityHuman) {
        if (!this.world.isStatic) {
            int n = this.itemStack.count;
            if (this.pickupDelay == 0 && entityHuman.inventory.pickup(this.itemStack)) {
                if (this.itemStack.id == Block.LOG.id) {
                    entityHuman.a(AchievementList.g);
                }
                if (this.itemStack.id == Item.LEATHER.id) {
                    entityHuman.a(AchievementList.t);
                }
                this.world.makeSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                entityHuman.receive(this, n);
                if (this.itemStack.count <= 0) {
                    this.die();
                }
            }
        }
    }
}

