/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityLiving
extends Entity {
    public int maxNoDamageTicks = 20;
    public float I;
    public float J;
    public float K = 0.0f;
    public float L = 0.0f;
    protected float M;
    protected float N;
    protected float O;
    protected float P;
    protected boolean Q = true;
    protected String texture = "/mob/char.png";
    protected boolean S = true;
    protected float T = 0.0f;
    protected String U = null;
    protected float V = 1.0f;
    protected int W = 0;
    protected float X = 0.0f;
    public boolean Y = false;
    public float Z;
    public float aa;
    public int health = 10;
    public int ac;
    private int a;
    public int hurtTicks;
    public int ae;
    public float af = 0.0f;
    public int deathTicks = 0;
    public int attackTicks = 0;
    public float ai;
    public float aj;
    protected boolean ak = false;
    public int al = -1;
    public float am = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float an;
    public float ao;
    public float ap;
    protected int aq;
    protected double ar;
    protected double as;
    protected double at;
    protected double au;
    protected double av;
    float aw = 0.0f;
    protected int lastDamage = 0;
    protected int ay = 0;
    protected float az;
    protected float aA;
    protected float aB;
    protected boolean aC = false;
    protected float aD = 0.0f;
    protected float aE = 0.7f;
    private Entity b;
    protected int aF = 0;

    public EntityLiving(World world) {
        super(world);
        this.aI = true;
        this.J = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.I = (float)Math.random() * 12398.0f;
        this.yaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.bs = 0.5f;
    }

    @Override
    protected void b() {
    }

    public boolean e(Entity entity) {
        return this.world.a(Vec3D.create(this.locX, this.locY + (double)this.t(), this.locZ), Vec3D.create(entity.locX, entity.locY + (double)entity.t(), entity.locZ)) == null;
    }

    @Override
    public boolean l_() {
        return !this.dead;
    }

    @Override
    public boolean d_() {
        return !this.dead;
    }

    @Override
    public float t() {
        return this.width * 0.85f;
    }

    public int e() {
        return 80;
    }

    public void Q() {
        String string = this.g();
        if (string != null) {
            this.world.makeSound(this, string, this.k(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void R() {
        int n;
        this.Z = this.aa;
        super.R();
        if (this.random.nextInt(1000) < this.a++) {
            this.a = -this.e();
            this.Q();
        }
        if (this.T() && this.K()) {
            this.damageEntity(null, 1);
        }
        if (this.fireProof || this.world.isStatic) {
            this.fireTicks = 0;
        }
        if (this.T() && this.a(Material.WATER) && !this.b_()) {
            --this.airTicks;
            if (this.airTicks == -20) {
                this.airTicks = 0;
                for (n = 0; n < 8; ++n) {
                    float f = this.random.nextFloat() - this.random.nextFloat();
                    float f2 = this.random.nextFloat() - this.random.nextFloat();
                    float f3 = this.random.nextFloat() - this.random.nextFloat();
                    this.world.a("bubble", this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                }
                this.damageEntity(null, 2);
            }
            this.fireTicks = 0;
        } else {
            this.airTicks = this.maxAirTicks;
        }
        this.ai = this.aj;
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.hurtTicks > 0) {
            --this.hurtTicks;
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        if (this.health <= 0) {
            ++this.deathTicks;
            if (this.deathTicks > 20) {
                this.X();
                this.die();
                for (n = 0; n < 20; ++n) {
                    double d = this.random.nextGaussian() * 0.02;
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d3 = this.random.nextGaussian() * 0.02;
                    this.world.a("explode", this.locX + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length, this.locY + (double)(this.random.nextFloat() * this.width), this.locZ + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length, d, d2, d3);
                }
            }
        }
        this.P = this.O;
        this.L = this.K;
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
    }

    public void S() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            double d4 = 10.0;
            this.world.a("explode", this.locX + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length - d * d4, this.locY + (double)(this.random.nextFloat() * this.width) - d2 * d4, this.locZ + (double)(this.random.nextFloat() * this.length * 2.0f) - (double)this.length - d3 * d4, d, d2, d3);
        }
    }

    @Override
    public void E() {
        super.E();
        this.M = this.N;
        this.N = 0.0f;
    }

    @Override
    public void m_() {
        boolean bl;
        float f;
        float f2;
        super.m_();
        this.v();
        double d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f3 = MathHelper.a(d * d + d2 * d2);
        float f4 = this.K;
        float f5 = 0.0f;
        this.M = this.N;
        float f6 = 0.0f;
        if (f3 > 0.05f) {
            f6 = 1.0f;
            f5 = f3 * 3.0f;
            f4 = (float)Math.atan2(d2, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.aa > 0.0f) {
            f4 = this.yaw;
        }
        if (!this.onGround) {
            f6 = 0.0f;
        }
        this.N += (f6 - this.N) * 0.3f;
        for (f2 = f4 - this.K; f2 < -180.0f; f2 += 360.0f) {
        }
        while (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        this.K += f2 * 0.3f;
        for (f = this.yaw - this.K; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        boolean bl2 = bl = f < -90.0f || f >= 90.0f;
        if (f < -75.0f) {
            f = -75.0f;
        }
        if (f >= 75.0f) {
            f = 75.0f;
        }
        this.K = this.yaw - f;
        if (f * f > 2500.0f) {
            this.K += f * 0.2f;
        }
        if (bl) {
            f5 *= -1.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        while (this.K - this.L < -180.0f) {
            this.L -= 360.0f;
        }
        while (this.K - this.L >= 180.0f) {
            this.L += 360.0f;
        }
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        this.O += f5;
    }

    @Override
    protected void b(float f, float f2) {
        super.b(f, f2);
    }

    public void b(int n) {
        if (this.health > 0) {
            this.health += n;
            if (this.health > 20) {
                this.health = 20;
            }
            this.noDamageTicks = this.maxNoDamageTicks / 2;
        }
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        if (this.world.isStatic) {
            return false;
        }
        this.ay = 0;
        if (this.health <= 0) {
            return false;
        }
        this.ao = 1.5f;
        boolean bl = true;
        if ((float)this.noDamageTicks > (float)this.maxNoDamageTicks / 2.0f) {
            if (n <= this.lastDamage) {
                return false;
            }
            this.c(n - this.lastDamage);
            this.lastDamage = n;
            bl = false;
        } else {
            this.lastDamage = n;
            this.ac = this.health;
            this.noDamageTicks = this.maxNoDamageTicks;
            this.c(n);
            this.ae = 10;
            this.hurtTicks = 10;
        }
        this.af = 0.0f;
        if (bl) {
            this.world.a(this, (byte)2);
            this.af();
            if (entity != null) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                while (d * d + d2 * d2 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d2 = (Math.random() - Math.random()) * 0.01;
                }
                this.af = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - this.yaw;
                this.a(entity, n, d, d2);
            } else {
                this.af = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (bl) {
                this.world.makeSound(this, this.i(), this.k(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.die(entity);
        } else if (bl) {
            this.world.makeSound(this, this.h(), this.k(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    protected void c(int n) {
        this.health -= n;
    }

    protected float k() {
        return 1.0f;
    }

    protected String g() {
        return null;
    }

    protected String h() {
        return "random.hurt";
    }

    protected String i() {
        return "random.hurt";
    }

    public void a(Entity entity, int n, double d, double d2) {
        float f = MathHelper.a(d * d + d2 * d2);
        float f2 = 0.4f;
        this.motX /= 2.0;
        this.motY /= 2.0;
        this.motZ /= 2.0;
        this.motX -= d / (double)f * (double)f2;
        this.motY += (double)0.4f;
        this.motZ -= d2 / (double)f * (double)f2;
        if (this.motY > (double)0.4f) {
            this.motY = 0.4f;
        }
    }

    public void die(Entity entity) {
        if (this.W >= 0 && entity != null) {
            entity.c(this, this.W);
        }
        if (entity != null) {
            entity.a(this);
        }
        this.ak = true;
        if (!this.world.isStatic) {
            this.q();
        }
        this.world.a(this, (byte)3);
    }

    protected void q() {
        int n = this.j();
        if (n > 0) {
            int n2 = this.random.nextInt(3);
            for (int i = 0; i < n2; ++i) {
                this.b(n, 1);
            }
        }
    }

    protected int j() {
        return 0;
    }

    @Override
    protected void a(float f) {
        super.a(f);
        int n = (int)Math.ceil(f - 3.0f);
        if (n > 0) {
            this.damageEntity(null, n);
            int n2 = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.locY - (double)0.2f - (double)this.height), MathHelper.floor(this.locZ));
            if (n2 > 0) {
                StepSound stepSound = Block.byId[n2].stepSound;
                this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.5f, stepSound.getVolume2() * 0.75f);
            }
        }
    }

    public void a(float f, float f2) {
        double d;
        if (this.ad()) {
            d = this.locY;
            this.a(f, f2, 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= (double)0.8f;
            this.motY *= (double)0.8f;
            this.motZ *= (double)0.8f;
            this.motY -= 0.02;
            if (this.positionChanged && this.b(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else if (this.ae()) {
            d = this.locY;
            this.a(f, f2, 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
            this.motY -= 0.02;
            if (this.positionChanged && this.b(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else {
            float f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f3 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            float f4 = 0.16277136f / (f3 * f3 * f3);
            this.a(f, f2, this.onGround ? 0.1f * f4 : 0.02f);
            f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f3 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            if (this.p()) {
                float f5 = 0.15f;
                if (this.motX < (double)(-f5)) {
                    this.motX = -f5;
                }
                if (this.motX > (double)f5) {
                    this.motX = f5;
                }
                if (this.motZ < (double)(-f5)) {
                    this.motZ = -f5;
                }
                if (this.motZ > (double)f5) {
                    this.motZ = f5;
                }
                this.fallDistance = 0.0f;
                if (this.motY < -0.15) {
                    this.motY = -0.15;
                }
                if (this.isSneaking() && this.motY < 0.0) {
                    this.motY = 0.0;
                }
            }
            this.move(this.motX, this.motY, this.motZ);
            if (this.positionChanged && this.p()) {
                this.motY = 0.2;
            }
            this.motY -= 0.08;
            this.motY *= (double)0.98f;
            this.motX *= (double)f3;
            this.motZ *= (double)f3;
        }
        this.an = this.ao;
        d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f6 = MathHelper.a(d * d + d2 * d2) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.ao += (f6 - this.ao) * 0.4f;
        this.ap += this.ao;
    }

    public boolean p() {
        int n;
        int n2;
        int n3 = MathHelper.floor(this.locX);
        return this.world.getTypeId(n3, n2 = MathHelper.floor(this.boundingBox.b), n = MathHelper.floor(this.locZ)) == Block.LADDER.id;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Health", (short)this.health);
        nBTTagCompound.a("HurtTime", (short)this.hurtTicks);
        nBTTagCompound.a("DeathTime", (short)this.deathTicks);
        nBTTagCompound.a("AttackTime", (short)this.attackTicks);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.health = nBTTagCompound.d("Health");
        if (!nBTTagCompound.hasKey("Health")) {
            this.health = 10;
        }
        this.hurtTicks = nBTTagCompound.d("HurtTime");
        this.deathTicks = nBTTagCompound.d("DeathTime");
        this.attackTicks = nBTTagCompound.d("AttackTime");
    }

    @Override
    public boolean T() {
        return !this.dead && this.health > 0;
    }

    public boolean b_() {
        return false;
    }

    public void v() {
        if (this.aq > 0) {
            double d;
            double d2 = this.locX + (this.ar - this.locX) / (double)this.aq;
            double d3 = this.locY + (this.as - this.locY) / (double)this.aq;
            double d4 = this.locZ + (this.at - this.locZ) / (double)this.aq;
            for (d = this.au - (double)this.yaw; d < -180.0; d += 360.0) {
            }
            while (d >= 180.0) {
                d -= 360.0;
            }
            this.yaw = (float)((double)this.yaw + d / (double)this.aq);
            this.pitch = (float)((double)this.pitch + (this.av - (double)this.pitch) / (double)this.aq);
            --this.aq;
            this.setPosition(d2, d3, d4);
            this.c(this.yaw, this.pitch);
            List list = this.world.getEntities(this, this.boundingBox.shrink(0.03125, 0.0, 0.03125));
            if (list.size() > 0) {
                double d5 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    AxisAlignedBB axisAlignedBB = (AxisAlignedBB)list.get(i);
                    if (!(axisAlignedBB.e > d5)) continue;
                    d5 = axisAlignedBB.e;
                }
                this.setPosition(d2, d3 += d5 - this.boundingBox.b, d4);
            }
        }
        if (this.D()) {
            this.aC = false;
            this.az = 0.0f;
            this.aA = 0.0f;
            this.aB = 0.0f;
        } else if (!this.Y) {
            this.c_();
        }
        boolean bl = this.ad();
        boolean bl2 = this.ae();
        if (this.aC) {
            if (bl) {
                this.motY += (double)0.04f;
            } else if (bl2) {
                this.motY += (double)0.04f;
            } else if (this.onGround) {
                this.O();
            }
        }
        this.az *= 0.98f;
        this.aA *= 0.98f;
        this.aB *= 0.9f;
        this.a(this.az, this.aA);
        List list = this.world.b(this, this.boundingBox.b(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.d_()) continue;
                entity.collide(this);
            }
        }
    }

    protected boolean D() {
        return this.health <= 0;
    }

    protected void O() {
        this.motY = 0.42f;
    }

    protected boolean h_() {
        return true;
    }

    protected void U() {
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, -1.0);
        if (this.h_() && entityHuman != null) {
            double d = entityHuman.locX - this.locX;
            double d2 = entityHuman.locY - this.locY;
            double d3 = entityHuman.locZ - this.locZ;
            double d4 = d * d + d2 * d2 + d3 * d3;
            if (d4 > 16384.0) {
                this.die();
            }
            if (this.ay > 600 && this.random.nextInt(800) == 0) {
                if (d4 < 1024.0) {
                    this.ay = 0;
                } else {
                    this.die();
                }
            }
        }
    }

    protected void c_() {
        ++this.ay;
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, -1.0);
        this.U();
        this.az = 0.0f;
        this.aA = 0.0f;
        float f = 8.0f;
        if (this.random.nextFloat() < 0.02f) {
            entityHuman = this.world.findNearbyPlayer(this, f);
            if (entityHuman != null) {
                this.b = entityHuman;
                this.aF = 10 + this.random.nextInt(20);
            } else {
                this.aB = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.b != null) {
            this.a(this.b, 10.0f, (float)this.u());
            if (this.aF-- <= 0 || this.b.dead || this.b.g(this) > (double)(f * f)) {
                this.b = null;
            }
        } else {
            if (this.random.nextFloat() < 0.05f) {
                this.aB = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
            this.yaw += this.aB;
            this.pitch = this.aD;
        }
        boolean bl = this.ad();
        boolean bl2 = this.ae();
        if (bl || bl2) {
            this.aC = this.random.nextFloat() < 0.8f;
        }
    }

    protected int u() {
        return 40;
    }

    public void a(Entity entity, float f, float f2) {
        double d;
        double d2 = entity.locX - this.locX;
        double d3 = entity.locZ - this.locZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            d = this.locY + (double)this.t() - (entityLiving.locY + (double)entityLiving.t());
        } else {
            d = (entity.boundingBox.b + entity.boundingBox.e) / 2.0 - (this.locY + (double)this.t());
        }
        double d4 = MathHelper.a(d2 * d2 + d3 * d3);
        float f3 = (float)(Math.atan2(d3, d2) * 180.0 / 3.1415927410125732) - 90.0f;
        float f4 = (float)(-(Math.atan2(d, d4) * 180.0 / 3.1415927410125732));
        this.pitch = -this.b(this.pitch, f4, f2);
        this.yaw = this.b(this.yaw, f3, f);
    }

    public boolean V() {
        return this.b != null;
    }

    public Entity W() {
        return this.b;
    }

    private float b(float f, float f2, float f3) {
        float f4;
        for (f4 = f2 - f; f4 < -180.0f; f4 += 360.0f) {
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    public void X() {
    }

    public boolean d() {
        return this.world.containsEntity(this.boundingBox) && this.world.getEntities(this, this.boundingBox).size() == 0 && !this.world.c(this.boundingBox);
    }

    @Override
    protected void Y() {
        this.damageEntity(null, 4);
    }

    @Override
    public Vec3D Z() {
        return this.b(1.0f);
    }

    public Vec3D b(float f) {
        if (f == 1.0f) {
            float f2 = MathHelper.cos(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f3 = MathHelper.sin(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = -MathHelper.cos(-this.pitch * ((float)Math.PI / 180));
            float f5 = MathHelper.sin(-this.pitch * ((float)Math.PI / 180));
            return Vec3D.create(f3 * f4, f5, f2 * f4);
        }
        float f6 = this.lastPitch + (this.pitch - this.lastPitch) * f;
        float f7 = this.lastYaw + (this.yaw - this.lastYaw) * f;
        float f8 = MathHelper.cos(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f9 = MathHelper.sin(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f10 = -MathHelper.cos(-f6 * ((float)Math.PI / 180));
        float f11 = MathHelper.sin(-f6 * ((float)Math.PI / 180));
        return Vec3D.create(f9 * f10, f11, f8 * f10);
    }

    public int l() {
        return 4;
    }

    public boolean isSleeping() {
        return false;
    }
}

