/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityCreature;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.IMonster;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityMonster
extends EntityCreature
implements IMonster {
    protected int damage = 2;

    public EntityMonster(World world) {
        super(world);
        this.health = 20;
    }

    @Override
    public void v() {
        float f = this.c(1.0f);
        if (f > 0.5f) {
            this.ay += 2;
        }
        super.v();
    }

    @Override
    public void m_() {
        super.m_();
        if (!this.world.isStatic && this.world.spawnMonsters == 0) {
            this.die();
        }
    }

    @Override
    protected Entity findTarget() {
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, 16.0);
        return entityHuman != null && this.e(entityHuman) ? entityHuman : null;
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        if (super.damageEntity(entity, n)) {
            if (this.passenger != entity && this.vehicle != entity) {
                if (entity != this) {
                    this.target = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void a(Entity entity, float f) {
        if (this.attackTicks <= 0 && f < 2.0f && entity.boundingBox.e > this.boundingBox.b && entity.boundingBox.b < this.boundingBox.e) {
            this.attackTicks = 20;
            entity.damageEntity(this, this.damage);
        }
    }

    @Override
    protected float a(int n, int n2, int n3) {
        return 0.5f - this.world.n(n, n2, n3);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
    }

    @Override
    public boolean d() {
        int n;
        int n2;
        int n3 = MathHelper.floor(this.locX);
        if (this.world.a(EnumSkyBlock.SKY, n3, n2 = MathHelper.floor(this.boundingBox.b), n = MathHelper.floor(this.locZ)) > this.random.nextInt(32)) {
            return false;
        }
        int n4 = this.world.getLightLevel(n3, n2, n);
        if (this.world.u()) {
            int n5 = this.world.f;
            this.world.f = 10;
            n4 = this.world.getLightLevel(n3, n2, n);
            this.world.f = n5;
        }
        return n4 <= this.random.nextInt(8) && super.d();
    }
}

