/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntitySheep
extends EntityAnimal {
    public static final float[][] a = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};

    public EntitySheep(World world) {
        super(world);
        this.texture = "/mob/sheep.png";
        this.b(0.9f, 1.3f);
    }

    @Override
    protected void b() {
        super.b();
        this.datawatcher.a(16, new Byte(0));
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        return super.damageEntity(entity, n);
    }

    @Override
    protected void q() {
        if (!this.isSheared()) {
            this.a(new ItemStack(Block.WOOL.id, 1, this.getColor()), 0.0f);
        }
    }

    @Override
    protected int j() {
        return Block.WOOL.id;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack.id == Item.SHEARS.id && !this.isSheared()) {
            if (!this.world.isStatic) {
                this.setSheared(true);
                int n = 2 + this.random.nextInt(3);
                for (int i = 0; i < n; ++i) {
                    EntityItem entityItem = this.a(new ItemStack(Block.WOOL.id, 1, this.getColor()), 1.0f);
                    entityItem.motY += (double)(this.random.nextFloat() * 0.05f);
                    entityItem.motX += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityItem.motZ += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemStack.damage(1, entityHuman);
        }
        return false;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Sheared", this.isSheared());
        nBTTagCompound.a("Color", (byte)this.getColor());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSheared(nBTTagCompound.m("Sheared"));
        this.setColor(nBTTagCompound.c("Color"));
    }

    @Override
    protected String g() {
        return "mob.sheep";
    }

    @Override
    protected String h() {
        return "mob.sheep";
    }

    @Override
    protected String i() {
        return "mob.sheep";
    }

    public int getColor() {
        return this.datawatcher.a(16) & 0xF;
    }

    public void setColor(int n) {
        byte by = this.datawatcher.a(16);
        this.datawatcher.watch(16, (byte)(by & 0xF0 | n & 0xF));
    }

    public boolean isSheared() {
        return (this.datawatcher.a(16) & 0x10) != 0;
    }

    public void setSheared(boolean bl) {
        byte by = this.datawatcher.a(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 0x10));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFEF));
        }
    }

    public static int a(Random random) {
        int n = random.nextInt(100);
        return n < 5 ? 15 : (n < 10 ? 7 : (n < 15 ? 8 : (n < 18 ? 12 : (random.nextInt(500) == 0 ? 6 : 0))));
    }
}

