/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Chunk;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntitySlime
extends EntityLiving
implements IMonster {
    public float a;
    public float b;
    private int size = 0;

    public EntitySlime(World world) {
        super(world);
        this.texture = "/mob/slime.png";
        int n = 1 << this.random.nextInt(3);
        this.height = 0.0f;
        this.size = this.random.nextInt(20) + 10;
        this.setSize(n);
    }

    @Override
    protected void b() {
        super.b();
        this.datawatcher.a(16, new Byte(1));
    }

    public void setSize(int n) {
        this.datawatcher.watch(16, new Byte((byte)n));
        this.b(0.6f * (float)n, 0.6f * (float)n);
        this.health = n * n;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public int getSize() {
        return this.datawatcher.a(16);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Size", this.getSize() - 1);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSize(nBTTagCompound.e("Size") + 1);
    }

    @Override
    public void m_() {
        this.b = this.a;
        boolean bl = this.onGround;
        super.m_();
        if (this.onGround && !bl) {
            int n = this.getSize();
            for (int i = 0; i < n * 8; ++i) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                float f2 = this.random.nextFloat() * 0.5f + 0.5f;
                float f3 = MathHelper.sin(f) * (float)n * 0.5f * f2;
                float f4 = MathHelper.cos(f) * (float)n * 0.5f * f2;
                this.world.a("slime", this.locX + (double)f3, this.boundingBox.b, this.locZ + (double)f4, 0.0, 0.0, 0.0);
            }
            if (n > 2) {
                this.world.makeSound(this, "mob.slime", this.k(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.a = -0.5f;
        }
        this.a *= 0.6f;
    }

    @Override
    protected void c_() {
        this.U();
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, 16.0);
        if (entityHuman != null) {
            this.a(entityHuman, 10.0f, 20.0f);
        }
        if (this.onGround && this.size-- <= 0) {
            this.size = this.random.nextInt(20) + 10;
            if (entityHuman != null) {
                this.size /= 3;
            }
            this.aC = true;
            if (this.getSize() > 1) {
                this.world.makeSound(this, "mob.slime", this.k(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.a = 1.0f;
            this.az = 1.0f - this.random.nextFloat() * 2.0f;
            this.aA = 1 * this.getSize();
        } else {
            this.aC = false;
            if (this.onGround) {
                this.aA = 0.0f;
                this.az = 0.0f;
            }
        }
    }

    @Override
    public void die() {
        int n = this.getSize();
        if (!this.world.isStatic && n > 1 && this.health == 0) {
            for (int i = 0; i < 4; ++i) {
                float f = ((float)(i % 2) - 0.5f) * (float)n / 4.0f;
                float f2 = ((float)(i / 2) - 0.5f) * (float)n / 4.0f;
                EntitySlime entitySlime = new EntitySlime(this.world);
                entitySlime.setSize(n / 2);
                entitySlime.setPositionRotation(this.locX + (double)f, this.locY + 0.5, this.locZ + (double)f2, this.random.nextFloat() * 360.0f, 0.0f);
                this.world.addEntity(entitySlime);
            }
        }
        super.die();
    }

    @Override
    public void b(EntityHuman entityHuman) {
        int n = this.getSize();
        if (n > 1 && this.e(entityHuman) && (double)this.f(entityHuman) < 0.6 * (double)n && entityHuman.damageEntity(this, n)) {
            this.world.makeSound(this, "mob.slimeattack", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String h() {
        return "mob.slime";
    }

    @Override
    protected String i() {
        return "mob.slime";
    }

    @Override
    protected int j() {
        return this.getSize() == 1 ? Item.SLIME_BALL.id : 0;
    }

    @Override
    public boolean d() {
        Chunk chunk = this.world.getChunkAtWorldCoords(MathHelper.floor(this.locX), MathHelper.floor(this.locZ));
        return (this.getSize() == 1 || this.world.spawnMonsters > 0) && this.random.nextInt(10) == 0 && chunk.a(987234911L).nextInt(10) == 0 && this.locY < 16.0;
    }

    @Override
    protected float k() {
        return 0.6f;
    }
}

