/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.server.ChunkLoader;
import net.minecraft.server.CompressedStreamTools;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IDataManager;
import net.minecraft.server.MinecraftException;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PlayerFileData;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldProviderHell;

public class PlayerNBTManager
implements PlayerFileData,
IDataManager {
    private static final Logger a = Logger.getLogger("Minecraft");
    private final File b;
    private final File c;
    private final File d;
    private final long e = System.currentTimeMillis();

    public PlayerNBTManager(File file, String string, boolean bl) {
        this.b = new File(file, string);
        this.b.mkdirs();
        this.c = new File(this.b, "players");
        this.d = new File(this.b, "data");
        this.d.mkdirs();
        if (bl) {
            this.c.mkdirs();
        }
        this.f();
    }

    private void f() {
        try {
            File file = new File(this.b, "session.lock");
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));){
                dataOutputStream.writeLong(this.e);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    protected File a() {
        return this.b;
    }

    @Override
    public void b() {
        try {
            File file = new File(this.b, "session.lock");
            try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
                if (dataInputStream.readLong() != this.e) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException iOException) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    @Override
    public IChunkLoader a(WorldProvider worldProvider) {
        if (worldProvider instanceof WorldProviderHell) {
            File file = new File(this.b, "DIM-1");
            file.mkdirs();
            return new ChunkLoader(file, true);
        }
        return new ChunkLoader(this.b, true);
    }

    @Override
    public WorldData c() {
        File file = new File(this.b, "level.dat");
        if (file.exists()) {
            try {
                NBTTagCompound nBTTagCompound = CompressedStreamTools.a(new FileInputStream(file));
                NBTTagCompound nBTTagCompound2 = nBTTagCompound.k("Data");
                return new WorldData(nBTTagCompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file = new File(this.b, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nBTTagCompound = CompressedStreamTools.a(new FileInputStream(file));
                NBTTagCompound nBTTagCompound3 = nBTTagCompound.k("Data");
                return new WorldData(nBTTagCompound3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void a(WorldData worldData, List list) {
        NBTTagCompound nBTTagCompound = worldData.a(list);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.a("Data", (NBTBase)nBTTagCompound);
        try {
            File file = new File(this.b, "level.dat_new");
            File file2 = new File(this.b, "level.dat_old");
            File file3 = new File(this.b, "level.dat");
            CompressedStreamTools.a(nBTTagCompound2, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void a(WorldData worldData) {
        NBTTagCompound nBTTagCompound = worldData.a();
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.a("Data", (NBTBase)nBTTagCompound);
        try {
            File file = new File(this.b, "level.dat_new");
            File file2 = new File(this.b, "level.dat_old");
            File file3 = new File(this.b, "level.dat");
            CompressedStreamTools.a(nBTTagCompound2, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void a(EntityHuman entityHuman) {
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            entityHuman.d(nBTTagCompound);
            File file = new File(this.c, "_tmp_.dat");
            File file2 = new File(this.c, entityHuman.name + ".dat");
            CompressedStreamTools.a(nBTTagCompound, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        catch (Exception exception) {
            a.warning("Failed to save player data for " + entityHuman.name);
        }
    }

    @Override
    public void b(EntityHuman entityHuman) {
        NBTTagCompound nBTTagCompound = this.a(entityHuman.name);
        if (nBTTagCompound != null) {
            entityHuman.e(nBTTagCompound);
        }
    }

    public NBTTagCompound a(String string) {
        try {
            File file = new File(this.c, string + ".dat");
            if (file.exists()) {
                return CompressedStreamTools.a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            a.warning("Failed to load player data for " + string);
        }
        return null;
    }

    @Override
    public PlayerFileData d() {
        return this;
    }

    @Override
    public void e() {
    }

    @Override
    public File b(String string) {
        return new File(this.d, string + ".dat");
    }
}

