/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NetLoginHandler;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PlayerFileData;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.PortalTravelAgent;
import net.minecraft.server.TileEntity;
import net.minecraft.server.WorldServer;

public class ServerConfigurationManager {
    public static Logger a = Logger.getLogger("Minecraft");
    public List players = new ArrayList();
    private MinecraftServer server;
    private PlayerManager[] d = new PlayerManager[2];
    private int maxPlayers;
    private Set banByName = new HashSet();
    private Set banByIP = new HashSet();
    private Set h = new HashSet();
    private Set i = new HashSet();
    private File j;
    private File k;
    private File l;
    private File m;
    private PlayerFileData playerFileData;
    private boolean o;

    public ServerConfigurationManager(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        this.j = minecraftServer.a("banned-players.txt");
        this.k = minecraftServer.a("banned-ips.txt");
        this.l = minecraftServer.a("ops.txt");
        this.m = minecraftServer.a("white-list.txt");
        int n = minecraftServer.propertyManager.getInt("view-distance", 10);
        this.d[0] = new PlayerManager(minecraftServer, 0, n);
        this.d[1] = new PlayerManager(minecraftServer, -1, n);
        this.maxPlayers = minecraftServer.propertyManager.getInt("max-players", 20);
        this.o = minecraftServer.propertyManager.getBoolean("white-list", false);
        this.g();
        this.i();
        this.k();
        this.m();
        this.h();
        this.j();
        this.l();
        this.n();
    }

    public void setPlayerFileData(WorldServer[] worldServerArray) {
        this.playerFileData = worldServerArray[0].p().d();
    }

    public void a(EntityPlayer entityPlayer) {
        this.d[0].removePlayer(entityPlayer);
        this.d[1].removePlayer(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).addPlayer(entityPlayer);
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer.locX >> 4, (int)entityPlayer.locZ >> 4);
    }

    public int a() {
        return this.d[0].getFurthestViewableBlock();
    }

    private PlayerManager getPlayerManager(int n) {
        return n == -1 ? this.d[1] : this.d[0];
    }

    public void b(EntityPlayer entityPlayer) {
        this.playerFileData.b(entityPlayer);
    }

    public void c(EntityPlayer entityPlayer) {
        this.players.add(entityPlayer);
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer.locX >> 4, (int)entityPlayer.locZ >> 4);
        while (worldServer.getEntities(entityPlayer, entityPlayer.boundingBox).size() != 0) {
            entityPlayer.setPosition(entityPlayer.locX, entityPlayer.locY + 1.0, entityPlayer.locZ);
        }
        worldServer.addEntity(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).addPlayer(entityPlayer);
    }

    public void d(EntityPlayer entityPlayer) {
        this.getPlayerManager(entityPlayer.dimension).movePlayer(entityPlayer);
    }

    public void disconnect(EntityPlayer entityPlayer) {
        this.playerFileData.a(entityPlayer);
        this.server.getWorldServer(entityPlayer.dimension).kill(entityPlayer);
        this.players.remove(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).removePlayer(entityPlayer);
    }

    public EntityPlayer a(NetLoginHandler netLoginHandler, String string) {
        if (this.banByName.contains(string.trim().toLowerCase())) {
            netLoginHandler.disconnect("You are banned from this server!");
            return null;
        }
        if (!this.isWhitelisted(string)) {
            netLoginHandler.disconnect("You are not white-listed on this server!");
            return null;
        }
        String string2 = netLoginHandler.networkManager.getSocketAddress().toString();
        string2 = string2.substring(string2.indexOf("/") + 1);
        if (this.banByIP.contains(string2 = string2.substring(0, string2.indexOf(":")))) {
            netLoginHandler.disconnect("Your IP address is banned from this server!");
            return null;
        }
        if (this.players.size() >= this.maxPlayers) {
            netLoginHandler.disconnect("The server is full!");
            return null;
        }
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!entityPlayer.name.equalsIgnoreCase(string)) continue;
            entityPlayer.netServerHandler.disconnect("You logged in from another location");
        }
        return new EntityPlayer(this.server, this.server.getWorldServer(0), string, new ItemInWorldManager(this.server.getWorldServer(0)));
    }

    public EntityPlayer moveToWorld(EntityPlayer entityPlayer, int n) {
        this.server.getTracker(entityPlayer.dimension).untrackPlayer(entityPlayer);
        this.server.getTracker(entityPlayer.dimension).untrackEntity(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).removePlayer(entityPlayer);
        this.players.remove(entityPlayer);
        this.server.getWorldServer(entityPlayer.dimension).removeEntity(entityPlayer);
        ChunkCoordinates chunkCoordinates = entityPlayer.getBed();
        entityPlayer.dimension = n;
        EntityPlayer entityPlayer2 = new EntityPlayer(this.server, this.server.getWorldServer(entityPlayer.dimension), entityPlayer.name, new ItemInWorldManager(this.server.getWorldServer(entityPlayer.dimension)));
        entityPlayer2.id = entityPlayer.id;
        entityPlayer2.netServerHandler = entityPlayer.netServerHandler;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        if (chunkCoordinates != null) {
            ChunkCoordinates chunkCoordinates2 = EntityHuman.getBed(this.server.getWorldServer(entityPlayer.dimension), chunkCoordinates);
            if (chunkCoordinates2 != null) {
                entityPlayer2.setPositionRotation((float)chunkCoordinates2.x + 0.5f, (float)chunkCoordinates2.y + 0.1f, (float)chunkCoordinates2.z + 0.5f, 0.0f, 0.0f);
                entityPlayer2.a(chunkCoordinates);
            } else {
                entityPlayer2.netServerHandler.sendPacket(new Packet70Bed(0));
            }
        }
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer2.locX >> 4, (int)entityPlayer2.locZ >> 4);
        while (worldServer.getEntities(entityPlayer2, entityPlayer2.boundingBox).size() != 0) {
            entityPlayer2.setPosition(entityPlayer2.locX, entityPlayer2.locY + 1.0, entityPlayer2.locZ);
        }
        entityPlayer2.netServerHandler.sendPacket(new Packet9Respawn((byte)entityPlayer2.dimension));
        entityPlayer2.netServerHandler.a(entityPlayer2.locX, entityPlayer2.locY, entityPlayer2.locZ, entityPlayer2.yaw, entityPlayer2.pitch);
        this.a(entityPlayer2, worldServer);
        this.getPlayerManager(entityPlayer2.dimension).addPlayer(entityPlayer2);
        worldServer.addEntity(entityPlayer2);
        this.players.add(entityPlayer2);
        entityPlayer2.syncInventory();
        entityPlayer2.x();
        return entityPlayer2;
    }

    public void f(EntityPlayer entityPlayer) {
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        boolean bl = false;
        int n = entityPlayer.dimension == -1 ? 0 : -1;
        entityPlayer.dimension = n;
        WorldServer worldServer2 = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.netServerHandler.sendPacket(new Packet9Respawn((byte)entityPlayer.dimension));
        worldServer.removeEntity(entityPlayer);
        entityPlayer.dead = false;
        double d = entityPlayer.locX;
        double d2 = entityPlayer.locZ;
        double d3 = 8.0;
        if (entityPlayer.dimension == -1) {
            entityPlayer.setPositionRotation(d /= d3, entityPlayer.locY, d2 /= d3, entityPlayer.yaw, entityPlayer.pitch);
            if (entityPlayer.T()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        } else {
            entityPlayer.setPositionRotation(d *= d3, entityPlayer.locY, d2 *= d3, entityPlayer.yaw, entityPlayer.pitch);
            if (entityPlayer.T()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        }
        if (entityPlayer.T()) {
            worldServer2.addEntity(entityPlayer);
            entityPlayer.setPositionRotation(d, entityPlayer.locY, d2, entityPlayer.yaw, entityPlayer.pitch);
            worldServer2.entityJoinedWorld(entityPlayer, false);
            worldServer2.chunkProviderServer.forceChunkLoad = true;
            new PortalTravelAgent().a(worldServer2, entityPlayer);
            worldServer2.chunkProviderServer.forceChunkLoad = false;
        }
        this.a(entityPlayer);
        entityPlayer.netServerHandler.a(entityPlayer.locX, entityPlayer.locY, entityPlayer.locZ, entityPlayer.yaw, entityPlayer.pitch);
        entityPlayer.spawnIn(worldServer2);
        this.a(entityPlayer, worldServer2);
        this.updateClient(entityPlayer);
    }

    public void b() {
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i].flush();
        }
    }

    public void flagDirty(int n, int n2, int n3, int n4) {
        this.getPlayerManager(n4).flagDirty(n, n2, n3);
    }

    public void sendAll(Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void a(Packet packet, int n) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (entityPlayer.dimension != n) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public String c() {
        String string = "";
        for (int i = 0; i < this.players.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + ((EntityPlayer)this.players.get((int)i)).name;
        }
        return string;
    }

    public void a(String string) {
        this.banByName.add(string.toLowerCase());
        this.h();
    }

    public void b(String string) {
        this.banByName.remove(string.toLowerCase());
        this.h();
    }

    private void g() {
        try {
            this.banByName.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.j));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.banByName.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load ban list: " + exception);
        }
    }

    private void h() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.j, false));
            for (String string : this.banByName) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save ban list: " + exception);
        }
    }

    public void c(String string) {
        this.banByIP.add(string.toLowerCase());
        this.j();
    }

    public void d(String string) {
        this.banByIP.remove(string.toLowerCase());
        this.j();
    }

    private void i() {
        try {
            this.banByIP.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.k));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.banByIP.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void j() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.k, false));
            for (String string : this.banByIP) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save ip ban list: " + exception);
        }
    }

    public void e(String string) {
        this.h.add(string.toLowerCase());
        this.l();
    }

    public void f(String string) {
        this.h.remove(string.toLowerCase());
        this.l();
    }

    private void k() {
        try {
            this.h.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.l));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.h.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void l() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.l, false));
            for (String string : this.h) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save ip ban list: " + exception);
        }
    }

    private void m() {
        try {
            this.i.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.i.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load white-list: " + exception);
        }
    }

    private void n() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.m, false));
            for (String string : this.i) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save white-list: " + exception);
        }
    }

    public boolean isWhitelisted(String string) {
        string = string.trim().toLowerCase();
        return !this.o || this.h.contains(string) || this.i.contains(string);
    }

    public boolean isOp(String string) {
        return this.h.contains(string.trim().toLowerCase());
    }

    public EntityPlayer i(String string) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!entityPlayer.name.equalsIgnoreCase(string)) continue;
            return entityPlayer;
        }
        return null;
    }

    public void a(String string, String string2) {
        EntityPlayer entityPlayer = this.i(string);
        if (entityPlayer != null) {
            entityPlayer.netServerHandler.sendPacket(new Packet3Chat(string2));
        }
    }

    public void sendPacketNearby(double d, double d2, double d3, double d4, int n, Packet packet) {
        this.sendPacketNearby(null, d, d2, d3, d4, n, packet);
    }

    public void sendPacketNearby(EntityHuman entityHuman, double d, double d2, double d3, double d4, int n, Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            double d5;
            double d6;
            double d7;
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (entityPlayer == entityHuman || entityPlayer.dimension != n || !((d7 = d - entityPlayer.locX) * d7 + (d6 = d2 - entityPlayer.locY) * d6 + (d5 = d3 - entityPlayer.locZ) * d5 < d4 * d4)) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void j(String string) {
        Packet3Chat packet3Chat = new Packet3Chat(string);
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!this.isOp(entityPlayer.name)) continue;
            entityPlayer.netServerHandler.sendPacket(packet3Chat);
        }
    }

    public boolean a(String string, Packet packet) {
        EntityPlayer entityPlayer = this.i(string);
        if (entityPlayer != null) {
            entityPlayer.netServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayers() {
        for (int i = 0; i < this.players.size(); ++i) {
            this.playerFileData.a((EntityHuman)this.players.get(i));
        }
    }

    public void a(int n, int n2, int n3, TileEntity tileEntity) {
    }

    public void k(String string) {
        this.i.add(string);
        this.n();
    }

    public void l(String string) {
        this.i.remove(string);
        this.n();
    }

    public Set e() {
        return this.i;
    }

    public void f() {
        this.m();
    }

    public void a(EntityPlayer entityPlayer, WorldServer worldServer) {
        entityPlayer.netServerHandler.sendPacket(new Packet4UpdateTime(worldServer.getTime()));
        if (worldServer.v()) {
            entityPlayer.netServerHandler.sendPacket(new Packet70Bed(1));
        }
    }

    public void updateClient(EntityPlayer entityPlayer) {
        entityPlayer.updateInventory(entityPlayer.defaultContainer);
        entityPlayer.C();
    }
}

