/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockFurnace;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.FurnaceRecipes;
import net.minecraft.server.IInventory;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;

public class TileEntityFurnace
extends TileEntity
implements IInventory {
    private ItemStack[] items = new ItemStack[3];
    public int burnTime = 0;
    public int ticksForCurrentFuel = 0;
    public int cookTime = 0;

    @Override
    public int getSize() {
        return this.items.length;
    }

    @Override
    public ItemStack getItem(int n) {
        return this.items[n];
    }

    @Override
    public ItemStack splitStack(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemStack itemStack = this.items[n];
                this.items[n] = null;
                return itemStack;
            }
            ItemStack itemStack = this.items[n].a(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemStack itemStack) {
        this.items[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
    }

    @Override
    public String getName() {
        return "Furnace";
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.l("Items");
        this.items = new ItemStack[this.getSize()];
        for (int i = 0; i < nBTTagList.c(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.a(i);
            byte by = nBTTagCompound2.c("Slot");
            if (by < 0 || by >= this.items.length) continue;
            this.items[by] = new ItemStack(nBTTagCompound2);
        }
        this.burnTime = nBTTagCompound.d("BurnTime");
        this.cookTime = nBTTagCompound.d("CookTime");
        this.ticksForCurrentFuel = this.fuelTime(this.items[1]);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("BurnTime", (short)this.burnTime);
        nBTTagCompound.a("CookTime", (short)this.cookTime);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.a("Slot", (byte)i);
            this.items[i].a(nBTTagCompound2);
            nBTTagList.a(nBTTagCompound2);
        }
        nBTTagCompound.a("Items", nBTTagList);
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void g_() {
        boolean bl = this.burnTime > 0;
        boolean bl2 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.world.isStatic) {
            if (this.burnTime == 0 && this.canBurn()) {
                this.ticksForCurrentFuel = this.burnTime = this.fuelTime(this.items[1]);
                if (this.burnTime > 0) {
                    bl2 = true;
                    if (this.items[1] != null) {
                        --this.items[1].count;
                        if (this.items[1].count == 0) {
                            this.items[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canBurn()) {
                ++this.cookTime;
                if (this.cookTime == 200) {
                    this.cookTime = 0;
                    this.burn();
                    bl2 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (bl != this.burnTime > 0) {
                bl2 = true;
                BlockFurnace.a(this.burnTime > 0, this.world, this.x, this.y, this.z);
            }
        }
        if (bl2) {
            this.update();
        }
    }

    private boolean canBurn() {
        if (this.items[0] == null) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.getInstance().a(this.items[0].getItem().id);
        return itemStack == null ? false : (this.items[2] == null ? true : (!this.items[2].doMaterialsMatch(itemStack) ? false : (this.items[2].count < this.getMaxStackSize() && this.items[2].count < this.items[2].getMaxStackSize() ? true : this.items[2].count < itemStack.getMaxStackSize())));
    }

    public void burn() {
        if (this.canBurn()) {
            ItemStack itemStack = FurnaceRecipes.getInstance().a(this.items[0].getItem().id);
            if (this.items[2] == null) {
                this.items[2] = itemStack.cloneItemStack();
            } else if (this.items[2].id == itemStack.id) {
                ++this.items[2].count;
            }
            --this.items[0].count;
            if (this.items[0].count <= 0) {
                this.items[0] = null;
            }
        }
    }

    private int fuelTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        int n = itemStack.getItem().id;
        return n < 256 && Block.byId[n].material == Material.WOOD ? 300 : (n == Item.STICK.id ? 100 : (n == Item.COAL.id ? 1600 : (n == Item.LAVA_BUCKET.id ? 20000 : (n == Block.SAPLING.id ? 100 : 0))));
    }

    @Override
    public boolean a_(EntityHuman entityHuman) {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : entityHuman.d((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0;
    }
}

