/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.b.a;
import com.mojang.minecraft.server.b;
import com.mojang.minecraft.server.c;
import com.mojang.minecraft.server.d;
import com.mojang.minecraft.server.e;
import com.mojang.minecraft.server.f;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class MinecraftServer
implements Runnable {
    static Logger a = Logger.getLogger("MinecraftServer");
    static DateFormat b = new SimpleDateFormat("HH:mm:ss");
    private com.mojang.a.a h;
    private Map i = new HashMap();
    private List j = new ArrayList();
    private List k = new ArrayList();
    private int l;
    private Properties m = new Properties();
    public Level c;
    private boolean n = false;
    public String d;
    public String e;
    private int o;
    private d[] p;
    public b f = new b("Admins", new File("admins.txt"), false);
    public b g = new b("Banned", new File("banned.txt"), false);
    private b q = new b("Banned (IP)", new File("banned-ip.txt"), false);

    public MinecraftServer() {
        try {
            this.m.load(new FileReader("server.properties"));
        }
        catch (Exception exception) {
            a.warning("Failed to load server.properties!");
        }
        try {
            this.d = this.m.getProperty("server-name", "Minecraft Server");
            this.e = this.m.getProperty("motd", "Welcome to my Minecraft Server!");
            this.o = Integer.parseInt(this.m.getProperty("port", "25565"));
            this.l = Integer.parseInt(this.m.getProperty("max-players", "16"));
            this.n = Boolean.parseBoolean(this.m.getProperty("public", "true"));
            if (this.l < 1) {
                this.l = 1;
            }
            if (this.l > 32) {
                this.l = 32;
            }
            this.m.setProperty("server-name", this.d);
            this.m.setProperty("motd", this.e);
            this.m.setProperty("max-players", "" + this.l);
            this.m.setProperty("port", "" + this.o);
            this.m.setProperty("public", "" + this.n);
        }
        catch (Exception exception) {
            a.warning("server.properties is broken! Delete it or fix it!");
            System.exit(0);
        }
        try {
            this.m.store(new FileWriter("server.properties"), "Minecraft server properties");
        }
        catch (Exception exception) {
            a.warning("Failed to save server.properties!");
        }
        this.p = new d[this.l];
        this.h = new com.mojang.a.a(this.o, this);
    }

    public final void a(com.mojang.a.b object) {
        if ((object = (d)this.i.get(object)) != null) {
            a.info(object + " disconnected");
            this.i.remove(((d)object).a);
            this.j.remove(object);
            if (((d)object).c >= 0) {
                this.p[((d)object).c] = null;
            }
            this.a(com.mojang.minecraft.a.a.n, ((d)object).c);
        }
    }

    private void b(com.mojang.a.b b2) {
        this.k.add(new c(b2, 40));
    }

    public final void a(d d2) {
        this.k.add(new c(d2.a, 40));
    }

    public static void b(d d2) {
        d2.a.a();
    }

    public final void a(com.mojang.minecraft.a.a a2, Object ... objectArray) {
        for (int j = 0; j < this.j.size(); ++j) {
            try {
                ((d)this.j.get(j)).b(a2, objectArray);
                continue;
            }
            catch (Exception exception) {
                ((d)this.j.get(j)).a(exception);
            }
        }
    }

    public final void a(d d2, com.mojang.minecraft.a.a a2, Object ... objectArray) {
        for (int j = 0; j < this.j.size(); ++j) {
            if (this.j.get(j) == d2) continue;
            try {
                ((d)this.j.get(j)).b(a2, objectArray);
                continue;
            }
            catch (Exception exception) {
                ((d)this.j.get(j)).a(exception);
            }
        }
    }

    @Override
    public void run() {
        a.info("Now accepting input on " + this.o);
        int n = 50000000;
        int n2 = 500000000;
        try {
            long l = System.nanoTime();
            long l2 = System.nanoTime();
            int n3 = 0;
            while (true) {
                this.c();
                while (System.nanoTime() - l2 > (long)n) {
                    MinecraftServer minecraftServer;
                    l2 += (long)n;
                    this.b();
                    if (n3 % 1200 == 0) {
                        minecraftServer = this;
                        a.info("Saving level");
                        a.info("Load: " + minecraftServer.j.size() + "/" + minecraftServer.l);
                        try {
                            new com.mojang.minecraft.level.a(minecraftServer);
                            com.mojang.minecraft.level.a.a(minecraftServer.c, new FileOutputStream("server_level.dat"));
                        }
                        catch (Exception exception) {
                            a.severe("Failed to save the level! " + exception);
                        }
                    }
                    if (n3 % 600 == 0) {
                        minecraftServer = this;
                        a.info("Sending heartbeat");
                        try {
                            Object object = new URL("http://www.minecraft.net/heartbeat.jsp");
                            object = (HttpURLConnection)((URL)object).openConnection();
                            ((HttpURLConnection)object).setRequestMethod("POST");
                            ((URLConnection)object).setDoOutput(true);
                            String string = "name=" + URLEncoder.encode(minecraftServer.d, "UTF-8") + "&users=" + URLEncoder.encode("" + minecraftServer.j.size(), "UTF-8") + "&max=" + URLEncoder.encode("" + minecraftServer.l, "UTF-8") + "&public=" + URLEncoder.encode("" + minecraftServer.n, "UTF-8") + "&port=" + URLEncoder.encode("" + minecraftServer.o, "UTF-8");
                            ((URLConnection)object).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            ((URLConnection)object).setRequestProperty("Content-Length", "" + Integer.toString(string.getBytes().length));
                            ((URLConnection)object).setRequestProperty("Content-Language", "en-US");
                            ((URLConnection)object).setUseCaches(false);
                            ((URLConnection)object).setDoInput(true);
                            ((URLConnection)object).setDoOutput(true);
                            new e(minecraftServer, (HttpURLConnection)object, string).start();
                        }
                        catch (Exception exception) {
                            a.severe("Failed to assemble heartbeat: " + exception);
                            exception.printStackTrace();
                        }
                    }
                    ++n3;
                }
                while (System.nanoTime() - l > (long)n2) {
                    l += (long)n2;
                    this.a(com.mojang.minecraft.a.a.c, new Object[0]);
                }
                Thread.sleep(5L);
            }
        }
        catch (Exception exception) {
            a.log(java.util.logging.Level.SEVERE, "Error in main loop, server shutting down!", exception);
            exception.printStackTrace();
            return;
        }
    }

    private void b() {
        this.c.tick();
        for (int j = 0; j < this.k.size(); ++j) {
            c c2 = (c)this.k.get(j);
            this.a(c2.a);
            try {
                Object object = c2;
                object = ((c)object).a;
                try {
                    if (((com.mojang.a.b)object).d.position() > 0) {
                        ((com.mojang.a.b)object).d.flip();
                        ((com.mojang.a.b)object).b.write(((com.mojang.a.b)object).d);
                        ((com.mojang.a.b)object).d.compact();
                    }
                }
                catch (IOException iOException) {}
                if (c2.b-- > 0) continue;
                try {
                    c2.a.a();
                }
                catch (Exception exception) {}
                this.k.remove(j--);
                continue;
            }
            catch (Exception exception) {
                try {
                    c2.a.a();
                    continue;
                }
                catch (Exception exception2) {}
            }
        }
    }

    public final void a(String string) {
        a.info(string);
    }

    public final void b(String string) {
        a.fine(string);
    }

    private void c() {
        Object object;
        Object object2 = ((MinecraftServer)((Object)a2)).j.iterator();
        while (object2.hasNext()) {
            object = (d)object2.next();
            try {
                ((d)object).a();
            }
            catch (Exception exception) {
                ((d)object).a(exception);
            }
        }
        try {
            Object object3;
            Object object4;
            com.mojang.a.a a2 = ((MinecraftServer)((Object)a2)).h;
            while ((object2 = a2.a.accept()) != null) {
                try {
                    ((AbstractSelectableChannel)object2).configureBlocking(false);
                    object = new com.mojang.a.b((SocketChannel)object2);
                    a2.c.add(object);
                    Object object5 = object;
                    object4 = a2.b;
                    object = object5;
                    if (((MinecraftServer)object4).q.c(((com.mojang.a.b)object).f)) {
                        ((com.mojang.a.b)object5).a(com.mojang.minecraft.a.a.p, "You're banned!");
                        object = object5;
                        a.info(((com.mojang.a.b)object).f + " tried to connect, but is banned.");
                        super.b((com.mojang.a.b)object5);
                        continue;
                    }
                    int n = super.d();
                    if (n < 0) {
                        ((com.mojang.a.b)object5).a(com.mojang.minecraft.a.a.p, "The server is full!");
                        object = object5;
                        a.info(((com.mojang.a.b)object).f + " tried to connect, but failed because the server was full.");
                        super.b((com.mojang.a.b)object5);
                        continue;
                    }
                    object3 = new d((MinecraftServer)object4, (com.mojang.a.b)object5, n);
                    a.info(object3 + " connected");
                    ((MinecraftServer)object4).i.put(object5, object3);
                    ((MinecraftServer)object4).j.add(object3);
                    if (((d)object3).c < 0) continue;
                    ((MinecraftServer)object4).p[((d)object3).c] = object3;
                }
                catch (IOException iOException) {
                    ((AbstractInterruptibleChannel)object2).close();
                    throw iOException;
                }
            }
            for (int j = 0; j < a2.c.size(); ++j) {
                block20: {
                    object2 = (com.mojang.a.b)a2.c.get(j);
                    try {
                        object4 = object2;
                        ((com.mojang.a.b)object4).b.read(((com.mojang.a.b)object4).c);
                        int n = 0;
                        while (((com.mojang.a.b)object4).c.position() > 0 && n++ != 100) {
                            ((com.mojang.a.b)object4).c.flip();
                            byte by = ((com.mojang.a.b)object4).c.get(0);
                            object3 = com.mojang.minecraft.a.a.a[by];
                            if (object3 == null) {
                                throw new IOException("Bad command: " + by);
                            }
                            if (((com.mojang.a.b)object4).c.remaining() >= ((com.mojang.minecraft.a.a)object3).q + 1) {
                                ((com.mojang.a.b)object4).c.get();
                                Object[] objectArray = new Object[((com.mojang.minecraft.a.a)object3).s.length];
                                for (int k = 0; k < objectArray.length; ++k) {
                                    objectArray[k] = ((com.mojang.a.b)object4).a(((com.mojang.minecraft.a.a)object3).s[k]);
                                }
                                ((com.mojang.a.b)object4).e.a((com.mojang.minecraft.a.a)object3, objectArray);
                                if (!((com.mojang.a.b)object4).a) break;
                                ((com.mojang.a.b)object4).c.compact();
                                continue;
                            }
                            ((com.mojang.a.b)object4).c.compact();
                            break;
                        }
                        if (((com.mojang.a.b)object4).d.position() > 0) {
                            ((com.mojang.a.b)object4).d.flip();
                            ((com.mojang.a.b)object4).b.write(((com.mojang.a.b)object4).d);
                            ((com.mojang.a.b)object4).d.compact();
                        }
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        Object object6 = object2;
                        object4 = a2.b;
                        object3 = (d)((MinecraftServer)object4).i.get(object6);
                        if (object3 == null) break block20;
                        ((d)object3).a(exception2);
                    }
                }
                try {
                    object4 = object2;
                    if (((com.mojang.a.b)object4).a) continue;
                    ((com.mojang.a.b)object2).a();
                    a2.b.a((com.mojang.a.b)object2);
                    a2.c.remove(j--);
                    continue;
                }
                catch (Exception exception) {
                    object4 = exception;
                    exception.printStackTrace();
                }
            }
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException while ticking socketserver", iOException);
        }
    }

    public final void a(int n, int n2, int n3) {
        this.a(com.mojang.minecraft.a.a.h, n, n2, n3, this.c.getTile(n, n2, n3));
    }

    private int d() {
        for (int j = 0; j < this.l; ++j) {
            if (this.p[j] != null) continue;
            return j;
        }
        return -1;
    }

    public final List a() {
        return this.j;
    }

    public final void c(String string) {
        boolean bl = false;
        for (d d2 : this.j) {
            if (!d2.b.equalsIgnoreCase(string)) continue;
            bl = true;
            d2.a("You were kicked");
        }
        if (bl) {
            this.a(com.mojang.minecraft.a.a.o, -1, string + " got kicked from the server!");
        }
    }

    public final void d(String string) {
        this.g.a(string);
        boolean bl = false;
        for (d d2 : this.j) {
            if (!d2.b.equalsIgnoreCase(string)) continue;
            bl = true;
            d2.a("You were banned");
        }
        if (bl) {
            this.a(com.mojang.minecraft.a.a.o, -1, string + " got banned!");
        }
    }

    public final void e(String string) {
        ((MinecraftServer)this).f.a(string);
        for (d d2 : ((MinecraftServer)this).j) {
            if (!d2.b.equalsIgnoreCase(string)) continue;
            d2.b("You're now op!");
        }
    }

    public final void f(String string) {
        ((MinecraftServer)this).f.b(string);
        for (d d2 : ((MinecraftServer)this).j) {
            if (!d2.b.equalsIgnoreCase(string)) continue;
            d2.b("You're no longer op!");
        }
    }

    public final void g(String string) {
        this.g.b(string);
    }

    public final void h(String string) {
        boolean bl = false;
        for (d d2 : this.j) {
            if (!d2.b.equalsIgnoreCase(string)) continue;
            com.mojang.a.b b2 = d2.a;
            this.q.a(b2.f);
            d2.a("You were banned");
            bl = true;
        }
        if (bl) {
            this.a(com.mojang.minecraft.a.a.o, -1, string + " got banned!");
        }
    }

    public static void main(String[] object) {
        try {
            object = new MinecraftServer();
            MinecraftServer minecraftServer = object;
            a.info("Setting up");
            try {
                minecraftServer.c = new com.mojang.minecraft.level.a(minecraftServer).a(new FileInputStream("server_level.dat"));
            }
            catch (Exception exception) {
                a.warning("Failed to load level. Generating a new level");
                exception.printStackTrace();
            }
            if (minecraftServer.c == null) {
                minecraftServer.c = new a(minecraftServer).a("--", 256, 256, 64);
            }
            try {
                new com.mojang.minecraft.level.a(minecraftServer);
                com.mojang.minecraft.level.a.a(minecraftServer.c, new FileOutputStream("server_level.dat"));
            }
            catch (Exception exception) {}
            minecraftServer.c.addListener$74652038(minecraftServer);
            object = new Thread((Runnable)object);
            object.start();
            return;
        }
        catch (Exception exception) {
            a.severe("Failed to start the server!");
            exception.printStackTrace();
            return;
        }
    }

    static {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new f());
        for (Handler handler : a.getParent().getHandlers()) {
            a.getParent().removeHandler(handler);
        }
        a.addHandler(consoleHandler);
    }
}

