/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.level.BlockMap;
import com.mojang.minecraft.level.b;
import com.mojang.minecraft.level.b.a;
import com.mojang.minecraft.level.c;
import com.mojang.minecraft.phys.AABB;
import com.mojang.minecraft.server.MinecraftServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Level
implements Serializable {
    public static final long serialVersionUID = 0L;
    public int width;
    public int height;
    public int depth;
    public byte[] blocks;
    public String name;
    public String creator;
    public long createTime;
    public int xSpawn;
    public int ySpawn;
    public int zSpawn;
    public float rotSpawn;
    private transient ArrayList a = new ArrayList();
    private transient int[] b;
    transient Random random = new Random();
    private transient int c = this.random.nextInt();
    private transient ArrayList d = new ArrayList();
    public BlockMap blockMap;
    private boolean networkMode = false;
    public transient c rendererContext;
    public boolean creativeMode;
    public int waterLevel;
    public int skyColor;
    public int fogColor;
    public int cloudColor;
    int unprocessed = 0;
    private int tickCount = 0;
    public Entity player;
    public transient com.mojang.minecraft.d.a particleEngine;
    public transient Object font;

    public void initTransient() {
        if (this.blocks == null) {
            throw new RuntimeException("The level is corrupt!");
        }
        this.a = new ArrayList();
        this.b = new int[this.width * this.height];
        Arrays.fill(this.b, this.depth);
        this.calcLightDepths(0, 0, this.width, this.height);
        this.random = new Random();
        this.c = this.random.nextInt();
        this.d = new ArrayList();
        if (this.waterLevel == 0) {
            this.waterLevel = this.depth / 2;
        }
        if (this.skyColor == 0) {
            this.skyColor = 0x99CCFF;
        }
        if (this.fogColor == 0) {
            this.fogColor = 0xFFFFFF;
        }
        if (this.cloudColor == 0) {
            this.cloudColor = 0xFFFFFF;
        }
        if (this.xSpawn == 0 && this.ySpawn == 0 && this.zSpawn == 0) {
            this.findSpawn();
        }
        if (this.blockMap == null) {
            this.blockMap = new BlockMap(this.width, this.depth, this.height);
        }
    }

    public void setData(int n2, int n3, int n4, byte[] byArray) {
        this.width = n2;
        this.height = n4;
        this.depth = n3;
        this.blocks = byArray;
        this.b = new int[n2 * n4];
        Arrays.fill(this.b, this.depth);
        this.calcLightDepths(0, 0, n2, n4);
        for (n2 = 0; n2 < this.a.size(); ++n2) {
            this.a.get(n2);
        }
        this.d.clear();
        this.findSpawn();
        this.initTransient();
        System.gc();
    }

    public void findSpawn() {
        int n2;
        int n3;
        int n4;
        Random random = new Random();
        int n5 = 0;
        do {
            n3 = random.nextInt(this.width / 2) + this.width / 4;
            n2 = random.nextInt(this.height / 2) + this.height / 4;
            n4 = this.getHighestTile(n3, n2) + 1;
            if (++n5 != 10000) continue;
            this.xSpawn = n3;
            this.ySpawn = -100;
            this.zSpawn = n2;
            return;
        } while ((float)n4 <= this.getWaterLevel());
        this.xSpawn = n3;
        this.ySpawn = n4;
        this.zSpawn = n2;
    }

    public void calcLightDepths(int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            for (int i3 = n3; i3 < n3 + n5; ++i3) {
                int n6;
                int n7 = this.b[i2 + i3 * this.width];
                for (n6 = this.depth - 1; n6 > 0 && !this.isLightBlocker(i2, n6, i3); --n6) {
                }
                this.b[i2 + i3 * this.width] = n6;
                if (n7 == n6) continue;
                for (n7 = 0; n7 < this.a.size(); ++n7) {
                    this.a.get(n7);
                }
            }
        }
    }

    public void addListener$74652038(MinecraftServer minecraftServer) {
        this.a.add(minecraftServer);
    }

    public void finalize() {
    }

    public void removeListener$74652038(MinecraftServer minecraftServer) {
        this.a.remove(minecraftServer);
    }

    public boolean isLightBlocker(int n2, int n3, int n4) {
        if ((this = com.mojang.minecraft.level.tile.a.b[((Level)this).getTile(n2, n3, n4)]) == null) {
            return false;
        }
        return ((com.mojang.minecraft.level.tile.a)this).b();
    }

    public ArrayList getCubes(AABB aABB) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        while (n2 < n3) {
            for (int i2 = n4; i2 < n5; ++i2) {
                for (int i3 = n6; i3 < n7; ++i3) {
                    Object object;
                    if (n2 >= 0 && i2 >= 0 && i3 >= 0 && n2 < this.width && i2 < this.depth && i3 < this.height) {
                        object = com.mojang.minecraft.level.tile.a.b[this.getTile(n2, i2, i3)];
                        if (object == null || (object = ((com.mojang.minecraft.level.tile.a)object).a(n2, i2, i3)) == null || !aABB.intersectsInner((AABB)object)) continue;
                        arrayList.add(object);
                        continue;
                    }
                    if (n2 >= 0 && i2 >= 0 && i3 >= 0 && n2 < this.width && i3 < this.height || (object = com.mojang.minecraft.level.tile.a.k.a(n2, i2, i3)) == null || !aABB.intersectsInner((AABB)object)) continue;
                    arrayList.add(object);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public void swap(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.networkMode) {
            return;
        }
        int n8 = this.getTile(n2, n3, n4);
        int n9 = this.getTile(n5, n6, n7);
        this.setTileNoNeighborChange(n2, n3, n4, n9);
        this.setTileNoNeighborChange(n5, n6, n7, n8);
        this.updateNeighborsAt(n2, n3, n4, n9);
        this.updateNeighborsAt(n5, n6, n7, n8);
    }

    public boolean setTileNoNeighborChange(int n2, int n3, int n4, int n5) {
        if (this.networkMode) {
            return false;
        }
        return this.netSetTileNoNeighborChange(n2, n3, n4, n5);
    }

    public boolean netSetTileNoNeighborChange(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 >= this.width || n3 >= this.depth || n4 >= this.height) {
            return false;
        }
        if (n5 == this.blocks[(n3 * this.height + n4) * this.width + n2]) {
            return false;
        }
        if (n5 == 0 && (n2 == 0 || n4 == 0 || n2 == this.width - 1 || n4 == this.height - 1) && (float)n3 >= this.getGroundLevel() && (float)n3 < this.getWaterLevel()) {
            n5 = com.mojang.minecraft.level.tile.a.l.ab;
        }
        byte by = this.blocks[(n3 * this.height + n4) * this.width + n2];
        this.blocks[(n3 * this.height + n4) * this.width + n2] = (byte)n5;
        if (by != 0) {
            com.mojang.minecraft.level.tile.a.b[by].c(this, n2, n3, n4);
        }
        if (n5 != 0) {
            com.mojang.minecraft.level.tile.a.b[n5].b(this, n2, n3, n4);
        }
        this.calcLightDepths(n2, n4, 1, 1);
        for (n5 = 0; n5 < this.a.size(); ++n5) {
            ((MinecraftServer)this.a.get(n5)).a(n2, n3, n4);
        }
        return true;
    }

    public boolean setTile(int n2, int n3, int n4, int n5) {
        if (this.networkMode) {
            return false;
        }
        if (this.setTileNoNeighborChange(n2, n3, n4, n5)) {
            this.updateNeighborsAt(n2, n3, n4, n5);
            return true;
        }
        return false;
    }

    public boolean netSetTile(int n2, int n3, int n4, int n5) {
        if (this.netSetTileNoNeighborChange(n2, n3, n4, n5)) {
            this.updateNeighborsAt(n2, n3, n4, n5);
            return true;
        }
        return false;
    }

    public void updateNeighborsAt(int n2, int n3, int n4, int n5) {
        this.a(n2 - 1, n3, n4, n5);
        this.a(n2 + 1, n3, n4, n5);
        this.a(n2, n3 - 1, n4, n5);
        this.a(n2, n3 + 1, n4, n5);
        this.a(n2, n3, n4 - 1, n5);
        this.a(n2, n3, n4 + 1, n5);
    }

    public boolean setTileNoUpdate(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 >= this.width || n3 >= this.depth || n4 >= this.height) {
            return false;
        }
        if (n5 == this.blocks[(n3 * this.height + n4) * this.width + n2]) {
            return false;
        }
        this.blocks[(n3 * this.height + n4) * this.width + n2] = (byte)n5;
        return true;
    }

    private void a(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 >= this.width || n3 >= this.depth || n4 >= this.height) {
            return;
        }
        com.mojang.minecraft.level.tile.a a2 = com.mojang.minecraft.level.tile.a.b[this.blocks[(n3 * this.height + n4) * this.width + n2]];
        if (a2 != null) {
            a2.a(this, n2, n3, n4, n5);
        }
    }

    public boolean isLit(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 >= this.width || n3 >= this.depth || n4 >= this.height) {
            return true;
        }
        return n3 >= this.b[n2 + n4 * this.width];
    }

    public int getTile(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 >= this.width || n3 >= this.depth || n4 >= this.height) {
            return 0;
        }
        return this.blocks[(n3 * this.height + n4) * this.width + n2] & 0xFF;
    }

    public boolean isSolidTile(int n2, int n3, int n4) {
        if ((this = com.mojang.minecraft.level.tile.a.b[((Level)this).getTile(n2, n3, n4)]) == null) {
            return false;
        }
        return ((com.mojang.minecraft.level.tile.a)this).c();
    }

    public void tickEntities() {
        this.blockMap.tickAll();
    }

    public void tick() {
        int n2;
        int n3;
        int n4;
        ++this.tickCount;
        int n5 = 1;
        int n6 = 1;
        while (1 << n5 < this.width) {
            ++n5;
        }
        while (1 << n6 < this.height) {
            ++n6;
        }
        int n7 = this.height - 1;
        int n8 = this.width - 1;
        int n9 = this.depth - 1;
        if (this.tickCount % 5 == 0) {
            n4 = this.d.size();
            for (n3 = 0; n3 < n4; ++n3) {
                b b2 = (b)this.d.remove(0);
                if (b2.e > 0) {
                    --b2.e;
                    this.d.add(b2);
                    continue;
                }
                if (!this.a(b2.a, b2.b, b2.c) || (n2 = this.blocks[(b2.b * this.height + b2.c) * this.width + b2.a]) != b2.d || n2 <= 0) continue;
                com.mojang.minecraft.level.tile.a.b[n2].a(this, b2.a, b2.b, b2.c, this.random);
            }
        }
        this.unprocessed += this.width * this.height * this.depth;
        n4 = this.unprocessed / 200;
        this.unprocessed -= n4 * 200;
        for (n3 = 0; n3 < n4; ++n3) {
            this.c = this.c * 3 + 1013904223;
            int n10 = this.c >> 2;
            int n11 = n10 >> n5 & n7;
            n2 = n10 & n8;
            byte by = this.blocks[((n10 = n10 >> n5 + n6 & n9) * this.height + n11) * this.width + n2];
            if (!com.mojang.minecraft.level.tile.a.c[by]) continue;
            com.mojang.minecraft.level.tile.a.b[by].a(this, n2, n10, n11, this.random);
        }
    }

    public int countInstanceOf(Class clazz) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.blockMap.all.size(); ++i2) {
            Entity entity = (Entity)this.blockMap.all.get(i2);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++n2;
        }
        return n2;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height;
    }

    public float getGroundLevel() {
        return this.getWaterLevel() - 2.0f;
    }

    public float getWaterLevel() {
        return this.waterLevel;
    }

    public boolean containsAnyLiquid(AABB aABB) {
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n3 > this.width) {
            n3 = this.width;
        }
        if (n5 > this.depth) {
            n5 = this.depth;
        }
        if (n7 > this.height) {
            n7 = this.height;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            for (n2 = n4; n2 < n5; ++n2) {
                for (int i3 = n6; i3 < n7; ++i3) {
                    com.mojang.minecraft.level.tile.a a2 = com.mojang.minecraft.level.tile.a.b[this.getTile(i2, n2, i3)];
                    if (a2 == null || a2.d() == com.mojang.minecraft.level.b.a.a) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsLiquid(AABB aABB, a a2) {
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n3 > this.width) {
            n3 = this.width;
        }
        if (n5 > this.depth) {
            n5 = this.depth;
        }
        if (n7 > this.height) {
            n7 = this.height;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            for (n2 = n4; n2 < n5; ++n2) {
                for (int i3 = n6; i3 < n7; ++i3) {
                    com.mojang.minecraft.level.tile.a a3 = com.mojang.minecraft.level.tile.a.b[this.getTile(i2, n2, i3)];
                    if (a3 == null || a3.d() != a2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addToTickNextTick(int n2, int n3, int n4, int n5) {
        if (this.networkMode) {
            return;
        }
        b b2 = new b(n2, n3, n4, n5);
        if (n5 > 0) {
            n4 = com.mojang.minecraft.level.tile.a.b[n5].e();
            b b3 = b2;
            b2.e = n4;
        }
        this.d.add(b2);
    }

    public boolean isFree(AABB aABB) {
        return this.blockMap.getEntities(null, aABB).size() == 0;
    }

    public List findEntities(Entity entity, AABB aABB) {
        return this.blockMap.getEntities(entity, aABB);
    }

    public boolean isSolid(float f2, float f3, float f4, float f5) {
        if (this.a(f2 - f5, f3 - f5, f4 - f5)) {
            return true;
        }
        if (this.a(f2 - f5, f3 - f5, f4 + f5)) {
            return true;
        }
        if (this.a(f2 - f5, f3 + f5, f4 - f5)) {
            return true;
        }
        if (this.a(f2 - f5, f3 + f5, f4 + f5)) {
            return true;
        }
        if (this.a(f2 + f5, f3 - f5, f4 - f5)) {
            return true;
        }
        if (this.a(f2 + f5, f3 - f5, f4 + f5)) {
            return true;
        }
        if (this.a(f2 + f5, f3 + f5, f4 - f5)) {
            return true;
        }
        return this.a(f2 + f5, f3 + f5, f4 + f5);
    }

    private boolean a(float f2, float f3, float f4) {
        int n2 = this.getTile((int)f2, (int)f3, (int)f4);
        return n2 > 0 && com.mojang.minecraft.level.tile.a.b[n2].c();
    }

    public int getHighestTile(int n2, int n3) {
        int n4;
        for (n4 = this.depth; (this.getTile(n2, n4 - 1, n3) == 0 || com.mojang.minecraft.level.tile.a.b[this.getTile(n2, n4 - 1, n3)].d() != com.mojang.minecraft.level.b.a.a) && n4 > 0; --n4) {
        }
        return n4;
    }

    public void setSpawnPos(int n2, int n3, int n4, float f2) {
        this.xSpawn = n2;
        this.ySpawn = n3;
        this.zSpawn = n4;
        this.rotSpawn = f2;
    }

    public float getBrightness(int n2, int n3, int n4) {
        if (this.isLit(n2, n3, n4)) {
            return 1.0f;
        }
        return 0.6f;
    }

    public float getCaveness(float f2, float f3, float f4, float f5) {
        int n2 = (int)f2;
        int n3 = (int)f3;
        int n4 = (int)f4;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int i2 = n2 - 6; i2 <= n2 + 6; ++i2) {
            for (int i3 = n4 - 6; i3 <= n4 + 6; ++i3) {
                float f8;
                if (!this.a(i2, n3, i3) || this.isSolidTile(i2, n3, i3)) continue;
                float f9 = (float)i2 + 0.5f - f2;
                float f10 = (float)i3 + 0.5f - f4;
                for (f8 = (float)(Math.atan2(f10, f9) - (double)(f5 * (float)Math.PI / 180.0f) + 1.5707963705062866); f8 < (float)(-Math.PI); f8 += (float)Math.PI * 2) {
                }
                while (f8 >= (float)Math.PI) {
                    f8 -= (float)Math.PI * 2;
                }
                if (f8 < 0.0f) {
                    f8 = -f8;
                }
                f9 = a.a.c(f9 * f9 + 4.0f + f10 * f10);
                f9 = 1.0f / f9;
                if (f8 > 1.0f) {
                    f9 = 0.0f;
                }
                if (f9 < 0.0f) {
                    f9 = 0.0f;
                }
                f7 += f9;
                if (!this.isLit(i2, n3, i3)) continue;
                f6 += f9;
            }
        }
        if (f7 == 0.0f) {
            return 0.0f;
        }
        return f6 / f7;
    }

    public float getCaveness(Entity entity) {
        float f2;
        float f3 = a.a.b(-entity.yRot * ((float)Math.PI / 180) + (float)Math.PI);
        float f4 = a.a.a(-entity.yRot * ((float)Math.PI / 180) + (float)Math.PI);
        float f5 = a.a.b(-entity.xRot * ((float)Math.PI / 180));
        float f6 = a.a.a(-entity.xRot * ((float)Math.PI / 180));
        float f7 = entity.x;
        float f8 = entity.y;
        float f9 = entity.z;
        float f10 = 1.6f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        for (int i2 = 0; i2 <= 200; ++i2) {
            float f13 = ((float)i2 / (float)200 - 0.5f) * 2.0f;
            for (int i3 = 0; i3 <= 200; ++i3) {
                float f14;
                float f15;
                float f16;
                float f17 = ((float)i3 / (float)200 - 0.5f) * f10;
                float f18 = f13;
                float f19 = f5 * f17 + f6;
                f17 = f5 - f6 * f17;
                float f20 = f3 * f18 + f4 * f17;
                f17 = f3 * f17 - f4 * f18;
                for (int i4 = 0; i4 < 10 && !this.a(f16 = f7 + f20 * (float)i4 * 0.8f, f15 = f8 + f19 * (float)i4 * 0.8f, f14 = f9 + f17 * (float)i4 * 0.8f); ++i4) {
                    f11 += 1.0f;
                    if (!this.isLit((int)f16, (int)f15, (int)f14)) continue;
                    f12 += 1.0f;
                }
            }
        }
        if (f11 == 0.0f) {
            return 0.0f;
        }
        float f21 = f12 / f11;
        f21 /= 0.1f;
        if (f2 > 1.0f) {
            f21 = 1.0f;
        }
        f21 = 1.0f - f21;
        return 1.0f - f21 * f21 * f21;
    }

    public byte[] copyBlocks() {
        return Arrays.copyOf(this.blocks, this.blocks.length);
    }

    public a getLiquid(int n2, int n3, int n4) {
        int n5 = this.getTile(n2, n3, n4);
        if (n5 == 0) {
            return com.mojang.minecraft.level.b.a.a;
        }
        return com.mojang.minecraft.level.tile.a.b[n5].d();
    }

    public boolean isWater(int n2, int n3, int n4) {
        int n5 = this.getTile(n2, n3, n4);
        return n5 > 0 && com.mojang.minecraft.level.tile.a.b[n5].d() == com.mojang.minecraft.level.b.a.b;
    }

    public void setNetworkMode(boolean bl) {
        this.networkMode = bl;
    }

    public com.mojang.minecraft.b clip(com.mojang.minecraft.b.a a2, com.mojang.minecraft.b.a a3) {
        if (Float.isNaN(a2.a) || Float.isNaN(a2.b) || Float.isNaN(a2.c)) {
            return null;
        }
        if (Float.isNaN(a3.a) || Float.isNaN(a3.b) || Float.isNaN(a3.c)) {
            return null;
        }
        int n2 = (int)Math.floor(a3.a);
        int n3 = (int)Math.floor(a3.b);
        int n4 = (int)Math.floor(a3.c);
        int n5 = (int)Math.floor(a2.a);
        int n6 = (int)Math.floor(a2.b);
        int n7 = (int)Math.floor(a2.c);
        int n8 = 20;
        while (n8-- >= 0) {
            if (Float.isNaN(a2.a) || Float.isNaN(a2.b) || Float.isNaN(a2.c)) {
                return null;
            }
            if (n5 == n2 && n6 == n3 && n7 == n4) {
                return null;
            }
            float f2 = 999.0f;
            float f3 = 999.0f;
            float f4 = 999.0f;
            if (n2 > n5) {
                f2 = (float)n5 + 1.0f;
            }
            if (n2 < n5) {
                f2 = n5;
            }
            if (n3 > n6) {
                f3 = (float)n6 + 1.0f;
            }
            if (n3 < n6) {
                f3 = n6;
            }
            if (n4 > n7) {
                f4 = (float)n7 + 1.0f;
            }
            if (n4 < n7) {
                f4 = n7;
            }
            float f5 = 999.0f;
            float f6 = 999.0f;
            float f7 = 999.0f;
            float f8 = a3.a - a2.a;
            float f9 = a3.b - a2.b;
            float f10 = a3.c - a2.c;
            if (f2 != 999.0f) {
                f5 = (f2 - a2.a) / f8;
            }
            if (f3 != 999.0f) {
                f6 = (f3 - a2.b) / f9;
            }
            if (f4 != 999.0f) {
                f7 = (f4 - a2.c) / f10;
            }
            int n9 = 0;
            if (f5 < f6 && f5 < f7) {
                n9 = n2 > n5 ? 4 : 5;
                a2.a = f2;
                a2.b += f9 * f5;
                a2.c += f10 * f5;
            } else if (f6 < f7) {
                n9 = n3 > n6 ? 0 : 1;
                a2.a += f8 * f6;
                a2.b = f3;
                a2.c += f10 * f6;
            } else {
                n9 = n4 > n7 ? 2 : 3;
                a2.a += f8 * f7;
                a2.b += f9 * f7;
                a2.c = f4;
            }
            Object object = new com.mojang.minecraft.b.a(a2.a, a2.b, a2.c);
            new com.mojang.minecraft.b.a(a2.a, a2.b, a2.c).a = (float)Math.floor(a2.a);
            n5 = (int)new com.mojang.minecraft.b.a(a2.a, a2.b, a2.c).a;
            if (n9 == 5) {
                --n5;
                ((com.mojang.minecraft.b.a)object).a += 1.0f;
            }
            ((com.mojang.minecraft.b.a)object).b = (float)Math.floor(a2.b);
            n6 = (int)((com.mojang.minecraft.b.a)object).b;
            if (n9 == 1) {
                --n6;
                ((com.mojang.minecraft.b.a)object).b += 1.0f;
            }
            ((com.mojang.minecraft.b.a)object).c = (float)Math.floor(a2.c);
            n7 = (int)((com.mojang.minecraft.b.a)object).c;
            if (n9 == 3) {
                --n7;
                ((com.mojang.minecraft.b.a)object).c += 1.0f;
            }
            int n10 = this.getTile(n5, n6, n7);
            com.mojang.minecraft.level.tile.a a4 = com.mojang.minecraft.level.tile.a.b[n10];
            if (n10 <= 0 || a4.d() != com.mojang.minecraft.level.b.a.a) continue;
            if (a4.a()) {
                return new com.mojang.minecraft.b(n5, n6, n7, n9, (com.mojang.minecraft.b.a)object);
            }
            object = a4.a(n5, n6, n7, a2, a3);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void playSound(String string, Entity entity, float f2, float f3) {
    }

    public void playSound(String string, float f2, float f3, float f4, float f5, float f6) {
    }

    public boolean maybeGrowTree(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.random.nextInt(3) + 4;
        int n11 = 1;
        for (n9 = n3; n9 <= n3 + 1 + n10; ++n9) {
            n8 = 1;
            if (n9 == n3) {
                n8 = 0;
            }
            if (n9 >= n3 + 1 + n10 - 2) {
                n8 = 2;
            }
            for (n7 = n2 - n8; n7 <= n2 + n8 && n11 != 0; ++n7) {
                for (n6 = n4 - n8; n6 <= n4 + n8 && n11 != 0; ++n6) {
                    if (n7 >= 0 && n9 >= 0 && n6 >= 0 && n7 < this.width && n9 < this.depth && n6 < this.height) {
                        n5 = this.blocks[(n9 * this.height + n6) * this.width + n7] & 0xFF;
                        if (n5 == 0) continue;
                        n11 = 0;
                        continue;
                    }
                    n11 = 0;
                }
            }
        }
        if (n11 == 0) {
            return false;
        }
        n9 = this.blocks[((n3 - 1) * this.height + n4) * this.width + n2] & 0xFF;
        if (n9 != com.mojang.minecraft.level.tile.a.f.ab || n3 >= this.depth - n10 - 1) {
            return false;
        }
        this.setTile(n2, n3 - 1, n4, com.mojang.minecraft.level.tile.a.g.ab);
        for (n8 = n3 - 3 + n10; n8 <= n3 + n10; ++n8) {
            n7 = n8 - (n3 + n10);
            n6 = 1 - n7 / 2;
            for (n5 = n2 - n6; n5 <= n2 + n6; ++n5) {
                n11 = n5 - n2;
                for (n9 = n4 - n6; n9 <= n4 + n6; ++n9) {
                    int n12 = n9 - n4;
                    if (Math.abs(n11) == n6 && Math.abs(n12) == n6 && (this.random.nextInt(2) == 0 || n7 == 0)) continue;
                    this.setTile(n5, n8, n9, com.mojang.minecraft.level.tile.a.v.ab);
                }
            }
        }
        for (n8 = 0; n8 < n10; ++n8) {
            this.setTile(n2, n3 + n8, n4, com.mojang.minecraft.level.tile.a.u.ab);
        }
        return true;
    }

    public Entity getPlayer() {
        return this.player;
    }

    public void addEntity(Entity entity) {
        this.blockMap.insert(entity);
        entity.setLevel(this);
    }

    public void removeEntity(Entity entity) {
        this.blockMap.remove(entity);
    }

    public void explode(Entity entity, float f2, float f3, float f4, float f5) {
        float f6;
        float f7;
        int n2;
        int n3 = (int)(f2 - f5 - 1.0f);
        int n4 = (int)(f2 + f5 + 1.0f);
        int n5 = (int)(f3 - f5 - 1.0f);
        int n6 = (int)(f3 + f5 + 1.0f);
        int n7 = (int)(f4 - f5 - 1.0f);
        int n8 = (int)(f4 + f5 + 1.0f);
        for (int i2 = n3; i2 < n4; ++i2) {
            for (n2 = n6 - 1; n2 >= n5; --n2) {
                for (int i3 = n7; i3 < n8; ++i3) {
                    int n9;
                    f7 = (float)i2 + 0.5f - f2;
                    f6 = (float)n2 + 0.5f - f3;
                    float f8 = (float)i3 + 0.5f - f4;
                    if (i2 < 0 || n2 < 0 || i3 < 0 || i2 >= this.width || n2 >= this.depth || i3 >= this.height || !(f7 * f7 + f6 * f6 + f8 * f8 < f5 * f5) || (n9 = this.getTile(i2, n2, i3)) <= 0 || !com.mojang.minecraft.level.tile.a.b[n9].g()) continue;
                    com.mojang.minecraft.level.tile.a.b[n9].a(0.3f);
                    this.setTile(i2, n2, i3, 0);
                }
            }
        }
        List list = this.blockMap.getEntities(entity, n3, n5, n7, n4, n6, n8);
        for (n2 = 0; n2 < list.size(); ++n2) {
            float f9;
            Entity entity2 = (Entity)list.get(n2);
            f7 = entity2.distanceTo(f2, f3, f4) / f5;
            if (!(f9 <= 1.0f)) continue;
            f6 = 1.0f - f7;
            entity2.hurt(entity, (int)(f6 * 15.0f + 1.0f));
        }
    }

    public Entity findSubclassOf(Class clazz) {
        for (int i2 = 0; i2 < this.blockMap.all.size(); ++i2) {
            Entity entity = (Entity)this.blockMap.all.get(i2);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return entity;
        }
        return null;
    }

    public void removeAllNonCreativeModeEntities() {
        this.blockMap.removeAllNonCreativeModeEntities();
    }
}

