/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.Chunk;
import net.minecraft.server.CompressedStreamTools;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NextTickListEntry;
import net.minecraft.server.NibbleArray;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;
import net.minecraft.server.WorldData;

public class ChunkLoader
implements IChunkLoader {
    private File a;
    private boolean b;

    public ChunkLoader(File file, boolean bl) {
        this.a = file;
        this.b = bl;
    }

    private File a(int n, int n2) {
        String string = "c." + Integer.toString(n, 36) + "." + Integer.toString(n2, 36) + ".dat";
        String string2 = Integer.toString(n & 0x3F, 36);
        String string3 = Integer.toString(n2 & 0x3F, 36);
        File file = new File(this.a, string2);
        if (!file.exists()) {
            if (this.b) {
                file.mkdir();
            } else {
                return null;
            }
        }
        if (!(file = new File(file, string3)).exists()) {
            if (this.b) {
                file.mkdir();
            } else {
                return null;
            }
        }
        if (!(file = new File(file, string)).exists() && !this.b) {
            return null;
        }
        return file;
    }

    public Chunk a(World world, int n, int n2) {
        File file = this.a(n, n2);
        if (file != null && file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                NBTTagCompound nBTTagCompound = CompressedStreamTools.a(fileInputStream);
                if (!nBTTagCompound.hasKey("Level")) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is missing level data, skipping");
                    return null;
                }
                if (!nBTTagCompound.l("Level").hasKey("Blocks")) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is missing block data, skipping");
                    return null;
                }
                Chunk chunk = ChunkLoader.a(world, nBTTagCompound.l("Level"));
                if (!chunk.a(n, n2)) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is in the wrong location; relocating. (Expected " + n + ", " + n2 + ", got " + chunk.x + ", " + chunk.z + ")");
                    nBTTagCompound.a("xPos", n);
                    nBTTagCompound.a("zPos", n2);
                    chunk = ChunkLoader.a(world, nBTTagCompound.l("Level"));
                }
                chunk.h();
                return chunk;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void a(World world, Chunk chunk) {
        Object object;
        world.l();
        File file = this.a(chunk.x, chunk.z);
        if (file.exists()) {
            object = world.r();
            ((WorldData)object).b(((WorldData)object).g() - file.length());
        }
        try {
            object = new File(this.a, "tmp_chunk.dat");
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound.a("Level", (NBTBase)nBTTagCompound2);
            ChunkLoader.a(chunk, world, nBTTagCompound2);
            CompressedStreamTools.a(nBTTagCompound, fileOutputStream);
            fileOutputStream.close();
            if (file.exists()) {
                file.delete();
            }
            ((File)object).renameTo(file);
            WorldData worldData = world.r();
            worldData.b(worldData.g() + file.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void a(Chunk chunk, World world, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2;
        world.l();
        nBTTagCompound.a("xPos", chunk.x);
        nBTTagCompound.a("zPos", chunk.z);
        nBTTagCompound.setLong("LastUpdate", world.getTime());
        nBTTagCompound.a("Blocks", chunk.b);
        nBTTagCompound.a("Data", chunk.g.a);
        nBTTagCompound.a("SkyLight", chunk.h.a);
        nBTTagCompound.a("BlockLight", chunk.i.a);
        nBTTagCompound.a("HeightMap", chunk.heightMap);
        nBTTagCompound.a("TerrainPopulated", chunk.done);
        chunk.s = false;
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < chunk.entitySlices.length; ++i) {
            for (Object object : chunk.entitySlices[i]) {
                chunk.s = true;
                nBTTagCompound2 = new NBTTagCompound();
                if (!((Entity)object).c(nBTTagCompound2)) continue;
                nBTTagList.a(nBTTagCompound2);
            }
        }
        nBTTagCompound.a("Entities", nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (Object object : chunk.tileEntities.values()) {
            nBTTagCompound2 = new NBTTagCompound();
            ((TileEntity)object).b(nBTTagCompound2);
            nBTTagList2.a(nBTTagCompound2);
        }
        nBTTagCompound.a("TileEntities", nBTTagList2);
        List list = world.a(chunk, false);
        if (list != null) {
            long l = world.getTime();
            NBTTagList nBTTagList3 = new NBTTagList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                nBTTagCompound3.a("i", nextTickListEntry.d);
                nBTTagCompound3.a("x", nextTickListEntry.a);
                nBTTagCompound3.a("y", nextTickListEntry.b);
                nBTTagCompound3.a("z", nextTickListEntry.c);
                nBTTagCompound3.a("t", (int)(nextTickListEntry.e - l));
                nBTTagList3.a(nBTTagCompound3);
            }
            nBTTagCompound.a("TileTicks", nBTTagList3);
        }
    }

    public static Chunk a(World world, NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        Object object;
        NBTTagList nBTTagList2;
        Object object2;
        NBTTagList nBTTagList3;
        int n = nBTTagCompound.f("xPos");
        int n2 = nBTTagCompound.f("zPos");
        Chunk chunk = new Chunk(world, n, n2);
        chunk.b = nBTTagCompound.k("Blocks");
        chunk.g = new NibbleArray(nBTTagCompound.k("Data"), world.heightBits);
        chunk.h = new NibbleArray(nBTTagCompound.k("SkyLight"), world.heightBits);
        chunk.i = new NibbleArray(nBTTagCompound.k("BlockLight"), world.heightBits);
        chunk.heightMap = nBTTagCompound.k("HeightMap");
        chunk.done = nBTTagCompound.n("TerrainPopulated");
        if (!chunk.g.a()) {
            chunk.g = new NibbleArray(chunk.b.length, world.heightBits);
        }
        if (chunk.heightMap == null || !chunk.h.a()) {
            chunk.heightMap = new byte[256];
            chunk.h = new NibbleArray(chunk.b.length, world.heightBits);
            chunk.initLighting();
        }
        if (!chunk.i.a()) {
            chunk.i = new NibbleArray(chunk.b.length, world.heightBits);
            chunk.a();
        }
        if ((nBTTagList3 = nBTTagCompound.m("Entities")) != null) {
            for (int i = 0; i < nBTTagList3.d(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList3.a(i);
                object2 = EntityTypes.a(nBTTagCompound2, world);
                chunk.s = true;
                if (object2 == null) continue;
                chunk.a((Entity)object2);
            }
        }
        if ((nBTTagList2 = nBTTagCompound.m("TileEntities")) != null) {
            for (int i = 0; i < nBTTagList2.d(); ++i) {
                object2 = (NBTTagCompound)nBTTagList2.a(i);
                object = TileEntity.c((NBTTagCompound)object2);
                if (object == null) continue;
                chunk.a((TileEntity)object);
            }
        }
        if (nBTTagCompound.hasKey("TileTicks") && (nBTTagList = nBTTagCompound.m("TileTicks")) != null) {
            for (int i = 0; i < nBTTagList.d(); ++i) {
                object = (NBTTagCompound)nBTTagList.a(i);
                world.d(((NBTTagCompound)object).f("x"), ((NBTTagCompound)object).f("y"), ((NBTTagCompound)object).f("z"), ((NBTTagCompound)object).f("i"), ((NBTTagCompound)object).f("t"));
            }
        }
        return chunk;
    }

    public void a() {
    }

    public void b() {
    }

    public void b(World world, Chunk chunk) {
    }
}

