/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityCreeper
extends EntityMonster {
    int fuseTicks;
    int b;

    public EntityCreeper(World world) {
        super(world);
        this.texture = "/mob/creeper.png";
    }

    public int getMaxHealth() {
        return 20;
    }

    protected void b() {
        super.b();
        this.datawatcher.a(16, (byte)-1);
        this.datawatcher.a(17, (byte)0);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.datawatcher.getByte(17) == 1) {
            nBTTagCompound.a("powered", true);
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.datawatcher.watch(17, (byte)(nBTTagCompound.n("powered") ? 1 : 0));
    }

    protected void b(Entity entity, float f) {
        if (this.world.isStatic) {
            return;
        }
        if (this.fuseTicks > 0) {
            this.b(-1);
            --this.fuseTicks;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
        }
    }

    public void w_() {
        this.b = this.fuseTicks;
        if (this.world.isStatic) {
            int n = this.A();
            if (n > 0 && this.fuseTicks == 0) {
                this.world.makeSound(this, "random.fuse", 1.0f, 0.5f);
            }
            this.fuseTicks += n;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
            if (this.fuseTicks >= 30) {
                this.fuseTicks = 30;
            }
        }
        super.w_();
        if (this.target == null && this.fuseTicks > 0) {
            this.b(-1);
            --this.fuseTicks;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
        }
    }

    protected String m() {
        return "mob.creeper";
    }

    protected String n() {
        return "mob.creeperdeath";
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (damageSource.getEntity() instanceof EntitySkeleton) {
            this.b(Item.RECORD_1.id + this.random.nextInt(2), 1);
        }
    }

    protected void a(Entity entity, float f) {
        if (this.world.isStatic) {
            return;
        }
        int n = this.A();
        if (n <= 0 && f < 3.0f || n > 0 && f < 7.0f) {
            if (this.fuseTicks == 0) {
                this.world.makeSound(this, "random.fuse", 1.0f, 0.5f);
            }
            this.b(1);
            ++this.fuseTicks;
            if (this.fuseTicks >= 30) {
                if (this.isPowered()) {
                    this.world.a((Entity)this, this.locX, this.locY, this.locZ, 6.0f);
                } else {
                    this.world.a((Entity)this, this.locX, this.locY, this.locZ, 3.0f);
                }
                this.die();
            }
            this.e = true;
        } else {
            this.b(-1);
            --this.fuseTicks;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
        }
    }

    public boolean isPowered() {
        return this.datawatcher.getByte(17) == 1;
    }

    protected int e() {
        return Item.SULPHUR.id;
    }

    private int A() {
        return this.datawatcher.getByte(16);
    }

    private void b(int n) {
        this.datawatcher.watch(16, (byte)n);
    }

    public void a(EntityWeatherStorm entityWeatherStorm) {
        super.a(entityWeatherStorm);
        this.datawatcher.watch(17, (byte)1);
    }
}

