/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Chunk;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntitySlime
extends EntityLiving
implements IMonster {
    public float a;
    public float b;
    public float c;
    private int size = 0;

    public EntitySlime(World world) {
        super(world);
        this.texture = "/mob/slime.png";
        int n = 1 << this.random.nextInt(3);
        this.height = 0.0f;
        this.size = this.random.nextInt(20) + 10;
        this.setSize(n);
        this.az = n;
    }

    protected void b() {
        super.b();
        this.datawatcher.a(16, new Byte(1));
    }

    public void setSize(int n) {
        this.datawatcher.watch(16, new Byte((byte)n));
        this.b(0.6f * (float)n, 0.6f * (float)n);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.setHealth(this.getMaxHealth());
    }

    public int getMaxHealth() {
        int n = this.getSize();
        return n * n;
    }

    public int getSize() {
        return this.datawatcher.getByte(16);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Size", this.getSize() - 1);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSize(nBTTagCompound.f("Size") + 1);
    }

    protected String w() {
        return "slime";
    }

    protected String E() {
        return "mob.slime";
    }

    public void w_() {
        if (!this.world.isStatic && this.world.difficulty == 0 && this.getSize() > 0) {
            this.dead = true;
        }
        this.b += (this.a - this.b) * 0.5f;
        this.c = this.b;
        boolean bl = this.onGround;
        super.w_();
        if (this.onGround && !bl) {
            int n = this.getSize();
            for (int i = 0; i < n * 8; ++i) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                float f2 = this.random.nextFloat() * 0.5f + 0.5f;
                float f3 = MathHelper.sin(f) * (float)n * 0.5f * f2;
                float f4 = MathHelper.cos(f) * (float)n * 0.5f * f2;
                this.world.a(this.w(), this.locX + (double)f3, this.boundingBox.b, this.locZ + (double)f4, 0.0, 0.0, 0.0);
            }
            if (this.G()) {
                this.world.makeSound(this, this.E(), this.o(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.a = -0.5f;
        }
        this.B();
    }

    protected void m_() {
        this.ak();
        EntityHuman entityHuman = this.world.b((Entity)this, 16.0);
        if (entityHuman != null) {
            this.a(entityHuman, 10.0f, 20.0f);
        }
        if (this.onGround && this.size-- <= 0) {
            this.size = this.A();
            if (entityHuman != null) {
                this.size /= 3;
            }
            this.aW = true;
            if (this.I()) {
                this.world.makeSound(this, this.E(), this.o(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.a = 1.0f;
            this.aT = 1.0f - this.random.nextFloat() * 2.0f;
            this.aU = 1 * this.getSize();
        } else {
            this.aW = false;
            if (this.onGround) {
                this.aU = 0.0f;
                this.aT = 0.0f;
            }
        }
    }

    protected void B() {
        this.a *= 0.6f;
    }

    protected int A() {
        return this.random.nextInt(20) + 10;
    }

    protected EntitySlime y() {
        return new EntitySlime(this.world);
    }

    public void die() {
        int n = this.getSize();
        if (!this.world.isStatic && n > 1 && this.getHealth() <= 0) {
            int n2 = 2 + this.random.nextInt(3);
            for (int i = 0; i < n2; ++i) {
                float f = ((float)(i % 2) - 0.5f) * (float)n / 4.0f;
                float f2 = ((float)(i / 2) - 0.5f) * (float)n / 4.0f;
                EntitySlime entitySlime = this.y();
                entitySlime.setSize(n / 2);
                entitySlime.setPositionRotation(this.locX + (double)f, this.locY + 0.5, this.locZ + (double)f2, this.random.nextFloat() * 360.0f, 0.0f);
                this.world.addEntity(entitySlime);
            }
        }
        super.die();
    }

    public void a_(EntityHuman entityHuman) {
        if (this.C()) {
            int n = this.getSize();
            if (this.g(entityHuman) && (double)this.h(entityHuman) < 0.6 * (double)n && entityHuman.damageEntity(DamageSource.mobAttack(this), this.D())) {
                this.world.makeSound(this, "mob.slimeattack", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean C() {
        return this.getSize() > 1;
    }

    protected int D() {
        return this.getSize();
    }

    protected String m() {
        return "mob.slime";
    }

    protected String n() {
        return "mob.slime";
    }

    protected int e() {
        if (this.getSize() == 1) {
            return Item.SLIME_BALL.id;
        }
        return 0;
    }

    public boolean g() {
        Chunk chunk = this.world.getChunkAtWorldCoords(MathHelper.floor(this.locX), MathHelper.floor(this.locZ));
        if ((this.getSize() == 1 || this.world.difficulty > 0) && this.random.nextInt(10) == 0 && chunk.a(987234911L).nextInt(10) == 0 && this.locY < 40.0) {
            return super.g();
        }
        return false;
    }

    protected float o() {
        return 0.4f * (float)this.getSize();
    }

    protected int q_() {
        return 0;
    }

    protected boolean I() {
        return this.getSize() > 1;
    }

    protected boolean G() {
        return this.getSize() > 2;
    }
}

