/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityEgg;
import net.minecraft.server.EntityEnderCrystal;
import net.minecraft.server.EntityEnderDragon;
import net.minecraft.server.EntityEnderPearl;
import net.minecraft.server.EntityEnderSignal;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityFallingSand;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityList;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityPainting;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityPotion;
import net.minecraft.server.EntitySmallFireball;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.EntitySquid;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.EntityTrackerEntry;
import net.minecraft.server.IAnimal;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Packet;

public class EntityTracker {
    private Set a = new HashSet();
    private EntityList trackedEntities = new EntityList();
    private MinecraftServer c;
    private int d;
    private int e;

    public EntityTracker(MinecraftServer minecraftServer, int n) {
        this.c = minecraftServer;
        this.e = n;
        this.d = minecraftServer.serverConfigurationManager.a();
    }

    public void track(Entity entity) {
        if (entity instanceof EntityPlayer) {
            this.addEntity(entity, 512, 2);
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            for (EntityTrackerEntry entityTrackerEntry : this.a) {
                if (entityTrackerEntry.tracker == entityPlayer) continue;
                entityTrackerEntry.b(entityPlayer);
            }
        } else if (entity instanceof EntityFishingHook) {
            this.addEntity(entity, 64, 5, true);
        } else if (entity instanceof EntityArrow) {
            this.addEntity(entity, 64, 20, false);
        } else if (entity instanceof EntitySmallFireball) {
            this.addEntity(entity, 64, 10, false);
        } else if (entity instanceof EntityFireball) {
            this.addEntity(entity, 64, 10, false);
        } else if (entity instanceof EntitySnowball) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityEnderPearl) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityEnderSignal) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityEgg) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityPotion) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityItem) {
            this.addEntity(entity, 64, 20, true);
        } else if (entity instanceof EntityMinecart) {
            this.addEntity(entity, 80, 3, true);
        } else if (entity instanceof EntityBoat) {
            this.addEntity(entity, 80, 3, true);
        } else if (entity instanceof EntitySquid) {
            this.addEntity(entity, 64, 3, true);
        } else if (entity instanceof IAnimal) {
            this.addEntity(entity, 80, 3, true);
        } else if (entity instanceof EntityEnderDragon) {
            this.addEntity(entity, 160, 3, true);
        } else if (entity instanceof EntityTNTPrimed) {
            this.addEntity(entity, 160, 10, true);
        } else if (entity instanceof EntityFallingSand) {
            this.addEntity(entity, 160, 20, true);
        } else if (entity instanceof EntityPainting) {
            this.addEntity(entity, 160, Integer.MAX_VALUE, false);
        } else if (entity instanceof EntityExperienceOrb) {
            this.addEntity(entity, 160, 20, true);
        } else if (entity instanceof EntityEnderCrystal) {
            this.addEntity(entity, 256, Integer.MAX_VALUE, false);
        }
    }

    public void addEntity(Entity entity, int n, int n2) {
        this.addEntity(entity, n, n2, false);
    }

    public void addEntity(Entity entity, int n, int n2, boolean bl) {
        if (n > this.d) {
            n = this.d;
        }
        if (this.trackedEntities.b(entity.id)) {
            throw new IllegalStateException("Entity is already tracked!");
        }
        EntityTrackerEntry entityTrackerEntry = new EntityTrackerEntry(entity, n, n2, bl);
        this.a.add(entityTrackerEntry);
        this.trackedEntities.a(entity.id, entityTrackerEntry);
        entityTrackerEntry.scanPlayers(this.c.getWorldServer((int)this.e).players);
    }

    public void untrackEntity(Entity entity) {
        Object object;
        if (entity instanceof EntityPlayer) {
            object = (EntityPlayer)entity;
            for (EntityTrackerEntry entityTrackerEntry : this.a) {
                entityTrackerEntry.a((EntityPlayer)object);
            }
        }
        if ((object = (EntityTrackerEntry)this.trackedEntities.d(entity.id)) != null) {
            this.a.remove(object);
            ((EntityTrackerEntry)object).a();
        }
    }

    public void updatePlayers() {
        ArrayList<EntityPlayer> arrayList = new ArrayList<EntityPlayer>();
        for (Object object : this.a) {
            ((EntityTrackerEntry)object).track(this.c.getWorldServer((int)this.e).players);
            if (!((EntityTrackerEntry)object).m || !(((EntityTrackerEntry)object).tracker instanceof EntityPlayer)) continue;
            arrayList.add((EntityPlayer)((EntityTrackerEntry)object).tracker);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            object = (EntityPlayer)arrayList.get(i);
            for (EntityTrackerEntry entityTrackerEntry : this.a) {
                if (entityTrackerEntry.tracker == object) continue;
                entityTrackerEntry.b((EntityPlayer)object);
            }
        }
    }

    public void a(Entity entity, Packet packet) {
        EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)this.trackedEntities.a(entity.id);
        if (entityTrackerEntry != null) {
            entityTrackerEntry.a(packet);
        }
    }

    public void sendPacketToEntity(Entity entity, Packet packet) {
        EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)this.trackedEntities.a(entity.id);
        if (entityTrackerEntry != null) {
            entityTrackerEntry.b(packet);
        }
    }

    public void untrackPlayer(EntityPlayer entityPlayer) {
        for (EntityTrackerEntry entityTrackerEntry : this.a) {
            entityTrackerEntry.c(entityPlayer);
        }
    }
}

