/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ConsoleCommandHandler;
import net.minecraft.server.ConsoleLogManager;
import net.minecraft.server.ConvertProgressUpdater;
import net.minecraft.server.Convertable;
import net.minecraft.server.EntityTracker;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.IUpdatePlayerListBox;
import net.minecraft.server.NetworkListenThread;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.PropertyManager;
import net.minecraft.server.RemoteControlCommandListener;
import net.minecraft.server.RemoteControlListener;
import net.minecraft.server.RemoteStatusListener;
import net.minecraft.server.SecondaryWorldServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerConfigurationManager;
import net.minecraft.server.ServerGUI;
import net.minecraft.server.ServerNBTManager;
import net.minecraft.server.StatisticList;
import net.minecraft.server.ThreadCommandReader;
import net.minecraft.server.ThreadServerApplication;
import net.minecraft.server.ThreadSleepForever;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WorldLoaderServer;
import net.minecraft.server.WorldManager;
import net.minecraft.server.WorldServer;
import net.minecraft.server.WorldSettings;

public class MinecraftServer
implements Runnable,
ICommandListener,
IMinecraftServer {
    public static Logger log = Logger.getLogger("Minecraft");
    public static HashMap trackerList = new HashMap();
    private String s;
    private int t;
    public NetworkListenThread networkListenThread;
    public PropertyManager propertyManager;
    public WorldServer[] worldServer;
    public long[] f = new long[100];
    public long[][] g;
    public ServerConfigurationManager serverConfigurationManager;
    private ConsoleCommandHandler consoleCommandHandler;
    private boolean isRunning = true;
    public boolean isStopped = false;
    int ticks = 0;
    public String k;
    public int l;
    private List w = new ArrayList();
    private List x = Collections.synchronizedList(new ArrayList());
    public EntityTracker[] tracker = new EntityTracker[3];
    public boolean onlineMode;
    public boolean spawnAnimals;
    public boolean pvpMode;
    public boolean allowFlight;
    public String r;
    private RemoteStatusListener y;
    private RemoteControlListener z;

    public MinecraftServer() {
        new ThreadSleepForever(this);
    }

    private boolean init() {
        this.consoleCommandHandler = new ConsoleCommandHandler(this);
        ThreadCommandReader threadCommandReader = new ThreadCommandReader(this);
        threadCommandReader.setDaemon(true);
        threadCommandReader.start();
        ConsoleLogManager.init();
        log.info("Starting minecraft server version RC1");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            log.warning("**** NOT ENOUGH RAM!");
            log.warning("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        log.info("Loading properties");
        this.propertyManager = new PropertyManager(new File("server.properties"));
        this.s = this.propertyManager.getString("server-ip", "");
        this.onlineMode = this.propertyManager.getBoolean("online-mode", true);
        this.spawnAnimals = this.propertyManager.getBoolean("spawn-animals", true);
        this.pvpMode = this.propertyManager.getBoolean("pvp", true);
        this.allowFlight = this.propertyManager.getBoolean("allow-flight", false);
        this.r = this.propertyManager.getString("motd", "A Minecraft Server");
        this.r.replace('\u00a7', '$');
        InetAddress inetAddress = null;
        if (this.s.length() > 0) {
            inetAddress = InetAddress.getByName(this.s);
        }
        this.t = this.propertyManager.getInt("server-port", 25565);
        log.info("Starting Minecraft server on " + (this.s.length() == 0 ? "*" : this.s) + ":" + this.t);
        try {
            this.networkListenThread = new NetworkListenThread(this, inetAddress, this.t);
        }
        catch (IOException iOException) {
            log.warning("**** FAILED TO BIND TO PORT!");
            log.log(Level.WARNING, "The exception was: " + iOException.toString());
            log.warning("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.onlineMode) {
            log.warning("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            log.warning("The server will make no attempt to authenticate usernames. Beware.");
            log.warning("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            log.warning("To change this, set \"online-mode\" to \"true\" in the server.settings file.");
        }
        this.serverConfigurationManager = new ServerConfigurationManager(this);
        this.tracker[0] = new EntityTracker(this, 0);
        this.tracker[1] = new EntityTracker(this, -1);
        this.tracker[2] = new EntityTracker(this, 1);
        long l = System.nanoTime();
        String string = this.propertyManager.getString("level-name", "world");
        String string2 = this.propertyManager.getString("level-seed", "");
        long l2 = new Random().nextLong();
        if (string2.length() > 0) {
            try {
                long l3 = Long.parseLong(string2);
                if (l3 != 0L) {
                    l2 = l3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                l2 = string2.hashCode();
            }
        }
        log.info("Preparing level \"" + string + "\"");
        this.a(new WorldLoaderServer(new File(".")), string, l2);
        log.info("Done (" + (System.nanoTime() - l) + "ns)! For help, type \"help\" or \"?\"");
        if (this.propertyManager.getBoolean("enable-query", false)) {
            log.info("Starting GS4 status listener");
            this.y = new RemoteStatusListener(this);
            this.y.a();
        }
        if (this.propertyManager.getBoolean("enable-rcon", false)) {
            log.info("Starting remote control listener");
            this.z = new RemoteControlListener(this);
            this.z.a();
        }
        return true;
    }

    private void a(Convertable convertable, String string, long l) {
        int n;
        if (convertable.isConvertable(string)) {
            log.info("Converting map!");
            convertable.convert(string, new ConvertProgressUpdater(this));
        }
        this.worldServer = new WorldServer[3];
        this.g = new long[this.worldServer.length][100];
        int n2 = this.propertyManager.getInt("gamemode", 0);
        n2 = WorldSettings.a(n2);
        log.info("Default game type: " + n2);
        WorldSettings worldSettings = new WorldSettings(l, n2, true, false);
        ServerNBTManager serverNBTManager = new ServerNBTManager(new File("."), string, true);
        for (n = 0; n < this.worldServer.length; ++n) {
            int n3 = 0;
            if (n == 1) {
                n3 = -1;
            }
            if (n == 2) {
                n3 = 1;
            }
            this.worldServer[n] = n == 0 ? new WorldServer(this, serverNBTManager, string, n3, worldSettings) : new SecondaryWorldServer(this, serverNBTManager, string, n3, worldSettings, this.worldServer[0]);
            this.worldServer[n].addIWorldAccess(new WorldManager(this, this.worldServer[n]));
            this.worldServer[n].difficulty = this.propertyManager.getInt("difficulty", 1);
            this.worldServer[n].setSpawnFlags(this.propertyManager.getBoolean("spawn-monsters", true), this.spawnAnimals);
            this.worldServer[n].r().setGameType(n2);
            this.serverConfigurationManager.setPlayerFileData(this.worldServer);
        }
        n = 196;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            log.info("Preparing start region for level " + i);
            if (i != 0 && !this.propertyManager.getBoolean("allow-nether", true)) continue;
            WorldServer worldServer = this.worldServer[i];
            ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
            for (int j = -n; j <= n && this.isRunning; j += 16) {
                for (int k = -n; k <= n && this.isRunning; k += 16) {
                    long l3 = System.currentTimeMillis();
                    if (l3 < l2) {
                        l2 = l3;
                    }
                    if (l3 > l2 + 1000L) {
                        int n4 = (n * 2 + 1) * (n * 2 + 1);
                        int n5 = (j + n) * (n * 2 + 1) + (k + 1);
                        this.b("Preparing spawn area", n5 * 100 / n4);
                        l2 = l3;
                    }
                    worldServer.chunkProviderServer.getChunkAt(chunkCoordinates.x + j >> 4, chunkCoordinates.z + k >> 4);
                    while (worldServer.x() && this.isRunning) {
                    }
                }
            }
        }
        this.t();
    }

    private void b(String string, int n) {
        this.k = string;
        this.l = n;
        log.info(string + ": " + n + "%");
    }

    private void t() {
        this.k = null;
        this.l = 0;
    }

    private void saveChunks() {
        log.info("Saving chunks");
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            worldServer.save(true, null);
            worldServer.saveLevel();
        }
    }

    private void stop() {
        log.info("Stopping server");
        if (this.serverConfigurationManager != null) {
            this.serverConfigurationManager.savePlayers();
        }
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            if (worldServer == null) continue;
            this.saveChunks();
        }
    }

    public void safeShutdown() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (this.init()) {
                long l = System.currentTimeMillis();
                long l2 = 0L;
                while (this.isRunning) {
                    long l3 = System.currentTimeMillis();
                    long l4 = l3 - l;
                    if (l4 > 2000L) {
                        log.warning("Can't keep up! Did the system time change, or is the server overloaded?");
                        l4 = 2000L;
                    }
                    if (l4 < 0L) {
                        log.warning("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    l = l3;
                    if (this.worldServer[0].everyoneDeeplySleeping()) {
                        this.w();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.w();
                        }
                    }
                    Thread.sleep(1L);
                }
                return;
            } else {
                while (this.isRunning) {
                    this.b();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.log(Level.SEVERE, "Unexpected exception", throwable);
            while (this.isRunning) {
                this.b();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return;
        }
        finally {
            try {
                this.stop();
                this.isStopped = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private void w() {
        int n;
        long l = System.nanoTime();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : trackerList.keySet()) {
            int n2 = (Integer)trackerList.get(string);
            if (n2 > 0) {
                trackerList.put(string, n2 - 1);
                continue;
            }
            arrayList.add(string);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            trackerList.remove(arrayList.get(n));
        }
        AxisAlignedBB.a();
        Vec3D.a();
        ++this.ticks;
        for (n = 0; n < this.worldServer.length; ++n) {
            long l2 = System.nanoTime();
            if (n == 0 || this.propertyManager.getBoolean("allow-nether", true)) {
                WorldServer worldServer = this.worldServer[n];
                if (this.ticks % 20 == 0) {
                    this.serverConfigurationManager.a(new Packet4UpdateTime(worldServer.getTime()), worldServer.worldProvider.dimension);
                }
                worldServer.doTick();
                while (worldServer.x()) {
                }
                worldServer.tickEntities();
            }
            this.g[n][this.ticks % 100] = System.nanoTime() - l2;
        }
        this.networkListenThread.a();
        this.serverConfigurationManager.b();
        for (n = 0; n < this.tracker.length; ++n) {
            this.tracker[n].updatePlayers();
        }
        for (n = 0; n < this.w.size(); ++n) {
            ((IUpdatePlayerListBox)this.w.get(n)).a();
        }
        try {
            this.b();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Unexpected exception while parsing console command", exception);
        }
        this.f[this.ticks % 100] = System.nanoTime() - l;
    }

    public void issueCommand(String string, ICommandListener iCommandListener) {
        this.x.add(new ServerCommand(string, iCommandListener));
    }

    public void b() {
        while (this.x.size() > 0) {
            ServerCommand serverCommand = (ServerCommand)this.x.remove(0);
            this.consoleCommandHandler.handle(serverCommand);
        }
    }

    public void a(IUpdatePlayerListBox iUpdatePlayerListBox) {
        this.w.add(iUpdatePlayerListBox);
    }

    public static void main(String[] stringArray) {
        StatisticList.a();
        try {
            MinecraftServer minecraftServer = new MinecraftServer();
            if (!(GraphicsEnvironment.isHeadless() || stringArray.length > 0 && stringArray[0].equals("nogui"))) {
                ServerGUI.a(minecraftServer);
            }
            new ThreadServerApplication("Server thread", minecraftServer).start();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    public File a(String string) {
        return new File(string);
    }

    public void sendMessage(String string) {
        log.info(string);
    }

    public void warning(String string) {
        log.warning(string);
    }

    public String getName() {
        return "CONSOLE";
    }

    public WorldServer getWorldServer(int n) {
        if (n == -1) {
            return this.worldServer[1];
        }
        if (n == 1) {
            return this.worldServer[2];
        }
        return this.worldServer[0];
    }

    public EntityTracker getTracker(int n) {
        if (n == -1) {
            return this.tracker[1];
        }
        if (n == 1) {
            return this.tracker[2];
        }
        return this.tracker[0];
    }

    public int getProperty(String string, int n) {
        return this.propertyManager.getInt(string, n);
    }

    public String a(String string, String string2) {
        return this.propertyManager.getString(string, string2);
    }

    public void a(String string, Object object) {
        this.propertyManager.a(string, object);
    }

    public void c() {
        this.propertyManager.savePropertiesFile();
    }

    public String getPropertiesFile() {
        File file = this.propertyManager.c();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "No settings file";
    }

    public String getMotd() {
        return this.s;
    }

    public int getPort() {
        return this.t;
    }

    public String getServerAddress() {
        return this.r;
    }

    public String getVersion() {
        return "RC1";
    }

    public int getPlayerCount() {
        return this.serverConfigurationManager.j();
    }

    public int getMaxPlayers() {
        return this.serverConfigurationManager.k();
    }

    public String[] getPlayers() {
        return this.serverConfigurationManager.d();
    }

    public String getWorldName() {
        return this.propertyManager.getString("level-name", "world");
    }

    public String getPlugins() {
        return "";
    }

    public void o() {
    }

    public String d(String string) {
        RemoteControlCommandListener.a.a();
        this.consoleCommandHandler.handle(new ServerCommand(string, RemoteControlCommandListener.a));
        return RemoteControlCommandListener.a.b();
    }

    public boolean isDebugging() {
        return false;
    }

    public void severe(String string) {
        log.log(Level.SEVERE, string);
    }

    public void debug(String string) {
        if (this.isDebugging()) {
            log.log(Level.INFO, string);
        }
    }

    public String[] q() {
        return this.serverConfigurationManager.f().toArray(new String[0]);
    }

    public String[] r() {
        return this.serverConfigurationManager.e().toArray(new String[0]);
    }

    public static /* synthetic */ boolean isRunning(MinecraftServer minecraftServer) {
        return minecraftServer.isRunning;
    }
}

