/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.server.ChunkBuffer;

public class RegionFile {
    private static final byte[] a = new byte[4096];
    private final File b;
    private RandomAccessFile c;
    private final int[] d = new int[1024];
    private final int[] e = new int[1024];
    private ArrayList f;
    private int g;
    private long h = 0L;

    public RegionFile(File file) {
        this.b = file;
        this.b("REGION LOAD " + this.b);
        this.g = 0;
        try {
            int n;
            int n2;
            int n3;
            if (file.exists()) {
                this.h = file.lastModified();
            }
            this.c = new RandomAccessFile(file, "rw");
            if (this.c.length() < 4096L) {
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.c.writeInt(0);
                }
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.c.writeInt(0);
                }
                this.g += 8192;
            }
            if ((this.c.length() & 0xFFFL) != 0L) {
                n3 = 0;
                while ((long)n3 < (this.c.length() & 0xFFFL)) {
                    this.c.write(0);
                    ++n3;
                }
            }
            n3 = (int)this.c.length() / 4096;
            this.f = new ArrayList(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.f.add(true);
            }
            this.f.set(0, false);
            this.f.set(1, false);
            this.c.seek(0L);
            for (n2 = 0; n2 < 1024; ++n2) {
                this.d[n2] = n = this.c.readInt();
                if (n == 0 || (n >> 8) + (n & 0xFF) > this.f.size()) continue;
                for (int i = 0; i < (n & 0xFF); ++i) {
                    this.f.set((n >> 8) + i, false);
                }
            }
            for (n2 = 0; n2 < 1024; ++n2) {
                this.e[n2] = n = this.c.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void a(String string) {
    }

    private void b(String string) {
        this.a(string + "\n");
    }

    private void a(String string, int n, int n2, String string2) {
        this.a("REGION " + string + " " + this.b.getName() + "[" + n + "," + n2 + "] = " + string2);
    }

    private void a(String string, int n, int n2, int n3, String string2) {
        this.a("REGION " + string + " " + this.b.getName() + "[" + n + "," + n2 + "] " + n3 + "B = " + string2);
    }

    private void b(String string, int n, int n2, String string2) {
        this.a(string, n, n2, string2 + "\n");
    }

    public synchronized DataInputStream a(int n, int n2) {
        if (this.d(n, n2)) {
            this.b("READ", n, n2, "out of bounds");
            return null;
        }
        try {
            int n3 = this.e(n, n2);
            if (n3 == 0) {
                return null;
            }
            int n4 = n3 >> 8;
            int n5 = n3 & 0xFF;
            if (n4 + n5 > this.f.size()) {
                this.b("READ", n, n2, "invalid sector");
                return null;
            }
            this.c.seek(n4 * 4096);
            int n6 = this.c.readInt();
            if (n6 > 4096 * n5) {
                this.b("READ", n, n2, "invalid length: " + n6 + " > 4096 * " + n5);
                return null;
            }
            byte by = this.c.readByte();
            if (by == 1) {
                byte[] byArray = new byte[n6 - 1];
                this.c.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
                return dataInputStream;
            }
            if (by == 2) {
                byte[] byArray = new byte[n6 - 1];
                this.c.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray))));
                return dataInputStream;
            }
            this.b("READ", n, n2, "unknown version " + by);
            return null;
        }
        catch (IOException iOException) {
            this.b("READ", n, n2, "exception");
            return null;
        }
    }

    public DataOutputStream b(int n, int n2) {
        if (this.d(n, n2)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new ChunkBuffer(this, n, n2)));
    }

    protected synchronized void a(int n, int n2, byte[] byArray, int n3) {
        try {
            int n4 = this.e(n, n2);
            int n5 = n4 >> 8;
            int n6 = n4 & 0xFF;
            int n7 = (n3 + 5) / 4096 + 1;
            if (n7 >= 256) {
                return;
            }
            if (n5 != 0 && n6 == n7) {
                this.a("SAVE", n, n2, n3, "rewrite");
                this.a(n5, byArray, n3);
            } else {
                int n8;
                int n9;
                for (n9 = 0; n9 < n6; ++n9) {
                    this.f.set(n5 + n9, true);
                }
                n9 = this.f.indexOf(true);
                int n10 = 0;
                if (n9 != -1) {
                    for (n8 = n9; n8 < this.f.size(); ++n8) {
                        if (n10 != 0) {
                            n10 = ((Boolean)this.f.get(n8)).booleanValue() ? ++n10 : 0;
                        } else if (((Boolean)this.f.get(n8)).booleanValue()) {
                            n9 = n8;
                            n10 = 1;
                        }
                        if (n10 >= n7) break;
                    }
                }
                if (n10 >= n7) {
                    this.a("SAVE", n, n2, n3, "reuse");
                    n5 = n9;
                    this.a(n, n2, n5 << 8 | n7);
                    for (n8 = 0; n8 < n7; ++n8) {
                        this.f.set(n5 + n8, false);
                    }
                    this.a(n5, byArray, n3);
                } else {
                    this.a("SAVE", n, n2, n3, "grow");
                    this.c.seek(this.c.length());
                    n5 = this.f.size();
                    for (n8 = 0; n8 < n7; ++n8) {
                        this.c.write(a);
                        this.f.add(false);
                    }
                    this.g += 4096 * n7;
                    this.a(n5, byArray, n3);
                    this.a(n, n2, n5 << 8 | n7);
                }
            }
            this.b(n, n2, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void a(int n, byte[] byArray, int n2) {
        this.b(" " + n);
        this.c.seek(n * 4096);
        this.c.writeInt(n2 + 1);
        this.c.writeByte(2);
        this.c.write(byArray, 0, n2);
    }

    private boolean d(int n, int n2) {
        return n < 0 || n >= 32 || n2 < 0 || n2 >= 32;
    }

    private int e(int n, int n2) {
        return this.d[n + n2 * 32];
    }

    public boolean c(int n, int n2) {
        return this.e(n, n2) != 0;
    }

    private void a(int n, int n2, int n3) {
        this.d[n + n2 * 32] = n3;
        this.c.seek((n + n2 * 32) * 4);
        this.c.writeInt(n3);
    }

    private void b(int n, int n2, int n3) {
        this.e[n + n2 * 32] = n3;
        this.c.seek(4096 + (n + n2 * 32) * 4);
        this.c.writeInt(n3);
    }

    public void a() {
        this.c.close();
    }
}

