/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NetLoginHandler;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet201PlayerInfo;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PlayerFileData;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.PortalTravelAgent;
import net.minecraft.server.TileEntity;
import net.minecraft.server.WorldServer;

public class ServerConfigurationManager {
    public static Logger a = Logger.getLogger("Minecraft");
    public List players = new ArrayList();
    private MinecraftServer server;
    private PlayerManager[] d;
    private int maxPlayers;
    private Set banByName = new HashSet();
    private Set banByIP = new HashSet();
    private Set operators = new HashSet();
    private Set whitelist = new HashSet();
    private File j;
    private File k;
    private File l;
    private File m;
    private PlayerFileData playerFileData;
    private boolean hasWhitelist;
    private int p = 0;

    public ServerConfigurationManager(MinecraftServer minecraftServer) {
        this.d = new PlayerManager[3];
        this.server = minecraftServer;
        this.j = minecraftServer.a("banned-players.txt");
        this.k = minecraftServer.a("banned-ips.txt");
        this.l = minecraftServer.a("ops.txt");
        this.m = minecraftServer.a("white-list.txt");
        int n = minecraftServer.propertyManager.getInt("view-distance", 10);
        this.d[0] = new PlayerManager(minecraftServer, 0, n);
        this.d[1] = new PlayerManager(minecraftServer, -1, n);
        this.d[2] = new PlayerManager(minecraftServer, 1, n);
        this.maxPlayers = minecraftServer.propertyManager.getInt("max-players", 20);
        this.hasWhitelist = minecraftServer.propertyManager.getBoolean("white-list", false);
        this.l();
        this.n();
        this.p();
        this.r();
        this.m();
        this.o();
        this.q();
        this.s();
    }

    public void setPlayerFileData(WorldServer[] worldServerArray) {
        this.playerFileData = worldServerArray[0].q().d();
    }

    public void a(EntityPlayer entityPlayer) {
        this.d[0].removePlayer(entityPlayer);
        this.d[1].removePlayer(entityPlayer);
        this.d[2].removePlayer(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).addPlayer(entityPlayer);
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer.locX >> 4, (int)entityPlayer.locZ >> 4);
    }

    public int a() {
        return this.d[0].getFurthestViewableBlock();
    }

    private PlayerManager getPlayerManager(int n) {
        if (n == -1) {
            return this.d[1];
        }
        if (n == 0) {
            return this.d[0];
        }
        if (n == 1) {
            return this.d[2];
        }
        return null;
    }

    public void b(EntityPlayer entityPlayer) {
        this.playerFileData.b(entityPlayer);
    }

    public void c(EntityPlayer entityPlayer) {
        this.sendAll(new Packet201PlayerInfo(entityPlayer.name, true, 1000));
        this.players.add(entityPlayer);
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer.locX >> 4, (int)entityPlayer.locZ >> 4);
        while (worldServer.getEntities(entityPlayer, entityPlayer.boundingBox).size() != 0) {
            entityPlayer.setPosition(entityPlayer.locX, entityPlayer.locY + 1.0, entityPlayer.locZ);
        }
        worldServer.addEntity(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).addPlayer(entityPlayer);
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer2 = (EntityPlayer)this.players.get(i);
            entityPlayer.netServerHandler.sendPacket(new Packet201PlayerInfo(entityPlayer2.name, true, entityPlayer2.i));
        }
    }

    public void d(EntityPlayer entityPlayer) {
        this.getPlayerManager(entityPlayer.dimension).movePlayer(entityPlayer);
    }

    public void disconnect(EntityPlayer entityPlayer) {
        this.playerFileData.a(entityPlayer);
        this.server.getWorldServer(entityPlayer.dimension).kill(entityPlayer);
        this.players.remove(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).removePlayer(entityPlayer);
        this.sendAll(new Packet201PlayerInfo(entityPlayer.name, false, 9999));
    }

    public EntityPlayer a(NetLoginHandler netLoginHandler, String string) {
        if (this.banByName.contains(string.trim().toLowerCase())) {
            netLoginHandler.disconnect("You are banned from this server!");
            return null;
        }
        if (!this.isWhitelisted(string)) {
            netLoginHandler.disconnect("You are not white-listed on this server!");
            return null;
        }
        String string2 = netLoginHandler.networkManager.getSocketAddress().toString();
        string2 = string2.substring(string2.indexOf("/") + 1);
        if (this.banByIP.contains(string2 = string2.substring(0, string2.indexOf(":")))) {
            netLoginHandler.disconnect("Your IP address is banned from this server!");
            return null;
        }
        if (this.players.size() >= this.maxPlayers) {
            netLoginHandler.disconnect("The server is full!");
            return null;
        }
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!entityPlayer.name.equalsIgnoreCase(string)) continue;
            entityPlayer.netServerHandler.disconnect("You logged in from another location");
        }
        return new EntityPlayer(this.server, this.server.getWorldServer(0), string, new ItemInWorldManager(this.server.getWorldServer(0)));
    }

    public EntityPlayer moveToWorld(EntityPlayer entityPlayer, int n, boolean bl) {
        this.server.getTracker(entityPlayer.dimension).untrackPlayer(entityPlayer);
        this.server.getTracker(entityPlayer.dimension).untrackEntity(entityPlayer);
        this.getPlayerManager(entityPlayer.dimension).removePlayer(entityPlayer);
        this.players.remove(entityPlayer);
        this.server.getWorldServer(entityPlayer.dimension).removeEntity(entityPlayer);
        ChunkCoordinates chunkCoordinates = entityPlayer.getBed();
        entityPlayer.dimension = n;
        EntityPlayer entityPlayer2 = new EntityPlayer(this.server, this.server.getWorldServer(entityPlayer.dimension), entityPlayer.name, new ItemInWorldManager(this.server.getWorldServer(entityPlayer.dimension)));
        if (bl) {
            entityPlayer2.copyTo(entityPlayer);
        }
        entityPlayer2.id = entityPlayer.id;
        entityPlayer2.netServerHandler = entityPlayer.netServerHandler;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer2.itemInWorldManager.a(entityPlayer.itemInWorldManager.a());
        entityPlayer2.itemInWorldManager.b(worldServer.r().getGameType());
        if (chunkCoordinates != null) {
            ChunkCoordinates chunkCoordinates2 = EntityHuman.getBed(this.server.getWorldServer(entityPlayer.dimension), chunkCoordinates);
            if (chunkCoordinates2 != null) {
                entityPlayer2.setPositionRotation((float)chunkCoordinates2.x + 0.5f, (float)chunkCoordinates2.y + 0.1f, (float)chunkCoordinates2.z + 0.5f, 0.0f, 0.0f);
                entityPlayer2.a(chunkCoordinates);
            } else {
                entityPlayer2.netServerHandler.sendPacket(new Packet70Bed(0, 0));
            }
        }
        worldServer.chunkProviderServer.getChunkAt((int)entityPlayer2.locX >> 4, (int)entityPlayer2.locZ >> 4);
        while (worldServer.getEntities(entityPlayer2, entityPlayer2.boundingBox).size() != 0) {
            entityPlayer2.setPosition(entityPlayer2.locX, entityPlayer2.locY + 1.0, entityPlayer2.locZ);
        }
        entityPlayer2.netServerHandler.sendPacket(new Packet9Respawn((byte)entityPlayer2.dimension, (byte)entityPlayer2.world.difficulty, entityPlayer2.world.getSeed(), entityPlayer2.world.height, entityPlayer2.itemInWorldManager.a()));
        entityPlayer2.netServerHandler.a(entityPlayer2.locX, entityPlayer2.locY, entityPlayer2.locZ, entityPlayer2.yaw, entityPlayer2.pitch);
        this.a(entityPlayer2, worldServer);
        this.getPlayerManager(entityPlayer2.dimension).addPlayer(entityPlayer2);
        worldServer.addEntity(entityPlayer2);
        this.players.add(entityPlayer2);
        entityPlayer2.syncInventory();
        entityPlayer2.A();
        return entityPlayer2;
    }

    public void a(EntityPlayer entityPlayer, int n) {
        int n2 = entityPlayer.dimension;
        WorldServer worldServer = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.dimension = n;
        WorldServer worldServer2 = this.server.getWorldServer(entityPlayer.dimension);
        entityPlayer.netServerHandler.sendPacket(new Packet9Respawn((byte)entityPlayer.dimension, (byte)entityPlayer.world.difficulty, worldServer2.getSeed(), worldServer2.height, entityPlayer.itemInWorldManager.a()));
        worldServer.removeEntity(entityPlayer);
        entityPlayer.dead = false;
        double d = entityPlayer.locX;
        double d2 = entityPlayer.locZ;
        double d3 = 8.0;
        if (entityPlayer.dimension == -1) {
            entityPlayer.setPositionRotation(d /= d3, entityPlayer.locY, d2 /= d3, entityPlayer.yaw, entityPlayer.pitch);
            if (entityPlayer.aj()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        } else if (entityPlayer.dimension == 0) {
            entityPlayer.setPositionRotation(d *= d3, entityPlayer.locY, d2 *= d3, entityPlayer.yaw, entityPlayer.pitch);
            if (entityPlayer.aj()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        } else {
            ChunkCoordinates chunkCoordinates = worldServer2.d();
            d = chunkCoordinates.x;
            entityPlayer.locY = chunkCoordinates.y;
            d2 = chunkCoordinates.z;
            entityPlayer.setPositionRotation(d, entityPlayer.locY, d2, 90.0f, 0.0f);
            if (entityPlayer.aj()) {
                worldServer.entityJoinedWorld(entityPlayer, false);
            }
        }
        if (n2 != 1 && entityPlayer.aj()) {
            worldServer2.addEntity(entityPlayer);
            entityPlayer.setPositionRotation(d, entityPlayer.locY, d2, entityPlayer.yaw, entityPlayer.pitch);
            worldServer2.entityJoinedWorld(entityPlayer, false);
            worldServer2.chunkProviderServer.forceChunkLoad = true;
            new PortalTravelAgent().a(worldServer2, entityPlayer);
            worldServer2.chunkProviderServer.forceChunkLoad = false;
        }
        this.a(entityPlayer);
        entityPlayer.netServerHandler.a(entityPlayer.locX, entityPlayer.locY, entityPlayer.locZ, entityPlayer.yaw, entityPlayer.pitch);
        entityPlayer.spawnIn(worldServer2);
        entityPlayer.itemInWorldManager.a(worldServer2);
        this.a(entityPlayer, worldServer2);
        this.updateClient(entityPlayer);
    }

    public void b() {
        if (++this.p > 200) {
            this.p = 0;
        }
        if (this.p < this.players.size()) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(this.p);
            this.sendAll(new Packet201PlayerInfo(entityPlayer.name, true, entityPlayer.i));
        }
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i].flush();
        }
    }

    public void flagDirty(int n, int n2, int n3, int n4) {
        this.getPlayerManager(n4).flagDirty(n, n2, n3);
    }

    public void sendAll(Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void a(Packet packet, int n) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (entityPlayer.dimension != n) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public String c() {
        String string = "";
        for (int i = 0; i < this.players.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + ((EntityPlayer)this.players.get((int)i)).name;
        }
        return string;
    }

    public String[] d() {
        String[] stringArray = new String[this.players.size()];
        for (int i = 0; i < this.players.size(); ++i) {
            stringArray[i] = ((EntityPlayer)this.players.get((int)i)).name;
        }
        return stringArray;
    }

    public void addUserBan(String string) {
        this.banByName.add(string.toLowerCase());
        this.m();
    }

    public void removeUserBan(String string) {
        this.banByName.remove(string.toLowerCase());
        this.m();
    }

    private void l() {
        try {
            this.banByName.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.j));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.banByName.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load ban list: " + exception);
        }
    }

    private void m() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.j, false));
            for (String string : this.banByName) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save ban list: " + exception);
        }
    }

    public Set e() {
        return this.banByName;
    }

    public Set f() {
        return this.banByIP;
    }

    public void addIpBan(String string) {
        this.banByIP.add(string.toLowerCase());
        this.o();
    }

    public void removeIpBan(String string) {
        this.banByIP.remove(string.toLowerCase());
        this.o();
    }

    private void n() {
        try {
            this.banByIP.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.k));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.banByIP.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void o() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.k, false));
            for (String string : this.banByIP) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save ip ban list: " + exception);
        }
    }

    public void addOp(String string) {
        this.operators.add(string.toLowerCase());
        this.q();
    }

    public void removeOp(String string) {
        this.operators.remove(string.toLowerCase());
        this.q();
    }

    private void p() {
        try {
            this.operators.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.l));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.operators.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load operators list: " + exception);
        }
    }

    private void q() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.l, false));
            for (String string : this.operators) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save operators list: " + exception);
        }
    }

    private void r() {
        try {
            this.whitelist.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.whitelist.add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load white-list: " + exception);
        }
    }

    private void s() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.m, false));
            for (String string : this.whitelist) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save white-list: " + exception);
        }
    }

    public boolean isWhitelisted(String string) {
        string = string.trim().toLowerCase();
        return !this.hasWhitelist || this.operators.contains(string) || this.whitelist.contains(string);
    }

    public boolean isOp(String string) {
        return this.operators.contains(string.trim().toLowerCase());
    }

    public EntityPlayer i(String string) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!entityPlayer.name.equalsIgnoreCase(string)) continue;
            return entityPlayer;
        }
        return null;
    }

    public void a(String string, String string2) {
        EntityPlayer entityPlayer = this.i(string);
        if (entityPlayer != null) {
            entityPlayer.netServerHandler.sendPacket(new Packet3Chat(string2));
        }
    }

    public void sendPacketNearby(double d, double d2, double d3, double d4, int n, Packet packet) {
        this.sendPacketNearby(null, d, d2, d3, d4, n, packet);
    }

    public void sendPacketNearby(EntityHuman entityHuman, double d, double d2, double d3, double d4, int n, Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            double d5;
            double d6;
            double d7;
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (entityPlayer == entityHuman || entityPlayer.dimension != n || !((d7 = d - entityPlayer.locX) * d7 + (d6 = d2 - entityPlayer.locY) * d6 + (d5 = d3 - entityPlayer.locZ) * d5 < d4 * d4)) continue;
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void j(String string) {
        Packet3Chat packet3Chat = new Packet3Chat(string);
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer = (EntityPlayer)this.players.get(i);
            if (!this.isOp(entityPlayer.name)) continue;
            entityPlayer.netServerHandler.sendPacket(packet3Chat);
        }
    }

    public boolean a(String string, Packet packet) {
        EntityPlayer entityPlayer = this.i(string);
        if (entityPlayer != null) {
            entityPlayer.netServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayers() {
        for (int i = 0; i < this.players.size(); ++i) {
            this.playerFileData.a((EntityHuman)this.players.get(i));
        }
    }

    public void a(int n, int n2, int n3, TileEntity tileEntity) {
    }

    public void addWhitelist(String string) {
        this.whitelist.add(string);
        this.s();
    }

    public void removeWhitelist(String string) {
        this.whitelist.remove(string);
        this.s();
    }

    public Set getWhitelisted() {
        return this.whitelist;
    }

    public void reloadWhitelist() {
        this.r();
    }

    public void a(EntityPlayer entityPlayer, WorldServer worldServer) {
        entityPlayer.netServerHandler.sendPacket(new Packet4UpdateTime(worldServer.getTime()));
        if (worldServer.w()) {
            entityPlayer.netServerHandler.sendPacket(new Packet70Bed(1, 0));
        }
    }

    public void updateClient(EntityPlayer entityPlayer) {
        entityPlayer.updateInventory(entityPlayer.defaultContainer);
        entityPlayer.s_();
    }

    public int j() {
        return this.players.size();
    }

    public int k() {
        return this.maxPlayers;
    }
}

