/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCache;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.ChunkProviderLoadOrGenerate;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.Explosion;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.IWorldAccess;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NextTickListEntry;
import net.minecraft.server.PathEntity;
import net.minecraft.server.Pathfinder;
import net.minecraft.server.SpawnerCreature;
import net.minecraft.server.TileEntity;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WeightedRandom;
import net.minecraft.server.WorldChunkManager;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldMapBase;
import net.minecraft.server.WorldMapCollection;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldSettings;

public class World
implements IBlockAccess {
    public int heightBits = 7;
    public int heightBitsPlusFour = this.heightBits + 4;
    public int height = 1 << this.heightBits;
    public int heightMinusOne = this.height - 1;
    public int seaLevel = this.height / 2 - 1;
    public boolean f = false;
    public List entityList = new ArrayList();
    private List J = new ArrayList();
    private TreeSet K = new TreeSet();
    private Set L = new HashSet();
    public List h = new ArrayList();
    private List M = new ArrayList();
    private List N = new ArrayList();
    public List players = new ArrayList();
    public List j = new ArrayList();
    private long O = 0xFFFFFFL;
    public int k = 0;
    protected int l = new Random().nextInt();
    protected final int m = 1013904223;
    protected float n;
    protected float o;
    protected float p;
    protected float q;
    protected int r = 0;
    public int s = 0;
    public boolean suppressPhysics = false;
    private long P = System.currentTimeMillis();
    protected int u = 40;
    public int difficulty;
    public Random random = new Random();
    public boolean x = false;
    public final WorldProvider worldProvider;
    protected List z = new ArrayList();
    protected IChunkProvider chunkProvider;
    protected final IDataManager B;
    protected WorldData worldData;
    public boolean isLoading;
    private boolean Q;
    public WorldMapCollection worldMaps;
    private ArrayList R = new ArrayList();
    private boolean S;
    protected boolean allowMonsters = true;
    protected boolean allowAnimals = true;
    private Set T = new HashSet();
    private int U = this.random.nextInt(12000);
    int[] H = new int[32768];
    private List V = new ArrayList();
    public boolean isStatic = false;

    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.b;
    }

    public World(IDataManager iDataManager, String string, WorldSettings worldSettings, WorldProvider worldProvider) {
        this.B = iDataManager;
        this.worldMaps = new WorldMapCollection(iDataManager);
        this.worldData = iDataManager.c();
        boolean bl = this.x = this.worldData == null;
        this.worldProvider = worldProvider != null ? worldProvider : (this.worldData != null && this.worldData.h() != 0 ? WorldProvider.byDimension(this.worldData.h()) : WorldProvider.byDimension(0));
        boolean bl2 = false;
        if (this.worldData == null) {
            this.worldData = new WorldData(worldSettings, string);
            bl2 = true;
        } else {
            this.worldData.a(string);
        }
        this.worldProvider.a(this);
        this.chunkProvider = this.b();
        if (bl2) {
            this.c();
        }
        this.g();
        this.z();
    }

    protected IChunkProvider b() {
        IChunkLoader iChunkLoader = this.B.a(this.worldProvider);
        return new ChunkProviderLoadOrGenerate(this, iChunkLoader, this.worldProvider.getChunkProvider());
    }

    protected void c() {
        this.isLoading = true;
        WorldChunkManager worldChunkManager = this.getWorldChunkManager();
        List list = worldChunkManager.a();
        Random random = new Random(this.getSeed());
        ChunkPosition chunkPosition = worldChunkManager.a(0, 0, 256, list, random);
        int n = 0;
        int n2 = this.height / 2;
        int n3 = 0;
        if (chunkPosition != null) {
            n = chunkPosition.x;
            n3 = chunkPosition.z;
        } else {
            System.out.println("Unable to find spawn biome");
        }
        int n4 = 0;
        while (!this.worldProvider.canSpawn(n, n3)) {
            n += random.nextInt(64) - random.nextInt(64);
            n3 += random.nextInt(64) - random.nextInt(64);
            if (++n4 != 1000) continue;
        }
        this.worldData.setSpawn(n, n2, n3);
        this.isLoading = false;
    }

    public ChunkCoordinates d() {
        return this.worldProvider.d();
    }

    public int a(int n, int n2) {
        int n3 = this.seaLevel;
        while (!this.isEmpty(n, n3 + 1, n2)) {
            ++n3;
        }
        return this.getTypeId(n, n3, n2);
    }

    public void save(boolean bl, IProgressUpdate iProgressUpdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iProgressUpdate != null) {
            iProgressUpdate.a("Saving level");
        }
        this.y();
        if (iProgressUpdate != null) {
            iProgressUpdate.b("Saving chunks");
        }
        this.chunkProvider.saveChunks(bl, iProgressUpdate);
    }

    private void y() {
        this.l();
        this.B.a(this.worldData, this.players);
        this.worldMaps.a();
    }

    public int getTypeId(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= this.height) {
            return 0;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).getTypeId(n & 0xF, n2, n3 & 0xF);
    }

    public boolean isEmpty(int n, int n2, int n3) {
        return this.getTypeId(n, n2, n3) == 0;
    }

    public boolean isLoaded(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.height) {
            return false;
        }
        return this.isChunkLoaded(n >> 4, n3 >> 4);
    }

    public boolean areChunksLoaded(int n, int n2, int n3, int n4) {
        return this.a(n - n4, n2 - n4, n3 - n4, n + n4, n2 + n4, n3 + n4);
    }

    public boolean a(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0 || n2 >= this.height) {
            return false;
        }
        n >>= 4;
        n2 >>= 4;
        n3 >>= 4;
        n4 >>= 4;
        n5 >>= 4;
        n6 >>= 4;
        for (int i = n; i <= n4; ++i) {
            for (int j = n3; j <= n6; ++j) {
                if (this.isChunkLoaded(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isChunkLoaded(int n, int n2) {
        return this.chunkProvider.isChunkLoaded(n, n2);
    }

    public Chunk getChunkAtWorldCoords(int n, int n2) {
        return this.getChunkAt(n >> 4, n2 >> 4);
    }

    public Chunk getChunkAt(int n, int n2) {
        return this.chunkProvider.getOrCreateChunk(n, n2);
    }

    public boolean setRawTypeIdAndData(int n, int n2, int n3, int n4, int n5) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= this.height) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        boolean bl = chunk.a(n & 0xF, n2, n3 & 0xF, n4, n5);
        this.s(n, n2, n3);
        return bl;
    }

    public boolean setRawTypeId(int n, int n2, int n3, int n4) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= this.height) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        boolean bl = chunk.a(n & 0xF, n2, n3 & 0xF, n4);
        this.s(n, n2, n3);
        return bl;
    }

    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        if (n4 == 0) {
            return Material.AIR;
        }
        return Block.byId[n4].material;
    }

    public int getData(int n, int n2, int n3) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= this.height) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.getData(n &= 0xF, n2, n3 &= 0xF);
    }

    public void setData(int n, int n2, int n3, int n4) {
        if (this.setRawData(n, n2, n3, n4)) {
            int n5 = this.getTypeId(n, n2, n3);
            if (Block.t[n5 & 0xFF]) {
                this.update(n, n2, n3, n5);
            } else {
                this.applyPhysics(n, n2, n3, n5);
            }
        }
    }

    public boolean setRawData(int n, int n2, int n3, int n4) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n2 >= this.height) {
            return false;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.b(n &= 0xF, n2, n3 &= 0xF, n4);
    }

    public boolean setTypeId(int n, int n2, int n3, int n4) {
        if (this.setRawTypeId(n, n2, n3, n4)) {
            this.update(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public boolean setTypeIdAndData(int n, int n2, int n3, int n4, int n5) {
        if (this.setRawTypeIdAndData(n, n2, n3, n4, n5)) {
            this.update(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public void notify(int n, int n2, int n3) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(n, n2, n3);
        }
    }

    protected void update(int n, int n2, int n3, int n4) {
        this.notify(n, n2, n3);
        this.applyPhysics(n, n2, n3, n4);
    }

    public void g(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        if (!this.worldProvider.e) {
            for (n5 = n3; n5 <= n4; ++n5) {
                this.b(EnumSkyBlock.SKY, n, n5, n2);
            }
        }
        this.b(n, n3, n2, n, n4, n2);
    }

    public void i(int n, int n2, int n3) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(n, n2, n3, n, n2, n3);
        }
    }

    public void b(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(n, n2, n3, n4, n5, n6);
        }
    }

    public void applyPhysics(int n, int n2, int n3, int n4) {
        this.k(n - 1, n2, n3, n4);
        this.k(n + 1, n2, n3, n4);
        this.k(n, n2 - 1, n3, n4);
        this.k(n, n2 + 1, n3, n4);
        this.k(n, n2, n3 - 1, n4);
        this.k(n, n2, n3 + 1, n4);
    }

    private void k(int n, int n2, int n3, int n4) {
        if (this.suppressPhysics || this.isStatic) {
            return;
        }
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block != null) {
            block.doPhysics(this, n, n2, n3, n4);
        }
    }

    public boolean isChunkLoaded(int n, int n2, int n3) {
        return this.getChunkAt(n >> 4, n3 >> 4).c(n & 0xF, n2, n3 & 0xF);
    }

    public int k(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).c(n & 0xF, n2, n3 & 0xF, 0);
    }

    public int getLightLevel(int n, int n2, int n3) {
        return this.a(n, n2, n3, true);
    }

    public int a(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return 15;
        }
        if (bl && ((n4 = this.getTypeId(n, n2, n3)) == Block.STEP.id || n4 == Block.SOIL.id || n4 == Block.COBBLESTONE_STAIRS.id || n4 == Block.WOOD_STAIRS.id)) {
            int n5 = this.a(n, n2 + 1, n3, false);
            int n6 = this.a(n + 1, n2, n3, false);
            int n7 = this.a(n - 1, n2, n3, false);
            int n8 = this.a(n, n2, n3 + 1, false);
            int n9 = this.a(n, n2, n3 - 1, false);
            if (n6 > n5) {
                n5 = n6;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n9 > n5) {
                n5 = n9;
            }
            return n5;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk.c(n &= 0xF, n2, n3 &= 0xF, this.k);
    }

    public int getHighestBlockYAt(int n, int n2) {
        if (n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000) {
            return 0;
        }
        if (!this.isChunkLoaded(n >> 4, n2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n2 >> 4);
        return chunk.b(n & 0xF, n2 & 0xF);
    }

    public int a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        if (n2 < 0 || n2 >= this.height || n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return enumSkyBlock.c;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        if (!this.isChunkLoaded(n4, n5)) {
            return 0;
        }
        Chunk chunk = this.getChunkAt(n4, n5);
        return chunk.a(enumSkyBlock, n & 0xF, n2, n3 & 0xF);
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        if (n2 >= this.height) {
            return;
        }
        if (!this.isChunkLoaded(n >> 4, n3 >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        chunk.a(enumSkyBlock, n & 0xF, n2, n3 & 0xF, n4);
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(n, n2, n3);
        }
    }

    public float m(int n, int n2, int n3) {
        return this.worldProvider.f[this.getLightLevel(n, n2, n3)];
    }

    public boolean e() {
        return this.k < 4;
    }

    public MovingObjectPosition a(Vec3D vec3D, Vec3D vec3D2) {
        return this.rayTrace(vec3D, vec3D2, false, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl) {
        return this.rayTrace(vec3D, vec3D2, bl, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl, boolean bl2) {
        MovingObjectPosition movingObjectPosition;
        if (Double.isNaN(vec3D.a) || Double.isNaN(vec3D.b) || Double.isNaN(vec3D.c)) {
            return null;
        }
        if (Double.isNaN(vec3D2.a) || Double.isNaN(vec3D2.b) || Double.isNaN(vec3D2.c)) {
            return null;
        }
        int n = MathHelper.floor(vec3D2.a);
        int n2 = MathHelper.floor(vec3D2.b);
        int n3 = MathHelper.floor(vec3D2.c);
        int n4 = MathHelper.floor(vec3D.a);
        int n5 = MathHelper.floor(vec3D.b);
        int n6 = MathHelper.floor(vec3D.c);
        int n7 = this.getTypeId(n4, n5, n6);
        int n8 = this.getData(n4, n5, n6);
        Block block = Block.byId[n7];
        if ((!bl2 || block == null || block.e(this, n4, n5, n6) != null) && n7 > 0 && block.a(n8, bl) && (movingObjectPosition = block.a(this, n4, n5, n6, vec3D, vec3D2)) != null) {
            return movingObjectPosition;
        }
        n7 = 200;
        while (n7-- >= 0) {
            MovingObjectPosition movingObjectPosition2;
            if (Double.isNaN(vec3D.a) || Double.isNaN(vec3D.b) || Double.isNaN(vec3D.c)) {
                return null;
            }
            if (n4 == n && n5 == n2 && n6 == n3) {
                return null;
            }
            n8 = 1;
            boolean bl3 = true;
            boolean bl4 = true;
            double d = 999.0;
            double d2 = 999.0;
            double d3 = 999.0;
            if (n > n4) {
                d = (double)n4 + 1.0;
            } else if (n < n4) {
                d = (double)n4 + 0.0;
            } else {
                n8 = 0;
            }
            if (n2 > n5) {
                d2 = (double)n5 + 1.0;
            } else if (n2 < n5) {
                d2 = (double)n5 + 0.0;
            } else {
                bl3 = false;
            }
            if (n3 > n6) {
                d3 = (double)n6 + 1.0;
            } else if (n3 < n6) {
                d3 = (double)n6 + 0.0;
            } else {
                bl4 = false;
            }
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = 999.0;
            double d7 = vec3D2.a - vec3D.a;
            double d8 = vec3D2.b - vec3D.b;
            double d9 = vec3D2.c - vec3D.c;
            if (n8 != 0) {
                d4 = (d - vec3D.a) / d7;
            }
            if (bl3) {
                d5 = (d2 - vec3D.b) / d8;
            }
            if (bl4) {
                d6 = (d3 - vec3D.c) / d9;
            }
            int n9 = 0;
            if (d4 < d5 && d4 < d6) {
                n9 = n > n4 ? 4 : 5;
                vec3D.a = d;
                vec3D.b += d8 * d4;
                vec3D.c += d9 * d4;
            } else if (d5 < d6) {
                n9 = n2 > n5 ? 0 : 1;
                vec3D.a += d7 * d5;
                vec3D.b = d2;
                vec3D.c += d9 * d5;
            } else {
                n9 = n3 > n6 ? 2 : 3;
                vec3D.a += d7 * d6;
                vec3D.b += d8 * d6;
                vec3D.c = d3;
            }
            Vec3D vec3D3 = Vec3D.create(vec3D.a, vec3D.b, vec3D.c);
            vec3D3.a = MathHelper.floor(vec3D.a);
            n4 = (int)vec3D3.a;
            if (n9 == 5) {
                --n4;
                vec3D3.a += 1.0;
            }
            vec3D3.b = MathHelper.floor(vec3D.b);
            n5 = (int)vec3D3.b;
            if (n9 == 1) {
                --n5;
                vec3D3.b += 1.0;
            }
            vec3D3.c = MathHelper.floor(vec3D.c);
            n6 = (int)vec3D3.c;
            if (n9 == 3) {
                --n6;
                vec3D3.c += 1.0;
            }
            int n10 = this.getTypeId(n4, n5, n6);
            int n11 = this.getData(n4, n5, n6);
            Block block2 = Block.byId[n10];
            if (bl2 && block2 != null && block2.e(this, n4, n5, n6) == null || n10 <= 0 || !block2.a(n11, bl) || (movingObjectPosition2 = block2.a(this, n4, n5, n6, vec3D, vec3D2)) == null) continue;
            return movingObjectPosition2;
        }
        return null;
    }

    public void makeSound(Entity entity, String string, float f, float f2) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(string, entity.locX, entity.locY - (double)entity.height, entity.locZ, f, f2);
        }
    }

    public void makeSound(double d, double d2, double d3, String string, float f, float f2) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(string, d, d2, d3, f, f2);
        }
    }

    public void a(String string, int n, int n2, int n3) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(string, n, n2, n3);
        }
    }

    public void a(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(string, d, d2, d3, d4, d5, d6);
        }
    }

    public boolean strikeLightning(Entity entity) {
        this.j.add(entity);
        return true;
    }

    public boolean addEntity(Entity entity) {
        int n = MathHelper.floor(entity.locX / 16.0);
        int n2 = MathHelper.floor(entity.locZ / 16.0);
        boolean bl = false;
        if (entity instanceof EntityHuman) {
            bl = true;
        }
        if (bl || this.isChunkLoaded(n, n2)) {
            if (entity instanceof EntityHuman) {
                EntityHuman entityHuman = (EntityHuman)entity;
                this.players.add(entityHuman);
                this.everyoneSleeping();
            }
            this.getChunkAt(n, n2).a(entity);
            this.entityList.add(entity);
            this.c(entity);
            return true;
        }
        return false;
    }

    protected void c(Entity entity) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(entity);
        }
    }

    protected void d(Entity entity) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).b(entity);
        }
    }

    public void kill(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.mount(null);
        }
        if (entity.vehicle != null) {
            entity.mount(null);
        }
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove((EntityHuman)entity);
            this.everyoneSleeping();
        }
    }

    public void removeEntity(Entity entity) {
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove((EntityHuman)entity);
            this.everyoneSleeping();
        }
        int n = entity.bX;
        int n2 = entity.bZ;
        if (entity.bW && this.isChunkLoaded(n, n2)) {
            this.getChunkAt(n, n2).b(entity);
        }
        this.entityList.remove(entity);
        this.d(entity);
    }

    public void addIWorldAccess(IWorldAccess iWorldAccess) {
        this.z.add(iWorldAccess);
    }

    public List getEntities(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.R.clear();
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.isLoaded(i, this.height / 2, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.byId[this.getTypeId(i, k, j)];
                    if (block == null) continue;
                    block.a(this, i, k, j, axisAlignedBB, this.R);
                }
            }
        }
        double d = 0.25;
        List list = this.b(entity, axisAlignedBB.b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisAlignedBB2 = ((Entity)list.get(i)).h_();
            if (axisAlignedBB2 != null && axisAlignedBB2.a(axisAlignedBB)) {
                this.R.add(axisAlignedBB2);
            }
            if ((axisAlignedBB2 = entity.a_((Entity)list.get(i))) == null || !axisAlignedBB2.a(axisAlignedBB)) continue;
            this.R.add(axisAlignedBB2);
        }
        return this.R;
    }

    public int a(float f) {
        float f2 = this.b(f);
        float f3 = 1.0f - (MathHelper.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.0f - f3;
        f3 = (float)((double)f3 * (1.0 - (double)(this.d(f) * 5.0f) / 16.0));
        f3 = (float)((double)f3 * (1.0 - (double)(this.c(f) * 5.0f) / 16.0));
        f3 = 1.0f - f3;
        return (int)(f3 * 11.0f);
    }

    public float b(float f) {
        return this.worldProvider.a(this.worldData.f(), f);
    }

    public int e(int n, int n2) {
        return this.getChunkAtWorldCoords(n, n2).c(n & 0xF, n2 & 0xF);
    }

    public int f(int n, int n2) {
        Chunk chunk = this.getChunkAtWorldCoords(n, n2);
        n &= 0xF;
        n2 &= 0xF;
        for (int i = this.height - 1; i > 0; --i) {
            int n3 = chunk.getTypeId(n, i, n2);
            if (n3 == 0 || !Block.byId[n3].material.isSolid() || Block.byId[n3].material == Material.LEAVES) {
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    public void c(int n, int n2, int n3, int n4, int n5) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        int n6 = 8;
        if (this.f) {
            int n7;
            if (this.a(nextTickListEntry.a - n6, nextTickListEntry.b - n6, nextTickListEntry.c - n6, nextTickListEntry.a + n6, nextTickListEntry.b + n6, nextTickListEntry.c + n6) && (n7 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) == nextTickListEntry.d && n7 > 0) {
                Block.byId[n7].a(this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
            }
            return;
        }
        if (this.a(n - n6, n2 - n6, n3 - n6, n + n6, n2 + n6, n3 + n6)) {
            if (n4 > 0) {
                nextTickListEntry.a((long)n5 + this.worldData.f());
            }
            if (!this.L.contains(nextTickListEntry)) {
                this.L.add(nextTickListEntry);
                this.K.add(nextTickListEntry);
            }
        }
    }

    public void d(int n, int n2, int n3, int n4, int n5) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        if (n4 > 0) {
            nextTickListEntry.a((long)n5 + this.worldData.f());
        }
        if (!this.L.contains(nextTickListEntry)) {
            this.L.add(nextTickListEntry);
            this.K.add(nextTickListEntry);
        }
    }

    public void tickEntities() {
        int n;
        int n2;
        Object object;
        int n3;
        MethodProfiler.a("entities");
        MethodProfiler.a("global");
        for (n3 = 0; n3 < this.j.size(); ++n3) {
            object = (Entity)this.j.get(n3);
            ((Entity)object).w_();
            if (!((Entity)object).dead) continue;
            this.j.remove(n3--);
        }
        MethodProfiler.b("remove");
        this.entityList.removeAll(this.J);
        for (n3 = 0; n3 < this.J.size(); ++n3) {
            object = (Entity)this.J.get(n3);
            n2 = ((Entity)object).bX;
            n = ((Entity)object).bZ;
            if (!((Entity)object).bW || !this.isChunkLoaded(n2, n)) continue;
            this.getChunkAt(n2, n).b((Entity)object);
        }
        for (n3 = 0; n3 < this.J.size(); ++n3) {
            this.d((Entity)this.J.get(n3));
        }
        this.J.clear();
        MethodProfiler.b("regular");
        for (n3 = 0; n3 < this.entityList.size(); ++n3) {
            object = (Entity)this.entityList.get(n3);
            if (((Entity)object).vehicle != null) {
                if (!((Entity)object).vehicle.dead && ((Entity)object).vehicle.passenger == object) continue;
                ((Entity)object).vehicle.passenger = null;
                ((Entity)object).vehicle = null;
            }
            if (!((Entity)object).dead) {
                this.playerJoinedWorld((Entity)object);
            }
            MethodProfiler.a("remove");
            if (((Entity)object).dead) {
                n2 = ((Entity)object).bX;
                n = ((Entity)object).bZ;
                if (((Entity)object).bW && this.isChunkLoaded(n2, n)) {
                    this.getChunkAt(n2, n).b((Entity)object);
                }
                this.entityList.remove(n3--);
                this.d((Entity)object);
            }
            MethodProfiler.a();
        }
        MethodProfiler.b("tileEntities");
        this.S = true;
        Iterator iterator = this.h.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            object = (TileEntity)iterator.next();
            if (!((TileEntity)object).l() && ((TileEntity)object).world != null && this.isLoaded(((TileEntity)object).x, ((TileEntity)object).y, ((TileEntity)object).z)) {
                ((TileEntity)object).l_();
            }
            if (!((TileEntity)object).l()) continue;
            iterator.remove();
            if (!this.isChunkLoaded(((TileEntity)object).x >> 4, ((TileEntity)object).z >> 4) || (chunk = this.getChunkAt(((TileEntity)object).x >> 4, ((TileEntity)object).z >> 4)) == null) continue;
            chunk.e(((TileEntity)object).x & 0xF, ((TileEntity)object).y, ((TileEntity)object).z & 0xF);
        }
        this.S = false;
        if (!this.N.isEmpty()) {
            this.h.removeAll(this.N);
            this.N.clear();
        }
        MethodProfiler.b("pendingTileEntities");
        if (!this.M.isEmpty()) {
            for (TileEntity tileEntity : this.M) {
                Chunk chunk;
                if (tileEntity.l()) continue;
                if (!this.h.contains(tileEntity)) {
                    this.h.add(tileEntity);
                }
                if (this.isChunkLoaded(tileEntity.x >> 4, tileEntity.z >> 4) && (chunk = this.getChunkAt(tileEntity.x >> 4, tileEntity.z >> 4)) != null) {
                    chunk.a(tileEntity.x & 0xF, tileEntity.y, tileEntity.z & 0xF, tileEntity);
                }
                this.notify(tileEntity.x, tileEntity.y, tileEntity.z);
            }
            this.M.clear();
        }
        MethodProfiler.a();
        MethodProfiler.a();
    }

    public void a(Collection collection) {
        if (this.S) {
            this.M.addAll(collection);
        } else {
            this.h.addAll(collection);
        }
    }

    public void playerJoinedWorld(Entity entity) {
        this.entityJoinedWorld(entity, true);
    }

    public void entityJoinedWorld(Entity entity, boolean bl) {
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locZ);
        int n3 = 32;
        if (bl && !this.a(n - n3, 0, n2 - n3, n + n3, this.height, n2 + n3)) {
            return;
        }
        entity.bI = entity.locX;
        entity.bJ = entity.locY;
        entity.bK = entity.locZ;
        entity.lastYaw = entity.yaw;
        entity.lastPitch = entity.pitch;
        if (bl && entity.bW) {
            if (entity.vehicle != null) {
                entity.M();
            } else {
                entity.w_();
            }
        }
        MethodProfiler.a("chunkCheck");
        if (Double.isNaN(entity.locX) || Double.isInfinite(entity.locX)) {
            entity.locX = entity.bI;
        }
        if (Double.isNaN(entity.locY) || Double.isInfinite(entity.locY)) {
            entity.locY = entity.bJ;
        }
        if (Double.isNaN(entity.locZ) || Double.isInfinite(entity.locZ)) {
            entity.locZ = entity.bK;
        }
        if (Double.isNaN(entity.pitch) || Double.isInfinite(entity.pitch)) {
            entity.pitch = entity.lastPitch;
        }
        if (Double.isNaN(entity.yaw) || Double.isInfinite(entity.yaw)) {
            entity.yaw = entity.lastYaw;
        }
        int n4 = MathHelper.floor(entity.locX / 16.0);
        int n5 = MathHelper.floor(entity.locY / 16.0);
        int n6 = MathHelper.floor(entity.locZ / 16.0);
        if (!entity.bW || entity.bX != n4 || entity.bY != n5 || entity.bZ != n6) {
            if (entity.bW && this.isChunkLoaded(entity.bX, entity.bZ)) {
                this.getChunkAt(entity.bX, entity.bZ).a(entity, entity.bY);
            }
            if (this.isChunkLoaded(n4, n6)) {
                entity.bW = true;
                this.getChunkAt(n4, n6).a(entity);
            } else {
                entity.bW = false;
            }
        }
        MethodProfiler.a();
        if (bl && entity.bW && entity.passenger != null) {
            if (entity.passenger.dead || entity.passenger.vehicle != entity) {
                entity.passenger.vehicle = null;
                entity.passenger = null;
            } else {
                this.playerJoinedWorld(entity.passenger);
            }
        }
    }

    public boolean containsEntity(AxisAlignedBB axisAlignedBB) {
        List list = this.b(null, axisAlignedBB);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity.dead || !entity.bc) continue;
            return false;
        }
        return true;
    }

    public boolean b(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean c(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || !block.material.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean d(AxisAlignedBB axisAlignedBB) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (this.a(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            for (int i = n2; i < n3; ++i) {
                for (int j = n4; j < n5; ++j) {
                    for (int k = n6; k < n; ++k) {
                        int n7 = this.getTypeId(i, j, k);
                        if (n7 != Block.FIRE.id && n7 != Block.LAVA.id && n7 != Block.STATIONARY_LAVA.id) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material, Entity entity) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (!this.a(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            return false;
        }
        boolean bl = false;
        Vec3D vec3D = Vec3D.create(0.0, 0.0, 0.0);
        for (int i = n2; i < n3; ++i) {
            for (int j = n4; j < n5; ++j) {
                for (int k = n6; k < n; ++k) {
                    double d;
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material || !((double)n5 >= (d = (double)((float)(j + 1) - BlockFluids.d(this.getData(i, j, k)))))) continue;
                    bl = true;
                    block.a(this, i, j, k, entity, vec3D);
                }
            }
        }
        if (vec3D.c() > 0.0) {
            vec3D = vec3D.b();
            double d = 0.014;
            entity.motX += vec3D.a * d;
            entity.motY += vec3D.b * d;
            entity.motZ += vec3D.c * d;
        }
        return bl;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    int n7 = this.getData(i, j, k);
                    double d = j + 1;
                    if (n7 < 8) {
                        d = (double)(j + 1) - (double)n7 / 8.0;
                    }
                    if (!(d >= axisAlignedBB.b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion a(Entity entity, double d, double d2, double d3, float f) {
        return this.createExplosion(entity, d, d2, d3, f, false);
    }

    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.a();
        explosion.a(true);
        return explosion;
    }

    public float a(Vec3D vec3D, AxisAlignedBB axisAlignedBB) {
        double d = 1.0 / ((axisAlignedBB.d - axisAlignedBB.a) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisAlignedBB.e - axisAlignedBB.b) * 2.0 + 1.0);
        double d3 = 1.0 / ((axisAlignedBB.f - axisAlignedBB.c) * 2.0 + 1.0);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    double d4 = axisAlignedBB.a + (axisAlignedBB.d - axisAlignedBB.a) * (double)f;
                    double d5 = axisAlignedBB.b + (axisAlignedBB.e - axisAlignedBB.b) * (double)f2;
                    double d6 = axisAlignedBB.c + (axisAlignedBB.f - axisAlignedBB.c) * (double)f3;
                    if (this.a(Vec3D.create(d4, d5, d6), vec3D) == null) {
                        ++n;
                    }
                    ++n2;
                    f3 = (float)((double)f3 + d3);
                }
                f2 = (float)((double)f2 + d2);
            }
            f = (float)((double)f + d);
        }
        return (float)n / (float)n2;
    }

    public void douseFire(EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            --n2;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (this.getTypeId(n, n2, n3) == Block.FIRE.id) {
            this.a(entityHuman, 1004, n, n2, n3, 0);
            this.setTypeId(n, n2, n3, 0);
        }
    }

    public TileEntity getTileEntity(int n, int n2, int n3) {
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        if (chunk != null) {
            TileEntity tileEntity = chunk.d(n & 0xF, n2, n3 & 0xF);
            if (tileEntity == null) {
                for (TileEntity tileEntity2 : this.M) {
                    if (tileEntity2.l() || tileEntity2.x != n || tileEntity2.y != n2 || tileEntity2.z != n3) continue;
                    tileEntity = tileEntity2;
                    break;
                }
            }
            return tileEntity;
        }
        return null;
    }

    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
        if (tileEntity != null && !tileEntity.l()) {
            if (this.S) {
                tileEntity.x = n;
                tileEntity.y = n2;
                tileEntity.z = n3;
                this.M.add(tileEntity);
            } else {
                this.h.add(tileEntity);
                Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
                if (chunk != null) {
                    chunk.a(n & 0xF, n2, n3 & 0xF, tileEntity);
                }
            }
        }
    }

    public void n(int n, int n2, int n3) {
        TileEntity tileEntity = this.getTileEntity(n, n2, n3);
        if (tileEntity != null && this.S) {
            tileEntity.i();
            this.M.remove(tileEntity);
        } else {
            Chunk chunk;
            if (tileEntity != null) {
                this.M.remove(tileEntity);
                this.h.remove(tileEntity);
            }
            if ((chunk = this.getChunkAt(n >> 4, n3 >> 4)) != null) {
                chunk.e(n & 0xF, n2, n3 & 0xF);
            }
        }
    }

    public void a(TileEntity tileEntity) {
        this.N.add(tileEntity);
    }

    public boolean o(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.a();
    }

    public boolean e(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.material.j() && block.b();
    }

    public boolean b(int n, int n2, int n3, boolean bl) {
        if (n < -30000000 || n3 < -30000000 || n >= 30000000 || n3 >= 30000000) {
            return bl;
        }
        Chunk chunk = this.chunkProvider.getOrCreateChunk(n >> 4, n3 >> 4);
        if (chunk == null || chunk.isEmpty()) {
            return bl;
        }
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.material.j() && block.b();
    }

    public void g() {
        int n = this.a(1.0f);
        if (n != this.k) {
            this.k = n;
        }
    }

    public void setSpawnFlags(boolean bl, boolean bl2) {
        this.allowMonsters = bl;
        this.allowAnimals = bl2;
    }

    public void doTick() {
        long l;
        int n;
        if (this.r().isHardcore() && this.difficulty < 3) {
            this.difficulty = 3;
        }
        this.getWorldChunkManager().b();
        this.i();
        if (this.everyoneDeeplySleeping()) {
            n = 0;
            if (!this.allowMonsters || this.difficulty >= 1) {
                // empty if block
            }
            if (n == 0) {
                l = this.worldData.f() + 24000L;
                this.worldData.a(l - l % 24000L);
                this.t();
            }
        }
        MethodProfiler.a("mobSpawner");
        SpawnerCreature.spawnEntities(this, this.allowMonsters, this.allowAnimals && this.worldData.f() % 400L == 0L);
        MethodProfiler.b("chunkSource");
        this.chunkProvider.unloadChunks();
        n = this.a(1.0f);
        if (n != this.k) {
            this.k = n;
        }
        if ((l = this.worldData.f() + 1L) % (long)this.u == 0L) {
            MethodProfiler.b("save");
            this.save(false, null);
        }
        this.worldData.a(l);
        MethodProfiler.b("tickPending");
        this.a(false);
        MethodProfiler.b("tickTiles");
        this.k();
        MethodProfiler.a();
    }

    private void z() {
        if (this.worldData.hasStorm()) {
            this.o = 1.0f;
            if (this.worldData.isThundering()) {
                this.q = 1.0f;
            }
        }
    }

    protected void i() {
        int n;
        if (this.worldProvider.e) {
            return;
        }
        if (this.r > 0) {
            --this.r;
        }
        if ((n = this.worldData.getThunderDuration()) <= 0) {
            if (this.worldData.isThundering()) {
                this.worldData.setThunderDuration(this.random.nextInt(12000) + 3600);
            } else {
                this.worldData.setThunderDuration(this.random.nextInt(168000) + 12000);
            }
        } else {
            this.worldData.setThunderDuration(--n);
            if (n <= 0) {
                this.worldData.setThundering(!this.worldData.isThundering());
            }
        }
        int n2 = this.worldData.getWeatherDuration();
        if (n2 <= 0) {
            if (this.worldData.hasStorm()) {
                this.worldData.setWeatherDuration(this.random.nextInt(12000) + 12000);
            } else {
                this.worldData.setWeatherDuration(this.random.nextInt(168000) + 12000);
            }
        } else {
            this.worldData.setWeatherDuration(--n2);
            if (n2 <= 0) {
                this.worldData.setStorm(!this.worldData.hasStorm());
            }
        }
        this.n = this.o;
        this.o = this.worldData.hasStorm() ? (float)((double)this.o + 0.01) : (float)((double)this.o - 0.01);
        if (this.o < 0.0f) {
            this.o = 0.0f;
        }
        if (this.o > 1.0f) {
            this.o = 1.0f;
        }
        this.p = this.q;
        this.q = this.worldData.isThundering() ? (float)((double)this.q + 0.01) : (float)((double)this.q - 0.01);
        if (this.q < 0.0f) {
            this.q = 0.0f;
        }
        if (this.q > 1.0f) {
            this.q = 1.0f;
        }
    }

    private void A() {
        this.worldData.setWeatherDuration(0);
        this.worldData.setStorm(false);
        this.worldData.setThunderDuration(0);
        this.worldData.setThundering(false);
    }

    public void j() {
        this.worldData.setWeatherDuration(1);
    }

    protected void k() {
        int n;
        int n2;
        int n3;
        this.T.clear();
        MethodProfiler.a("buildList");
        for (n3 = 0; n3 < this.players.size(); ++n3) {
            EntityHuman entityHuman = (EntityHuman)this.players.get(n3);
            int n4 = MathHelper.floor(entityHuman.locX / 16.0);
            int n5 = MathHelper.floor(entityHuman.locZ / 16.0);
            n2 = 7;
            for (n = -n2; n <= n2; ++n) {
                for (int i = -n2; i <= n2; ++i) {
                    this.T.add(new ChunkCoordIntPair(n + n4, i + n5));
                }
            }
        }
        if (this.U > 0) {
            --this.U;
        }
        n3 = 0;
        int n6 = 0;
        MethodProfiler.a();
        for (ChunkCoordIntPair chunkCoordIntPair : this.T) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            n2 = chunkCoordIntPair.x * 16;
            n = chunkCoordIntPair.z * 16;
            MethodProfiler.a("getChunk");
            Chunk chunk = this.getChunkAt(chunkCoordIntPair.x, chunkCoordIntPair.z);
            MethodProfiler.b("tickChunk");
            chunk.i();
            MethodProfiler.b("moodSound");
            if (this.U == 0) {
                EntityHuman entityHuman;
                this.l = this.l * 3 + 1013904223;
                n11 = this.l >> 2;
                n10 = n11 & 0xF;
                n9 = n11 >> 8 & 0xF;
                n8 = n11 >> 16 & this.heightMinusOne;
                n7 = chunk.getTypeId(n10, n8, n9);
                if (n7 == 0 && this.k(n10 += n2, n8, n9 += n) <= this.random.nextInt(8) && this.a(EnumSkyBlock.SKY, n10, n8, n9) <= 0 && (entityHuman = this.a((double)n10 + 0.5, (double)n8 + 0.5, (double)n9 + 0.5, 8.0)) != null && entityHuman.e((double)n10 + 0.5, (double)n8 + 0.5, (double)n9 + 0.5) > 4.0) {
                    this.makeSound((double)n10 + 0.5, (double)n8 + 0.5, (double)n9 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.random.nextFloat() * 0.2f);
                    this.U = this.random.nextInt(12000) + 6000;
                }
            }
            MethodProfiler.b("thunder");
            if (this.random.nextInt(100000) == 0 && this.w() && this.v()) {
                this.l = this.l * 3 + 1013904223;
                n11 = this.l >> 2;
                n10 = n2 + (n11 & 0xF);
                n9 = n + (n11 >> 8 & 0xF);
                n8 = this.e(n10, n9);
                if (this.v(n10, n8, n9)) {
                    this.strikeLightning(new EntityWeatherStorm(this, n10, n8, n9));
                    this.r = 2;
                }
            }
            MethodProfiler.b("iceandsnow");
            this.l = this.l * 3 + 1013904223;
            n11 = this.l >> 2;
            n10 = n11 & 0xF;
            n9 = n11 >> 8 & 0xF;
            n8 = this.e(n10 + n2, n9 + n);
            if (this.q(n10 + n2, n8 - 1, n9 + n)) {
                this.setTypeId(n10 + n2, n8 - 1, n9 + n, Block.ICE.id);
            }
            if (this.w() && this.r(n10 + n2, n8, n9 + n)) {
                this.setTypeId(n10 + n2, n8, n9 + n, Block.SNOW.id);
            }
            MethodProfiler.b("checkLight");
            this.s(n2 + this.random.nextInt(16), this.random.nextInt(this.height), n + this.random.nextInt(16));
            MethodProfiler.b("tickTiles");
            for (n11 = 0; n11 < 20; ++n11) {
                this.l = this.l * 3 + 1013904223;
                n10 = this.l >> 2;
                n9 = n10 & 0xF;
                n8 = n10 >> 8 & 0xF;
                n7 = n10 >> 16 & this.heightMinusOne;
                int n12 = chunk.b[n9 << this.heightBitsPlusFour | n8 << this.heightBits | n7] & 0xFF;
                ++n6;
                if (!Block.n[n12]) continue;
                ++n3;
                Block.byId[n12].a(this, n9 + n2, n7, n8 + n, this.random);
            }
            MethodProfiler.a();
        }
    }

    public boolean p(int n, int n2, int n3) {
        return this.c(n, n2, n3, false);
    }

    public boolean q(int n, int n2, int n3) {
        return this.c(n, n2, n3, true);
    }

    public boolean c(int n, int n2, int n3, boolean bl) {
        int n4;
        float f = this.getWorldChunkManager().a(n, n2, n3);
        if (f > 0.15f) {
            return false;
        }
        if (n2 >= 0 && n2 < this.height && this.a(EnumSkyBlock.BLOCK, n, n2, n3) < 10 && ((n4 = this.getTypeId(n, n2, n3)) == Block.STATIONARY_WATER.id || n4 == Block.WATER.id) && this.getData(n, n2, n3) == 0) {
            if (!bl) {
                return true;
            }
            boolean bl2 = true;
            if (bl2 && this.getMaterial(n - 1, n2, n3) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n + 1, n2, n3) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n, n2, n3 - 1) != Material.WATER) {
                bl2 = false;
            }
            if (bl2 && this.getMaterial(n, n2, n3 + 1) != Material.WATER) {
                bl2 = false;
            }
            if (!bl2) {
                return true;
            }
        }
        return false;
    }

    public boolean r(int n, int n2, int n3) {
        float f = this.getWorldChunkManager().a(n, n2, n3);
        if (f > 0.15f) {
            return false;
        }
        if (n2 >= 0 && n2 < this.height && this.a(EnumSkyBlock.BLOCK, n, n2, n3) < 10) {
            int n4 = this.getTypeId(n, n2 - 1, n3);
            int n5 = this.getTypeId(n, n2, n3);
            if (n5 == 0 && Block.SNOW.canPlace(this, n, n2, n3) && n4 != 0 && n4 != Block.ICE.id && Block.byId[n4].material.isSolid()) {
                return true;
            }
        }
        return false;
    }

    public void s(int n, int n2, int n3) {
        if (!this.worldProvider.e) {
            this.b(EnumSkyBlock.SKY, n, n2, n3);
        }
        this.b(EnumSkyBlock.BLOCK, n, n2, n3);
    }

    private int d(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (this.isChunkLoaded(n2, n3, n4)) {
            n7 = 15;
        } else {
            if (n6 == 0) {
                n6 = 1;
            }
            for (int i = 0; i < 6; ++i) {
                int n8 = i % 2 * 2 - 1;
                int n9 = n2 + i / 2 % 3 / 2 * n8;
                int n10 = n3 + (i / 2 + 1) % 3 / 2 * n8;
                int n11 = n4 + (i / 2 + 2) % 3 / 2 * n8;
                int n12 = this.a(EnumSkyBlock.SKY, n9, n10, n11) - n6;
                if (n12 <= n7) continue;
                n7 = n12;
            }
        }
        return n7;
    }

    private int e(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Block.s[n5];
        int n8 = this.a(EnumSkyBlock.BLOCK, n2 - 1, n3, n4) - n6;
        int n9 = this.a(EnumSkyBlock.BLOCK, n2 + 1, n3, n4) - n6;
        int n10 = this.a(EnumSkyBlock.BLOCK, n2, n3 - 1, n4) - n6;
        int n11 = this.a(EnumSkyBlock.BLOCK, n2, n3 + 1, n4) - n6;
        int n12 = this.a(EnumSkyBlock.BLOCK, n2, n3, n4 - 1) - n6;
        int n13 = this.a(EnumSkyBlock.BLOCK, n2, n3, n4 + 1) - n6;
        if (n8 > n7) {
            n7 = n8;
        }
        if (n9 > n7) {
            n7 = n9;
        }
        if (n10 > n7) {
            n7 = n10;
        }
        if (n11 > n7) {
            n7 = n11;
        }
        if (n12 > n7) {
            n7 = n12;
        }
        if (n13 > n7) {
            n7 = n13;
        }
        return n7;
    }

    public void b(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.areChunksLoaded(n, n2, n3, 17)) {
            return;
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = this.a(enumSkyBlock, n, n2, n3);
        int n12 = 0;
        int n13 = n11;
        int n14 = this.getTypeId(n, n2, n3);
        int n15 = Block.q[n14];
        if (n15 == 0) {
            n15 = 1;
        }
        int n16 = 0;
        n16 = enumSkyBlock == EnumSkyBlock.SKY ? this.d(n13, n, n2, n3, n14, n15) : this.e(n13, n, n2, n3, n14, n15);
        n12 = n16;
        if (n12 > n11) {
            this.H[n10++] = 133152;
        } else if (n12 < n11) {
            if (enumSkyBlock != EnumSkyBlock.BLOCK) {
                // empty if block
            }
            this.H[n10++] = 133152 + (n11 << 18);
            while (n9 < n10) {
                n13 = this.H[n9++];
                n14 = (n13 & 0x3F) - 32 + n;
                n15 = (n13 >> 6 & 0x3F) - 32 + n2;
                n16 = (n13 >> 12 & 0x3F) - 32 + n3;
                n8 = n13 >> 18 & 0xF;
                n7 = this.a(enumSkyBlock, n14, n15, n16);
                if (n7 != n8) continue;
                this.a(enumSkyBlock, n14, n15, n16, 0);
                if (n8 <= 0) continue;
                n6 = n14 - n;
                n5 = n15 - n2;
                n4 = n16 - n3;
                if (n6 < 0) {
                    n6 = -n6;
                }
                if (n5 < 0) {
                    n5 = -n5;
                }
                if (n4 < 0) {
                    n4 = -n4;
                }
                if (n6 + n5 + n4 >= 17) continue;
                for (int i = 0; i < 6; ++i) {
                    int n17 = i % 2 * 2 - 1;
                    int n18 = n14 + i / 2 % 3 / 2 * n17;
                    int n19 = n15 + (i / 2 + 1) % 3 / 2 * n17;
                    int n20 = n16 + (i / 2 + 2) % 3 / 2 * n17;
                    n7 = this.a(enumSkyBlock, n18, n19, n20);
                    int n21 = Block.q[this.getTypeId(n18, n19, n20)];
                    if (n21 == 0) {
                        n21 = 1;
                    }
                    if (n7 != n8 - n21) continue;
                    this.H[n10++] = n18 - n + 32 + (n19 - n2 + 32 << 6) + (n20 - n3 + 32 << 12) + (n8 - n21 << 18);
                }
            }
            n9 = 0;
        }
        while (n9 < n10) {
            n11 = this.H[n9++];
            n12 = (n11 & 0x3F) - 32 + n;
            n13 = (n11 >> 6 & 0x3F) - 32 + n2;
            n14 = (n11 >> 12 & 0x3F) - 32 + n3;
            n15 = this.a(enumSkyBlock, n12, n13, n14);
            n16 = this.getTypeId(n12, n13, n14);
            n8 = Block.q[n16];
            if (n8 == 0) {
                n8 = 1;
            }
            n7 = 0;
            n7 = enumSkyBlock == EnumSkyBlock.SKY ? this.d(n15, n12, n13, n14, n16, n8) : this.e(n15, n12, n13, n14, n16, n8);
            if (n7 == n15) continue;
            this.a(enumSkyBlock, n12, n13, n14, n7);
            if (n7 <= n15) continue;
            n6 = n12 - n;
            n5 = n13 - n2;
            n4 = n14 - n3;
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n4 < 0) {
                n4 = -n4;
            }
            if (n6 + n5 + n4 >= 17 || n10 >= this.H.length - 6) continue;
            if (this.a(enumSkyBlock, n12 - 1, n13, n14) < n7) {
                this.H[n10++] = n12 - 1 - n + 32 + (n13 - n2 + 32 << 6) + (n14 - n3 + 32 << 12);
            }
            if (this.a(enumSkyBlock, n12 + 1, n13, n14) < n7) {
                this.H[n10++] = n12 + 1 - n + 32 + (n13 - n2 + 32 << 6) + (n14 - n3 + 32 << 12);
            }
            if (this.a(enumSkyBlock, n12, n13 - 1, n14) < n7) {
                this.H[n10++] = n12 - n + 32 + (n13 - 1 - n2 + 32 << 6) + (n14 - n3 + 32 << 12);
            }
            if (this.a(enumSkyBlock, n12, n13 + 1, n14) < n7) {
                this.H[n10++] = n12 - n + 32 + (n13 + 1 - n2 + 32 << 6) + (n14 - n3 + 32 << 12);
            }
            if (this.a(enumSkyBlock, n12, n13, n14 - 1) < n7) {
                this.H[n10++] = n12 - n + 32 + (n13 - n2 + 32 << 6) + (n14 - 1 - n3 + 32 << 12);
            }
            if (this.a(enumSkyBlock, n12, n13, n14 + 1) >= n7) continue;
            this.H[n10++] = n12 - n + 32 + (n13 - n2 + 32 << 6) + (n14 + 1 - n3 + 32 << 12);
        }
    }

    public boolean a(boolean bl) {
        int n = this.K.size();
        if (n != this.L.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 1000) {
            n = 1000;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            NextTickListEntry nextTickListEntry = (NextTickListEntry)this.K.first();
            if (!bl && nextTickListEntry.e > this.worldData.f()) break;
            this.K.remove(nextTickListEntry);
            this.L.remove(nextTickListEntry);
            int n3 = 8;
            if (!this.a(nextTickListEntry.a - n3, nextTickListEntry.b - n3, nextTickListEntry.c - n3, nextTickListEntry.a + n3, nextTickListEntry.b + n3, nextTickListEntry.c + n3) || (n2 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) != nextTickListEntry.d || n2 <= 0) continue;
            Block.byId[n2].a(this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
        }
        return this.K.size() != 0;
    }

    public List a(Chunk chunk, boolean bl) {
        ArrayList<NextTickListEntry> arrayList = null;
        ChunkCoordIntPair chunkCoordIntPair = chunk.j();
        int n = chunkCoordIntPair.x << 4;
        int n2 = n + 16;
        int n3 = chunkCoordIntPair.z << 4;
        int n4 = n3 + 16;
        Iterator iterator = this.L.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
            if (nextTickListEntry.a < n || nextTickListEntry.a >= n2 || nextTickListEntry.c < n3 || nextTickListEntry.c >= n4) continue;
            if (bl) {
                this.K.remove(nextTickListEntry);
                iterator.remove();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<NextTickListEntry>();
            }
            arrayList.add(nextTickListEntry);
        }
        return arrayList;
    }

    public List b(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.V.clear();
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(entity, axisAlignedBB, this.V);
            }
        }
        return this.V;
    }

    public List a(Class clazz, AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        ArrayList arrayList = new ArrayList();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(clazz, axisAlignedBB, arrayList);
            }
        }
        return arrayList;
    }

    public void b(int n, int n2, int n3, TileEntity tileEntity) {
        if (this.isLoaded(n, n2, n3)) {
            this.getChunkAtWorldCoords(n, n3).f();
        }
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(n, n2, n3, tileEntity);
        }
    }

    public int a(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.entityList.size(); ++i) {
            Entity entity = (Entity)this.entityList.get(i);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++n;
        }
        return n;
    }

    public void a(List list) {
        this.entityList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.c((Entity)list.get(i));
        }
    }

    public void b(List list) {
        this.J.addAll(list);
    }

    public boolean a(int n, int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = this.getTypeId(n2, n3, n4);
        Block block = Block.byId[n6];
        Block block2 = Block.byId[n];
        AxisAlignedBB axisAlignedBB = block2.e(this, n2, n3, n4);
        if (bl) {
            axisAlignedBB = null;
        }
        if (axisAlignedBB != null && !this.containsEntity(axisAlignedBB)) {
            return false;
        }
        if (block == Block.WATER || block == Block.STATIONARY_WATER || block == Block.LAVA || block == Block.STATIONARY_LAVA || block == Block.FIRE || block == Block.SNOW || block == Block.VINE) {
            block = null;
        }
        return n > 0 && block == null && block2.canPlace(this, n2, n3, n4, n5);
    }

    public PathEntity findPath(Entity entity, Entity entity2, float f) {
        MethodProfiler.a("pathfind");
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locY);
        int n3 = MathHelper.floor(entity.locZ);
        int n4 = (int)(f + 16.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        ChunkCache chunkCache = new ChunkCache(this, n5, n6, n7, n8, n9, n10);
        PathEntity pathEntity = new Pathfinder(chunkCache).a(entity, entity2, f);
        MethodProfiler.a();
        return pathEntity;
    }

    public PathEntity a(Entity entity, int n, int n2, int n3, float f) {
        MethodProfiler.a("pathfind");
        int n4 = MathHelper.floor(entity.locX);
        int n5 = MathHelper.floor(entity.locY);
        int n6 = MathHelper.floor(entity.locZ);
        int n7 = (int)(f + 8.0f);
        int n8 = n4 - n7;
        int n9 = n5 - n7;
        int n10 = n6 - n7;
        int n11 = n4 + n7;
        int n12 = n5 + n7;
        int n13 = n6 + n7;
        ChunkCache chunkCache = new ChunkCache(this, n8, n9, n10, n11, n12, n13);
        PathEntity pathEntity = new Pathfinder(chunkCache).a(entity, n, n2, n3, f);
        MethodProfiler.a();
        return pathEntity;
    }

    public boolean isBlockFacePowered(int n, int n2, int n3, int n4) {
        int n5 = this.getTypeId(n, n2, n3);
        if (n5 == 0) {
            return false;
        }
        return Block.byId[n5].d(this, n, n2, n3, n4);
    }

    public boolean isBlockPowered(int n, int n2, int n3) {
        if (this.isBlockFacePowered(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (this.isBlockFacePowered(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (this.isBlockFacePowered(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (this.isBlockFacePowered(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (this.isBlockFacePowered(n - 1, n2, n3, 4)) {
            return true;
        }
        return this.isBlockFacePowered(n + 1, n2, n3, 5);
    }

    public boolean isBlockFaceIndirectlyPowered(int n, int n2, int n3, int n4) {
        if (this.e(n, n2, n3)) {
            return this.isBlockPowered(n, n2, n3);
        }
        int n5 = this.getTypeId(n, n2, n3);
        if (n5 == 0) {
            return false;
        }
        return Block.byId[n5].a((IBlockAccess)this, n, n2, n3, n4);
    }

    public boolean isBlockIndirectlyPowered(int n, int n2, int n3) {
        if (this.isBlockFaceIndirectlyPowered(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (this.isBlockFaceIndirectlyPowered(n - 1, n2, n3, 4)) {
            return true;
        }
        return this.isBlockFaceIndirectlyPowered(n + 1, n2, n3, 5);
    }

    public EntityHuman findNearbyPlayer(Entity entity, double d) {
        return this.a(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman a(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            double d6 = entityHuman2.e(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman b(Entity entity, double d) {
        return this.b(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman b(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            if (entityHuman2.abilities.isInvulnerable) continue;
            double d6 = entityHuman2.e(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman a(String string) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!string.equals(((EntityHuman)this.players.get((int)i)).name)) continue;
            return (EntityHuman)this.players.get(i);
        }
        return null;
    }

    public byte[] getMultiChunkData(int n, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = new byte[n4 * n5 * n6 * 5 / 2];
        int n7 = n >> 4;
        int n8 = n3 >> 4;
        int n9 = n + n4 - 1 >> 4;
        int n10 = n3 + n6 - 1 >> 4;
        int n11 = 0;
        int n12 = n2;
        int n13 = n2 + n5;
        if (n12 < 0) {
            n12 = 0;
        }
        if (n13 > this.height) {
            n13 = this.height;
        }
        for (int i = n7; i <= n9; ++i) {
            int n14 = n - i * 16;
            int n15 = n + n4 - i * 16;
            if (n14 < 0) {
                n14 = 0;
            }
            if (n15 > 16) {
                n15 = 16;
            }
            for (int j = n8; j <= n10; ++j) {
                int n16 = n3 - j * 16;
                int n17 = n3 + n6 - j * 16;
                if (n16 < 0) {
                    n16 = 0;
                }
                if (n17 > 16) {
                    n17 = 16;
                }
                n11 = this.getChunkAt(i, j).getData(byArray, n14, n12, n16, n15, n13, n17, n11);
            }
        }
        return byArray;
    }

    public void l() {
        this.B.b();
    }

    public void setTime(long l) {
        this.worldData.a(l);
    }

    public void setTimeAndFixTicklists(long l) {
        long l2 = l - this.worldData.f();
        for (NextTickListEntry nextTickListEntry : this.L) {
            nextTickListEntry.e += l2;
        }
        this.setTime(l);
    }

    public long getSeed() {
        return this.worldData.getSeed();
    }

    public long getTime() {
        return this.worldData.f();
    }

    public ChunkCoordinates getSpawn() {
        return new ChunkCoordinates(this.worldData.c(), this.worldData.d(), this.worldData.e());
    }

    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        return true;
    }

    public void a(Entity entity, byte by) {
    }

    public IChunkProvider p() {
        return this.chunkProvider;
    }

    public void playNote(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getTypeId(n, n2, n3);
        if (n6 > 0) {
            Block.byId[n6].a(this, n, n2, n3, n4, n5);
        }
    }

    public IDataManager q() {
        return this.B;
    }

    public WorldData r() {
        return this.worldData;
    }

    public void everyoneSleeping() {
        this.Q = !this.players.isEmpty();
        for (EntityHuman entityHuman : this.players) {
            if (entityHuman.isSleeping()) continue;
            this.Q = false;
            break;
        }
    }

    protected void t() {
        this.Q = false;
        for (EntityHuman entityHuman : this.players) {
            if (!entityHuman.isSleeping()) continue;
            entityHuman.a(false, false, true);
        }
        this.A();
    }

    public boolean everyoneDeeplySleeping() {
        if (this.Q && !this.isStatic) {
            for (EntityHuman entityHuman : this.players) {
                if (entityHuman.isDeeplySleeping()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public float c(float f) {
        return (this.p + (this.q - this.p) * f) * this.d(f);
    }

    public float d(float f) {
        return this.n + (this.o - this.n) * f;
    }

    public boolean v() {
        return (double)this.c(1.0f) > 0.9;
    }

    public boolean w() {
        return (double)this.d(1.0f) > 0.2;
    }

    public boolean v(int n, int n2, int n3) {
        if (!this.w()) {
            return false;
        }
        if (!this.isChunkLoaded(n, n2, n3)) {
            return false;
        }
        if (this.e(n, n3) > n2) {
            return false;
        }
        BiomeBase biomeBase = this.getWorldChunkManager().getBiome(n, n3);
        if (biomeBase.b()) {
            return false;
        }
        return biomeBase.c();
    }

    public void a(String string, WorldMapBase worldMapBase) {
        this.worldMaps.a(string, worldMapBase);
    }

    public WorldMapBase a(Class clazz, String string) {
        return this.worldMaps.a(clazz, string);
    }

    public int b(String string) {
        return this.worldMaps.a(string);
    }

    public void f(int n, int n2, int n3, int n4, int n5) {
        this.a(null, n, n2, n3, n4, n5);
    }

    public void a(EntityHuman entityHuman, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.z.size(); ++i) {
            ((IWorldAccess)this.z.get(i)).a(entityHuman, n, n2, n3, n4, n5);
        }
    }

    public Random w(int n, int n2, int n3) {
        long l = (long)n * 341873128712L + (long)n2 * 132897987541L + this.r().getSeed() + (long)n3;
        this.random.setSeed(l);
        return this.random;
    }

    public boolean x() {
        return false;
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public BiomeMeta a(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        List list = this.p().a(enumCreatureType, n, n2, n3);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (BiomeMeta)WeightedRandom.a(this.random, list);
    }

    public ChunkPosition b(String string, int n, int n2, int n3) {
        return this.p().a(this, string, n, n2, n3);
    }
}

