/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.ChunkProviderServer;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityList;
import net.minecraft.server.EntityWaterAnimal;
import net.minecraft.server.Explosion;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IDataManager;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Packet38EntityStatus;
import net.minecraft.server.Packet54PlayNoteBlock;
import net.minecraft.server.Packet60Explosion;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet71Weather;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldSettings;

public class WorldServer
extends World {
    public ChunkProviderServer chunkProviderServer;
    public boolean weirdIsOpCache = false;
    public boolean savingDisabled;
    private MinecraftServer server;
    private EntityList N = new EntityList();

    public WorldServer(MinecraftServer minecraftServer, IDataManager iDataManager, String string, int n, WorldSettings worldSettings) {
        super(iDataManager, string, worldSettings, WorldProvider.byDimension(n));
        this.server = minecraftServer;
    }

    public void entityJoinedWorld(Entity entity, boolean bl) {
        if (!this.server.spawnAnimals && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
            entity.die();
        }
        if (entity.passenger == null || !(entity.passenger instanceof EntityHuman)) {
            super.entityJoinedWorld(entity, bl);
        }
    }

    public void vehicleEnteredWorld(Entity entity, boolean bl) {
        super.entityJoinedWorld(entity, bl);
    }

    protected IChunkProvider b() {
        IChunkLoader iChunkLoader = this.B.a(this.worldProvider);
        this.chunkProviderServer = new ChunkProviderServer(this, iChunkLoader, this.worldProvider.getChunkProvider());
        return this.chunkProviderServer;
    }

    public List getTileEntities(int n, int n2, int n3, int n4, int n5, int n6) {
        ArrayList<TileEntity> arrayList = new ArrayList<TileEntity>();
        for (int i = 0; i < this.h.size(); ++i) {
            TileEntity tileEntity = (TileEntity)this.h.get(i);
            if (tileEntity.x < n || tileEntity.y < n2 || tileEntity.z < n3 || tileEntity.x >= n4 || tileEntity.y >= n5 || tileEntity.z >= n6) continue;
            arrayList.add(tileEntity);
        }
        return arrayList;
    }

    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        int n4;
        int n5 = MathHelper.a(n - this.worldData.c());
        if (n5 > (n4 = MathHelper.a(n3 - this.worldData.e()))) {
            n4 = n5;
        }
        return n4 > 16 || this.server.serverConfigurationManager.isOp(entityHuman.name);
    }

    protected void c(Entity entity) {
        super.c(entity);
        this.N.a(entity.id, entity);
        Entity[] entityArray = entity.aG();
        if (entityArray != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.N.a(entityArray[i].id, entityArray[i]);
            }
        }
    }

    protected void d(Entity entity) {
        super.d(entity);
        this.N.d(entity.id);
        Entity[] entityArray = entity.aG();
        if (entityArray != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.N.d(entityArray[i].id);
            }
        }
    }

    public Entity getEntity(int n) {
        return (Entity)this.N.a(n);
    }

    public boolean strikeLightning(Entity entity) {
        if (super.strikeLightning(entity)) {
            this.server.serverConfigurationManager.sendPacketNearby(entity.locX, entity.locY, entity.locZ, 512.0, this.worldProvider.dimension, new Packet71Weather(entity));
            return true;
        }
        return false;
    }

    public void a(Entity entity, byte by) {
        Packet38EntityStatus packet38EntityStatus = new Packet38EntityStatus(entity.id, by);
        this.server.getTracker(this.worldProvider.dimension).sendPacketToEntity(entity, packet38EntityStatus);
    }

    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.a();
        explosion.a(false);
        this.server.serverConfigurationManager.sendPacketNearby(d, d2, d3, 64.0, this.worldProvider.dimension, new Packet60Explosion(d, d2, d3, f, explosion.blocks));
        return explosion;
    }

    public void playNote(int n, int n2, int n3, int n4, int n5) {
        super.playNote(n, n2, n3, n4, n5);
        this.server.serverConfigurationManager.sendPacketNearby(n, n2, n3, 64.0, this.worldProvider.dimension, new Packet54PlayNoteBlock(n, n2, n3, n4, n5));
    }

    public void saveLevel() {
        this.B.e();
    }

    protected void i() {
        boolean bl = this.w();
        super.i();
        if (bl != this.w()) {
            if (bl) {
                this.server.serverConfigurationManager.sendAll(new Packet70Bed(2, 0));
            } else {
                this.server.serverConfigurationManager.sendAll(new Packet70Bed(1, 0));
            }
        }
    }
}

