/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringMap<V>
extends AbstractMap<String, V> {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private LinkedEntry<V> header;
    private static final Map.Entry[] EMPTY_TABLE = new LinkedEntry[2];
    private LinkedEntry<V>[] table = (LinkedEntry[])EMPTY_TABLE;
    private int size;
    private int threshold = -1;
    private Set<String> keySet;
    private Set<Map.Entry<String, V>> entrySet;
    private Collection<V> values;
    private static final int seed = new Random().nextInt();

    public StringMap() {
        this.header = new LinkedEntry();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.getEntry((String)key) != null;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            LinkedEntry<V> entry = this.getEntry((String)key);
            return entry != null ? (V)entry.value : null;
        }
        return null;
    }

    private LinkedEntry<V> getEntry(String key) {
        if (key == null) {
            return null;
        }
        int hash = StringMap.hash(key);
        LinkedEntry<V>[] tab = this.table;
        LinkedEntry<V> e2 = tab[hash & tab.length - 1];
        while (e2 != null) {
            String eKey = e2.key;
            if (eKey == key || e2.hash == hash && key.equals(eKey)) {
                return e2;
            }
            e2 = e2.next;
        }
        return null;
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int hash = StringMap.hash(key);
        LinkedEntry<V>[] tab = this.table;
        int index = hash & tab.length - 1;
        LinkedEntry<V> e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && key.equals(e2.key)) {
                Object oldValue = e2.value;
                e2.value = value;
                return oldValue;
            }
            e2 = e2.next;
        }
        if (this.size++ > this.threshold) {
            tab = this.doubleCapacity();
            index = hash & tab.length - 1;
        }
        this.addNewEntry(key, value, hash, index);
        return null;
    }

    private void addNewEntry(String key, V value, int hash, int index) {
        LinkedEntry<V> header = this.header;
        LinkedEntry oldTail = header.prv;
        LinkedEntry<V> newTail = new LinkedEntry<V>(key, value, hash, this.table[index], header, oldTail);
        header.prv = newTail;
        oldTail.nxt = header.prv;
        this.table[index] = header.prv;
    }

    private LinkedEntry<V>[] makeTable(int newCapacity) {
        LinkedEntry[] newTable = new LinkedEntry[newCapacity];
        this.table = newTable;
        this.threshold = (newCapacity >> 1) + (newCapacity >> 2);
        return newTable;
    }

    private LinkedEntry<V>[] doubleCapacity() {
        LinkedEntry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity * 2;
        LinkedEntry<V>[] newTable = this.makeTable(newCapacity);
        if (this.size == 0) {
            return newTable;
        }
        for (int j2 = 0; j2 < oldCapacity; ++j2) {
            LinkedEntry<V> e2 = oldTable[j2];
            if (e2 == null) continue;
            int highBit = e2.hash & oldCapacity;
            LinkedEntry<V> broken = null;
            newTable[j2 | highBit] = e2;
            LinkedEntry n2 = e2.next;
            while (n2 != null) {
                int nextHighBit = n2.hash & oldCapacity;
                if (nextHighBit != highBit) {
                    if (broken == null) {
                        newTable[j2 | nextHighBit] = n2;
                    } else {
                        broken.next = n2;
                    }
                    broken = e2;
                    highBit = nextHighBit;
                }
                e2 = n2;
                n2 = n2.next;
            }
            if (broken == null) continue;
            broken.next = null;
        }
        return newTable;
    }

    @Override
    public V remove(Object key) {
        if (key == null || !(key instanceof String)) {
            return null;
        }
        int hash = StringMap.hash((String)key);
        LinkedEntry<V>[] tab = this.table;
        int index = hash & tab.length - 1;
        LinkedEntry<V> e2 = tab[index];
        LinkedEntry<V> prev = null;
        while (e2 != null) {
            if (e2.hash == hash && key.equals(e2.key)) {
                if (prev == null) {
                    tab[index] = e2.next;
                } else {
                    prev.next = e2.next;
                }
                --this.size;
                this.unlink(e2);
                return e2.value;
            }
            prev = e2;
            e2 = e2.next;
        }
        return null;
    }

    private void unlink(LinkedEntry<V> e2) {
        e2.prv.nxt = e2.nxt;
        e2.nxt.prv = e2.prv;
        e2.prv = null;
        e2.nxt = null;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            this.size = 0;
        }
        LinkedEntry<V> header = this.header;
        LinkedEntry e2 = header.nxt;
        while (e2 != header) {
            LinkedEntry nxt = e2.nxt;
            e2.prv = null;
            e2.nxt = null;
            e2 = nxt;
        }
        header.prv = header;
        header.nxt = header.prv;
    }

    @Override
    public Set<String> keySet() {
        KeySet ks2 = this.keySet;
        return ks2 != null ? ks2 : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        EntrySet es2 = this.entrySet;
        return es2 != null ? es2 : (this.entrySet = new EntrySet());
    }

    private boolean removeMapping(Object key, Object value) {
        if (key == null || !(key instanceof String)) {
            return false;
        }
        int hash = StringMap.hash((String)key);
        LinkedEntry<V>[] tab = this.table;
        int index = hash & tab.length - 1;
        LinkedEntry<V> e2 = tab[index];
        LinkedEntry<V> prev = null;
        while (e2 != null) {
            if (e2.hash == hash && key.equals(e2.key)) {
                if (value == null ? e2.value != null : !value.equals(e2.value)) {
                    return false;
                }
                if (prev == null) {
                    tab[index] = e2.next;
                } else {
                    prev.next = e2.next;
                }
                --this.size;
                this.unlink(e2);
                return true;
            }
            prev = e2;
            e2 = e2.next;
        }
        return false;
    }

    private static int hash(String key) {
        int h2 = seed;
        for (int i2 = 0; i2 < key.length(); ++i2) {
            int h22 = h2 + key.charAt(i2);
            int h3 = h22 + h22 << 10;
            h2 = h3 ^ h3 >>> 6;
        }
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        return h2 ^ h2 >>> 7 ^ h2 >>> 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new LinkedHashIterator<Map.Entry<String, V>>(){

                @Override
                public final Map.Entry<String, V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object mappedValue = StringMap.this.get(e2.getKey());
            return mappedValue != null && mappedValue.equals(e2.getValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return StringMap.this.removeMapping(e2.getKey(), e2.getValue());
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public final V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return StringMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new LinkedHashIterator<String>(){

                @Override
                public final String next() {
                    return this.nextEntry().key;
                }
            };
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return StringMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            int oldSize = StringMap.this.size;
            StringMap.this.remove(o2);
            return StringMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        LinkedEntry<V> next;
        LinkedEntry<V> lastReturned;

        private LinkedHashIterator() {
            this.next = ((StringMap)StringMap.this).header.nxt;
            this.lastReturned = null;
        }

        @Override
        public final boolean hasNext() {
            return this.next != StringMap.this.header;
        }

        final LinkedEntry<V> nextEntry() {
            LinkedEntry e2 = this.next;
            if (e2 == StringMap.this.header) {
                throw new NoSuchElementException();
            }
            this.next = e2.nxt;
            this.lastReturned = e2;
            return this.lastReturned;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            StringMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkedEntry<V>
    implements Map.Entry<String, V> {
        final String key;
        V value;
        final int hash;
        LinkedEntry<V> next;
        LinkedEntry<V> nxt;
        LinkedEntry<V> prv;

        LinkedEntry() {
            this(null, null, 0, null, null, null);
            this.prv = this;
            this.nxt = this.prv;
        }

        LinkedEntry(String key, V value, int hash, LinkedEntry<V> next, LinkedEntry<V> nxt, LinkedEntry<V> prv) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
            this.nxt = nxt;
            this.prv = prv;
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object eValue = e2.getValue();
            return this.key.equals(e2.getKey()) && (this.value == null ? eValue == null : this.value.equals(eValue));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

