/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private final int blockSize;
    private final BlockCipher cipher;
    boolean firstStep = true;
    int N3;
    int N4;
    static final int C1 = 0x1010104;
    static final int C2 = 0x1010101;

    public GOFBBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        if (this.blockSize != 8) {
            throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
        }
        this.IV = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.IV.length) {
                System.arraycopy(byArray, 0, this.IV, this.IV.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.IV.length - byArray.length; ++i2) {
                    this.IV[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.cipher.init(true, cipherParameters);
            }
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.firstStep) {
            this.firstStep = false;
            this.cipher.processBlock(this.ofbV, 0, this.ofbOutV, 0);
            this.N3 = this.bytesToint(this.ofbOutV, 0);
            this.N4 = this.bytesToint(this.ofbOutV, 4);
        }
        this.N3 += 0x1010101;
        this.N4 += 0x1010104;
        this.intTobytes(this.N3, this.ofbV, 0);
        this.intTobytes(this.N4, this.ofbV, 4);
        this.cipher.processBlock(this.ofbV, 0, this.ofbOutV, 0);
        for (int i2 = 0; i2 < this.blockSize; ++i2) {
            byArray2[n3 + i2] = (byte)(this.ofbOutV[i2] ^ byArray[n2 + i2]);
        }
        System.arraycopy(this.ofbV, this.blockSize, this.ofbV, 0, this.ofbV.length - this.blockSize);
        System.arraycopy(this.ofbOutV, 0, this.ofbV, this.ofbV.length - this.blockSize, this.blockSize);
        return this.blockSize;
    }

    public void reset() {
        System.arraycopy(this.IV, 0, this.ofbV, 0, this.IV.length);
        this.cipher.reset();
    }

    private int bytesToint(byte[] byArray, int n2) {
        return (byArray[n2 + 3] << 24 & 0xFF000000) + (byArray[n2 + 2] << 16 & 0xFF0000) + (byArray[n2 + 1] << 8 & 0xFF00) + (byArray[n2] & 0xFF);
    }

    private void intTobytes(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >>> 24);
        byArray[n3 + 2] = (byte)(n2 >>> 16);
        byArray[n3 + 1] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }
}

