/*
 * Decompiled with CFR 0.152.
 */
package argo.staj;

import argo.saj.InvalidSyntaxException;
import argo.saj.SajParser;
import argo.staj.BlockingJsonListener;
import argo.staj.Element;
import argo.staj.JsonStreamElementType;
import argo.staj.JsonStreamException;
import argo.staj.JsonStreamReader;
import java.io.IOException;
import java.io.Reader;

public final class StajParser
implements JsonStreamReader {
    private final BlockingJsonListener blockingJsonListener = new BlockingJsonListener();
    private Element next;

    public StajParser(final Reader in2) {
        new Thread("Argo StajParser"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    new SajParser().parse(in2, StajParser.this.blockingJsonListener);
                }
                catch (InvalidSyntaxException e2) {
                    StajParser.this.blockingJsonListener.invalidSyntaxException(e2);
                }
                catch (IOException e3) {
                    StajParser.this.blockingJsonListener.ioException(e3);
                }
                catch (RuntimeException e4) {
                    StajParser.this.blockingJsonListener.runtimeException(e4);
                }
                finally {
                    StajParser.this.blockingJsonListener.close();
                }
            }
        }.start();
    }

    @Override
    public JsonStreamElementType next() throws JsonStreamException {
        try {
            this.next = this.blockingJsonListener.getNext();
        }
        catch (IOException e2) {
            throw new JsonStreamException(e2);
        }
        catch (InvalidSyntaxException e3) {
            throw new JsonStreamException(e3);
        }
        return this.next.getJsonStreamElementType();
    }

    @Override
    public boolean hasNext() throws JsonStreamException {
        try {
            return this.blockingJsonListener.hasNext();
        }
        catch (IOException e2) {
            throw new JsonStreamException(e2);
        }
        catch (InvalidSyntaxException e3) {
            throw new JsonStreamException(e3);
        }
    }

    @Override
    public void close() {
        this.blockingJsonListener.close();
    }

    @Override
    public JsonStreamElementType getElementType() {
        if (this.next == null) {
            throw new IllegalStateException("Attempt to get element type of current element before first call to next().");
        }
        return this.next.getJsonStreamElementType();
    }

    @Override
    public String getText() {
        if (this.next == null) {
            throw new IllegalStateException("Attempt to get text of current element before first call to next().");
        }
        return this.next.getText();
    }

    @Override
    public boolean hasText() {
        if (this.next == null) {
            throw new IllegalStateException("Attempt to determine whether current element has text before first call to next().");
        }
        return this.next.hasText();
    }
}

